/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.plugins.core;

import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.cfscript.script.CFSwitchStatement;
import com.cflint.BugList;
import com.cflint.plugins.CFLintScannerAdapter;
import com.cflint.plugins.Context;
import net.htmlparser.jericho.Element;

public class CFSwitchDefaultChecker
extends CFLintScannerAdapter {
    final String CFML_TAG_CHECK = "cfswitch";
    final String CFML_TAG_REQUIRED = "cfdefaultcase";
    final String CFSCRIPT_STATEMENT_REQUIRED = "default";
    final String SEVERITY = "WARNING";
    final String MESSAGE_CODE = "NO_DEFAULT_INSIDE_SWITCH";
    final String MESSAGE = "Not having a Default statement defined for a switch could pose potential issues";

    @Override
    public void expression(CFScriptStatement expression, Context context, BugList bugs) {
        CFSwitchStatement switchStatement;
        String statement;
        if (expression instanceof CFSwitchStatement && !(statement = (switchStatement = (CFSwitchStatement)expression).Decompile(0).replace(" ", "").toLowerCase()).contains("default")) {
            context.addMessage("NO_DEFAULT_INSIDE_SWITCH", null);
        }
    }

    @Override
    public void element(Element element, Context context, BugList bugs) {
        String tagName = element.getName();
        if (tagName.equalsIgnoreCase("cfswitch")) {
            boolean isDefault = false;
            for (Element el : element.getChildElements()) {
                if (!el.getName().equalsIgnoreCase("cfdefaultcase")) continue;
                isDefault = true;
                break;
            }
            if (!isDefault) {
                context.addMessage("NO_DEFAULT_INSIDE_SWITCH", null);
            }
        }
    }
}

