/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.plugins.core;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFScriptStatement;
import com.cflint.BugInfo;
import com.cflint.BugList;
import com.cflint.plugins.CFLintScannerAdapter;
import com.cflint.plugins.Context;
import net.htmlparser.jericho.Element;
import ro.fortsoft.pf4j.Extension;

@Extension
public class CFTagLowercaseChecker
extends CFLintScannerAdapter {
    final String messageCode = "CFTAG_SHOULD_BE_LOWERCASE";
    final String severity = "WARNING";

    @Override
    public void expression(CFExpression expression, Context context, BugList bugs) {
    }

    @Override
    public void expression(CFScriptStatement expression, Context context, BugList bugs) {
    }

    @Override
    public void element(Element element, Context context, BugList bugs) {
        String tag = element.getStartTag().toString();
        if (tag.substring(1, 3).equalsIgnoreCase("cf")) {
            String upperCase;
            String cfTag;
            int index = tag.indexOf(" ");
            if (index == -1) {
                index = tag.indexOf(">");
            }
            if ((cfTag = tag.substring(1, index)).equals(upperCase = cfTag.toUpperCase())) {
                int begLine = element.getSource().getRow(element.getBegin());
                bugs.add(new BugInfo.BugInfoBuilder().setLine(begLine).setMessageCode("CFTAG_SHOULD_BE_LOWERCASE").setSeverity("WARNING").setFilename(context.getFilename()).setMessage("Tag <" + cfTag + "> should be written in lowercase or camelCase for consistency in code.").build());
            }
        }
    }
}

