/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.plugins.core;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFCompoundStatement;
import cfml.parsing.cfscript.script.CFFuncDeclStatement;
import cfml.parsing.cfscript.script.CFScriptStatement;
import com.cflint.BugInfo;
import com.cflint.BugList;
import com.cflint.plugins.CFLintScannerAdapter;
import com.cflint.plugins.Context;
import net.htmlparser.jericho.Element;
import ro.fortsoft.pf4j.Extension;

@Extension
public class FunctionLengthChecker
extends CFLintScannerAdapter {
    final int LENGTH_THRESHOLD = 100;
    final String severity = "INFO";

    @Override
    public void expression(CFExpression expression, Context context, BugList bugs) {
    }

    @Override
    public void expression(CFScriptStatement expression, Context context, BugList bugs) {
        if (expression instanceof CFFuncDeclStatement) {
            CFFuncDeclStatement function = (CFFuncDeclStatement)expression;
            String decompile = function.Decompile(1);
            int begLine = function.getLine();
            String[] lines = decompile.split("\\n");
            CFCompoundStatement body = (CFCompoundStatement)function.getBody();
            if (lines.length > 100) {
                bugs.add(new BugInfo.BugInfoBuilder().setLine(begLine).setMessageCode("EXCESSIVE_FUNCTION_LENGTH").setSeverity("INFO").setFilename(context.getFilename()).setMessage("Function is " + lines.length + " lines. Should be less than " + 100 + " lines.").build());
            }
        }
    }

    @Override
    public void element(Element element, Context context, BugList bugs) {
        String elementName = element.getName();
        if (elementName.equals("cffunction")) {
            int begLine = element.getSource().getRow(element.getBegin());
            int total = element.getAllStartTags().size();
            if (total > 100) {
                bugs.add(new BugInfo.BugInfoBuilder().setLine(begLine).setMessageCode("EXCESSIVE_FUNCTION_LENGTH").setSeverity("INFO").setFilename(context.getFilename()).setMessage("Function is " + total + " lines. Should be less than " + 100 + " lines.").build());
            }
        }
    }
}

