/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.plugins.core;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFFunctionExpression;
import com.cflint.BugList;
import com.cflint.plugins.CFLintScannerAdapter;
import com.cflint.plugins.Context;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Element;

public class QueryParamChecker
extends CFLintScannerAdapter {
    @Override
    public void expression(CFExpression expression, Context context, BugList bugs) {
        CFFunctionExpression functionExpression;
        if (expression instanceof CFFunctionExpression && (functionExpression = (CFFunctionExpression)expression).getFunctionName().equalsIgnoreCase("setSql") && functionExpression.getArgs().size() > 0) {
            CFExpression argsExpression = (CFExpression)functionExpression.getArgs().get(0);
            Pattern p = Pattern.compile(".*#[^#].*", 32);
            if (p.matcher(argsExpression.Decompile(0)).matches()) {
                context.addMessage("QUERYPARAM_REQ", functionExpression.getName());
            }
        }
    }

    @Override
    public void element(Element element, Context context, BugList bugs) {
        String content;
        if (element.getName().equals("cfquery") && !"query".equalsIgnoreCase(element.getAttributeValue("dbtype")) && (content = element.getTextExtractor().toString()).indexOf("#") > 0) {
            Pattern pattern = Pattern.compile("#(.+?)#");
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                if (matcher.groupCount() < 1) continue;
                String variableName = matcher.group(1);
                context.addMessage("CFQUERYPARAM_REQ", variableName);
            }
        }
    }
}

