/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.plugins.core;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFScriptStatement;
import com.cflint.BugInfo;
import com.cflint.BugList;
import com.cflint.plugins.CFLintScannerAdapter;
import com.cflint.plugins.Context;
import net.htmlparser.jericho.Element;
import ro.fortsoft.pf4j.Extension;

@Extension
public class ScriptTagChecker
extends CFLintScannerAdapter {
    final String message = "Don't use inline <script> tags";
    final String severity = "ERROR";

    @Override
    public void expression(CFExpression expression, Context context, BugList bugs) {
    }

    @Override
    public void expression(CFScriptStatement expression, Context context, BugList bugs) {
    }

    @Override
    public void element(Element element, Context context, BugList bugs) {
        String src;
        if (element.getName().equals("script") && !(src = element.getStartTag().toString()).matches(".*src=.*")) {
            int endLine = element.getSource().getRow(element.getEnd());
            int begLine = element.getSource().getRow(element.getBegin());
            int total = endLine - begLine;
            bugs.add(new BugInfo.BugInfoBuilder().setLine(begLine).setMessageCode("AVOID_USING_INLINE_JS").setSeverity("ERROR").setFilename(context.getFilename()).setMessage("Don't use inline <script> tags").build());
        }
    }
}

