/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.plugins.core;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFFullVarExpression;
import cfml.parsing.cfscript.CFIdentifier;
import com.cflint.BugList;
import com.cflint.plugins.CFLintScannerAdapter;
import com.cflint.plugins.Context;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.Element;

public class VarScoper
extends CFLintScannerAdapter {
    Map<String, List<String>> CHECK_ELEMENT_ATTRIBUTES = new HashMap<String, List<String>>();
    List<String> CHECK_NAMES = Arrays.asList("cfquery", "cfstoredproc", "cffeed", "cfdirectory", "cfform", "cfftp", "cfobject", "cfsearch", "cfprocresult", "cfpop", "cfregistry", "cfreport", "cfdbinfo", "cfdocument", "cfcollection", "cfpdf", "cfzip", "cfldap");
    static final Collection<String> variables = Arrays.asList("APPLICATION", "CGI", "COOKIE", "FORM", "REQUEST", "SERVER", "SESSION", "URL");

    @Override
    public void expression(CFExpression expression, Context context, BugList bugs) {
        if (expression instanceof CFIdentifier) {
            if (expression instanceof CFFullVarExpression && ((CFFullVarExpression)expression).getExpressions().size() > 1) {
                return;
            }
            String name = ((CFIdentifier)expression).getName();
            if (context.isInFunction() && context.isInAssignmentExpression() && !context.getCallStack().checkVariable(name) && !this.isGlobal(name)) {
                context.addMessage("MISSING_VAR", name);
            } else if (expression instanceof CFFullVarExpression) {
                CFFullVarExpression fullVarExpr = (CFFullVarExpression)expression;
                this.expression((CFExpression)fullVarExpr.getExpressions().get(0), context, bugs);
            }
        }
    }

    public VarScoper() {
        this.CHECK_ELEMENT_ATTRIBUTES.put("cfinvoke", Arrays.asList("returnvariable"));
        this.CHECK_ELEMENT_ATTRIBUTES.put("cffile", Arrays.asList("variable"));
        this.CHECK_ELEMENT_ATTRIBUTES.put("cfsavecontent", Arrays.asList("variable"));
        this.CHECK_ELEMENT_ATTRIBUTES.put("cfhttp", Arrays.asList("result"));
        this.CHECK_ELEMENT_ATTRIBUTES.put("cfquery", Arrays.asList("result"));
        this.CHECK_ELEMENT_ATTRIBUTES.put("cfmail", Arrays.asList("query"));
        this.CHECK_ELEMENT_ATTRIBUTES.put("cfftp", Arrays.asList("result"));
        this.CHECK_ELEMENT_ATTRIBUTES.put("cfwddx", Arrays.asList("output"));
        this.CHECK_ELEMENT_ATTRIBUTES.put("cfexecute", Arrays.asList("variable"));
        this.CHECK_ELEMENT_ATTRIBUTES.put("cfntauthenticate", Arrays.asList("result"));
        this.CHECK_ELEMENT_ATTRIBUTES.put("cfxml", Arrays.asList("variable"));
    }

    @Override
    public void element(Element element, Context context, BugList bugs) {
        String name = element.getName();
        if (name != null && name.trim().length() > 0 && context.isInFunction()) {
            String typeVar;
            if (this.CHECK_NAMES.contains(name.toLowerCase())) {
                this.assertVariable(element, context, bugs, element.getAttributeValue("name"));
            }
            if (this.CHECK_ELEMENT_ATTRIBUTES.containsKey(name.toLowerCase())) {
                for (String attrName : this.CHECK_ELEMENT_ATTRIBUTES.get(name.toLowerCase())) {
                    this.assertVariable(element, context, bugs, element.getAttributeValue(attrName));
                }
            }
            if (name.equalsIgnoreCase("cfprocparam") && (typeVar = element.getAttributeValue("type")) != null && (typeVar.equalsIgnoreCase("out") || typeVar.equalsIgnoreCase("inout"))) {
                this.assertVariable(element, context, bugs, element.getAttributeValue("variable"));
            }
            if (name.equalsIgnoreCase("cffeed") && (typeVar = element.getAttributeValue("action")) != null && typeVar.equalsIgnoreCase("read")) {
                this.assertVariable(element, context, bugs, element.getAttributeValue("query"));
            }
        }
    }

    protected void assertVariable(Element element, Context context, BugList bugs, String inameVar) {
        String nameVar;
        String string = nameVar = inameVar == null ? null : inameVar.split("\\.")[0].split("\\[")[0];
        if (nameVar != null && !context.getCallStack().checkVariable(nameVar) && !this.isGlobal(nameVar)) {
            context.addMessage("MISSING_VAR", inameVar);
        }
    }

    private boolean isGlobal(String nameVar) {
        return nameVar != null && variables.contains(nameVar.toUpperCase().trim());
    }
}

