/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.plugins.exceptions;

import com.cflint.BugInfo;
import com.cflint.BugList;
import com.cflint.plugins.exceptions.CFLintExceptionListener;

public class DefaultCFLintExceptionListener
implements CFLintExceptionListener {
    BugList bugs;

    public DefaultCFLintExceptionListener(BugList bugs) {
        this.bugs = bugs;
    }

    @Override
    public void exceptionOccurred(Exception exception, String messageCode, String filename, Integer line, Integer column, String functionName, String expression) {
        BugInfo.BugInfoBuilder bugInfoBuilder = new BugInfo.BugInfoBuilder();
        bugInfoBuilder.setMessageCode(messageCode).setFilename(filename).setSeverity("ERROR");
        if ("PARSE_ERROR".equals(messageCode)) {
            bugInfoBuilder.setMessage("Unable to parse");
        } else {
            bugInfoBuilder.setMessage(exception.getMessage());
        }
        bugInfoBuilder.setExpression(expression);
        bugInfoBuilder.setFunction(functionName);
        if (line != null) {
            bugInfoBuilder.setLine(line);
        }
        if (column != null) {
            bugInfoBuilder.setColumn(column);
        }
        this.bugs.add(bugInfoBuilder.build());
    }
}

