/*
 * Decompiled with CFR 0.152.
 */
package com.cflint.tools;

import com.cflint.BugInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class CFLintFilter {
    private JSONArray data = null;
    private List<String> includeCodes = null;

    private CFLintFilter(String data) {
        this.data = data != null && data.trim().length() > 0 ? (JSONArray)JSONValue.parse((String)data) : new JSONArray();
    }

    public void addFilter(Map<String, String> filter) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.putAll(filter);
    }

    public void excludeCode(String ... codes) {
        if (codes.length == 0) {
            return;
        }
        HashMap<String, String> filter = new HashMap<String, String>();
        for (String code : codes) {
            filter.put("code", code);
        }
        this.addFilter(filter);
    }

    public void includeCode(String ... codes) {
        if (codes.length == 0) {
            return;
        }
        if (this.includeCodes == null) {
            this.includeCodes = new ArrayList<String>();
        }
        this.includeCodes.addAll(Arrays.asList(codes));
    }

    public static CFLintFilter createFilter() {
        String data = null;
        try {
            InputStream is = CFLintFilter.class.getResourceAsStream("/cflintexclude.json");
            if (is == null) {
                return new CFLintFilter(null);
            }
            byte[] b = new byte[is.available()];
            is.read(b);
            data = new String(b);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return new CFLintFilter(data);
    }

    public static CFLintFilter createFilter(String excludeJSON) {
        return new CFLintFilter(excludeJSON);
    }

    public boolean include(BugInfo bugInfo) {
        if (this.includeCodes != null && !this.includeCodes.contains(bugInfo.getMessageCode())) {
            return false;
        }
        if (this.data != null) {
            for (Object item : this.data) {
                JSONObject jsonObj = (JSONObject)item;
                if (jsonObj.containsKey((Object)"file") && !bugInfo.getFilename().matches(jsonObj.get((Object)"file").toString()) || jsonObj.containsKey((Object)"code") && !bugInfo.getMessageCode().matches(jsonObj.get((Object)"code").toString()) || jsonObj.containsKey((Object)"function") && (bugInfo.getFunction() == null || !bugInfo.getFunction().matches(jsonObj.get((Object)"function").toString())) || jsonObj.containsKey((Object)"variable") && (bugInfo.getVariable() == null || !bugInfo.getFunction().matches(jsonObj.get((Object)"function").toString())) || jsonObj.containsKey((Object)"line") && (bugInfo.getLine() > 0 || !new Integer(bugInfo.getLine()).toString().matches(jsonObj.get((Object)"line").toString())) || jsonObj.containsKey((Object)"expression") && (bugInfo.getExpression() == null || !bugInfo.getExpression().matches(jsonObj.get((Object)"expression").toString()))) continue;
                return false;
            }
        }
        return true;
    }
}

