/*
 * Decompiled with CFR 0.152.
 */
package com.github.charithe.kafka;

import com.github.charithe.kafka.EphemeralKafkaBroker;
import com.github.charithe.kafka.KafkaHelper;
import com.google.common.util.concurrent.Futures;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.junit.rules.ExternalResource;

public class KafkaJunitRule
extends ExternalResource {
    private final EphemeralKafkaBroker broker;
    private final StartupMode mode;

    public KafkaJunitRule(EphemeralKafkaBroker broker) {
        this(broker, StartupMode.DEFAULT);
    }

    public KafkaJunitRule(EphemeralKafkaBroker broker, StartupMode mode) {
        this.broker = Objects.requireNonNull(broker);
        this.mode = Objects.requireNonNull(mode);
    }

    protected void before() throws Throwable {
        CompletableFuture<Void> startFuture = this.broker.start();
        if (this.mode == StartupMode.WAIT_FOR_STARTUP) {
            Futures.getUnchecked(startFuture);
        }
    }

    protected void after() {
        try {
            this.broker.stop();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AssertionError((Object)e);
        }
    }

    public KafkaHelper helper() {
        return KafkaHelper.createFor(this.broker);
    }

    public KafkaJunitRule waitForStartup() {
        return new KafkaJunitRule(this.broker, StartupMode.WAIT_FOR_STARTUP);
    }

    public KafkaJunitRule dontWaitForStartup() {
        return new KafkaJunitRule(this.broker, StartupMode.DEFAULT);
    }

    public static KafkaJunitRule create() {
        return new KafkaJunitRule(EphemeralKafkaBroker.create());
    }

    private static enum StartupMode {
        WAIT_FOR_STARTUP,
        DEFAULT;

    }
}

