/*
 * Decompiled with CFR 0.152.
 */
package com.github.charithe.kafka;

import com.github.charithe.kafka.EphemeralKafkaBroker;
import com.github.charithe.kafka.KafkaHelper;
import com.github.charithe.kafka.KafkaJunitExtensionConfig;
import com.github.charithe.kafka.StartupMode;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;

@KafkaJunitExtensionConfig
public class KafkaJunitExtension
implements BeforeAllCallback,
AfterEachCallback,
BeforeEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace KAFKA_JUNIT = ExtensionContext.Namespace.create((Object[])new Object[]{"kafka-junit"});
    private static final KafkaJunitExtensionConfig DEFAULT_CONFIG = KafkaJunitExtension.class.getAnnotation(KafkaJunitExtensionConfig.class);

    public void beforeAll(ExtensionContext extensionContext) {
        KafkaJunitExtensionConfig kafkaConfig = KafkaJunitExtension.getKafkaConfig(extensionContext);
        EphemeralKafkaBroker broker = EphemeralKafkaBroker.create(kafkaConfig.kafkaPort(), kafkaConfig.zooKeeperPort(), this.loadPropsFromClasspath(kafkaConfig.propsFileName()));
        extensionContext.getStore(KAFKA_JUNIT).put(EphemeralKafkaBroker.class, (Object)broker);
        extensionContext.getStore(KAFKA_JUNIT).put(StartupMode.class, (Object)kafkaConfig.startupMode());
        extensionContext.getStore(KAFKA_JUNIT).put(KafkaHelper.class, (Object)KafkaHelper.createFor(broker));
    }

    private static KafkaJunitExtensionConfig getKafkaConfig(ExtensionContext extensionContext) {
        return extensionContext.getElement().map(annotatedElement -> {
            if (annotatedElement.isAnnotationPresent(KafkaJunitExtensionConfig.class)) {
                return annotatedElement.getAnnotation(KafkaJunitExtensionConfig.class);
            }
            return DEFAULT_CONFIG;
        }).orElse(DEFAULT_CONFIG);
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        CompletableFuture<Void> startFuture = KafkaJunitExtension.getBroker(extensionContext).start();
        if (KafkaJunitExtension.getStartupMode(extensionContext) == StartupMode.WAIT_FOR_STARTUP) {
            Futures.getUnchecked(startFuture);
        }
    }

    private static EphemeralKafkaBroker getBroker(ExtensionContext extensionContext) {
        return (EphemeralKafkaBroker)extensionContext.getStore(KAFKA_JUNIT).get(EphemeralKafkaBroker.class, EphemeralKafkaBroker.class);
    }

    private static StartupMode getStartupMode(ExtensionContext extensionContext) {
        return (StartupMode)((Object)extensionContext.getStore(KAFKA_JUNIT).get(StartupMode.class, StartupMode.class));
    }

    public void afterEach(ExtensionContext extensionContext) {
        try {
            KafkaJunitExtension.getBroker(extensionContext).stop();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.getParameter().getType().equals(KafkaHelper.class) || parameterContext.getParameter().getType().equals(EphemeralKafkaBroker.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return extensionContext.getStore(KAFKA_JUNIT).get(parameterType, parameterType);
    }

    private Properties loadPropsFromClasspath(String fileName) {
        Properties prop = new Properties();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(fileName);){
            if (is != null) {
                prop.load(is);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return prop;
    }
}

