/*
 * Decompiled with CFR 0.152.
 */
package com.github.charithe.kafka;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServerStartable;
import org.apache.curator.test.TestingServer;

public enum KafkaStandalone {
    INSTANCE;

    private TestingServer zookeeper;
    private KafkaServerStartable kafkaServer;
    private Path kafkaLogDir;

    public void start(int zookeeperPort, int kafkaPort) throws Exception {
        this.zookeeper = new TestingServer(zookeeperPort, true);
        String zookeeperConnectionString = this.zookeeper.getConnectString();
        KafkaConfig kafkaConfig = this.buildKafkaConfig(zookeeperConnectionString, kafkaPort);
        this.kafkaServer = new KafkaServerStartable(kafkaConfig);
        this.kafkaServer.startup();
    }

    private KafkaConfig buildKafkaConfig(String zookeeperQuorum, int kafkaPort) throws IOException {
        this.kafkaLogDir = Files.createTempDirectory("kafka_maven", new FileAttribute[0]);
        Properties props = new Properties();
        props.put("port", kafkaPort + "");
        props.put("broker.id", "1");
        props.put("log.dirs", this.kafkaLogDir.toAbsolutePath().toString());
        props.put("zookeeper.connect", zookeeperQuorum);
        return new KafkaConfig(props);
    }

    public void stop() {
        try {
            if (this.kafkaServer != null) {
                this.kafkaServer.shutdown();
            }
            if (this.zookeeper != null) {
                this.zookeeper.close();
            }
            if (Files.exists(this.kafkaLogDir, new LinkOption[0])) {
                Files.walkFileTree(this.kafkaLogDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.deleteIfExists(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.deleteIfExists(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

