/*
 * Decompiled with CFR 0.152.
 */
package com.github.charithe.kafka;

import com.github.charithe.kafka.KafkaStandalone;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="start-kafka-broker")
public class StartKafkaBrokerMojo
extends AbstractMojo {
    @Parameter(defaultValue="9092")
    private Integer kafkaPort;
    @Parameter(defaultValue="2181")
    private Integer zookeeperPort;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().info((CharSequence)("Starting Zookeeper on port " + this.zookeeperPort + " and Kafka broker on port " + this.kafkaPort));
            KafkaStandalone.INSTANCE.start(this.zookeeperPort, this.kafkaPort);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Failed to start Kafka broker", (Throwable)e);
            throw new MojoExecutionException("Failed to start Kafka broker");
        }
    }
}

