/*
 * Decompiled with CFR 0.152.
 */
package com.github.chhorz.javadoc;

import com.github.chhorz.javadoc.JavaDoc;
import com.github.chhorz.javadoc.exception.DuplicateTagException;
import com.github.chhorz.javadoc.tags.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JavaDocParser {
    private List<Tag> tags = new ArrayList<Tag>();
    private Map<String, String> replacements = new HashMap<String, String>();

    public JavaDoc parse(String javaDocString) {
        String summary = "";
        String description = "";
        List<Tag> parsedTags = new ArrayList<Tag>();
        if (javaDocString != null && !javaDocString.isEmpty()) {
            String rawDescription = this.parseDescription(javaDocString);
            summary = this.performReplacements(this.parseSummary(rawDescription));
            description = this.performReplacements(rawDescription);
            parsedTags = this.parseTags(javaDocString);
        }
        return new JavaDoc(summary, description, parsedTags);
    }

    private String parseSummary(String description) {
        if (description.isEmpty()) {
            return "";
        }
        if (description.contains("@summary")) {
            Pattern summaryPattern = Pattern.compile("\\{@summary ([^{}]+)}([\\s.,:;-])?");
            Matcher summaryMatcher = summaryPattern.matcher(description);
            if (summaryMatcher.find()) {
                return summaryMatcher.group(1);
            }
            return "";
        }
        if (description.contains(".")) {
            return description.substring(0, description.indexOf(46) + 1);
        }
        return description;
    }

    private String parseDescription(String javaDocString) {
        String[] lines = javaDocString.split("\n");
        StringBuilder stringBuilder = new StringBuilder();
        for (String line : lines) {
            if (line.trim().startsWith("@")) break;
            stringBuilder.append(line).append("\n");
        }
        return stringBuilder.toString().trim();
    }

    private List<Tag> parseTags(String javaDocString) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        Stream<String> tagNamesStream = this.tags.stream().map(tag -> tag.getTagName()).map(tag -> String.format("@%s", tag));
        String allTagNames = Stream.concat(tagNamesStream, Stream.of("[^{]@\\S+")).collect(Collectors.joining("|", "(?=", "|$)"));
        for (Tag tag2 : this.tags) {
            Pattern pattern = Pattern.compile(tag2.createPattern(allTagNames), 32);
            Matcher matcher = pattern.matcher(javaDocString);
            int start = 0;
            while (matcher.find(start)) {
                Tag currentTag;
                try {
                    currentTag = (Tag)tag2.getClass().newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    currentTag = tag2;
                    e.printStackTrace();
                }
                for (String segmentName : tag2.getSegmentNames()) {
                    currentTag.putValue(segmentName, this.performReplacements(matcher.group(segmentName)));
                }
                tagList.add(currentTag);
                start = matcher.end();
            }
        }
        return tagList;
    }

    private String performReplacements(String input) {
        String convertedString = input;
        for (Map.Entry<String, String> replacement : this.replacements.entrySet()) {
            convertedString = convertedString.replaceAll(replacement.getKey(), replacement.getValue());
        }
        return convertedString.trim();
    }

    void addReplacement(String regex, String replacement) {
        Objects.requireNonNull(regex, "The given regex must not be null!");
        Objects.requireNonNull(replacement, "The given replacement must not be null!");
        if (regex.isEmpty()) {
            throw new IllegalArgumentException("The given regex must not be empty!");
        }
        this.replacements.put(regex, replacement);
    }

    void addTag(Tag tag) {
        Objects.requireNonNull(tag, "The given tag must not be null!");
        if (this.tags.stream().anyMatch(t -> t.getClass().equals(tag.getClass()))) {
            throw new DuplicateTagException(tag);
        }
        this.tags.add(tag);
    }
}

