/*
 * Decompiled with CFR 0.152.
 */
package com.github.chhorz.javadoc.tags;

import com.github.chhorz.javadoc.tags.Tag;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class StructuredTag
extends Tag {
    private String name;
    private List<String> segmentNames;
    private TreeMap<String, String> values = new TreeMap();

    public StructuredTag(String name, String ... segmentNames) {
        this.name = name;
        this.segmentNames = Arrays.asList(segmentNames);
        for (String segmentName : segmentNames) {
            this.values.put(segmentName, "");
        }
    }

    @Override
    public String getTagName() {
        return this.name;
    }

    @Override
    public List<String> getSegmentNames() {
        return this.segmentNames;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    @Override
    public void putValue(String segmentName, String segmentValue) {
        if (this.values.containsKey(segmentName)) {
            this.values.put(segmentName, segmentValue != null ? segmentValue : "");
        }
    }

    @Override
    public String createPattern(String allTagNames) {
        StringBuilder sb = new StringBuilder();
        for (String segmentName : this.getSegmentNames()) {
            sb.append("\\s+?(?<" + segmentName + ">.+?)");
        }
        return "@" + this.name + sb.toString() + "\\s*" + allTagNames;
    }

    public String toString() {
        return String.format("Tag [name=%s, values=%s]", this.name, this.values);
    }
}

