/*
 * Decompiled with CFR 0.152.
 */
package com.github.chhorz.javadoc;

import com.github.chhorz.javadoc.tags.Tag;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class JavaDoc {
    private final String summary;
    private final String description;
    private final List<Tag> tags;

    public JavaDoc(String summary, String description, List<Tag> tags) {
        this.summary = summary;
        this.description = description;
        this.tags = tags;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Tag> getTags() {
        return this.tags == null ? Collections.emptyList() : this.tags;
    }

    public <T extends Tag> List<T> getTags(Class<T> tagClass) {
        return this.tags == null ? Collections.emptyList() : this.tags.stream().filter(tagClass::isInstance).map(tagClass::cast).collect(Collectors.toList());
    }

    public String toString() {
        return String.format("JavaDoc [summary=%s, description=%s, tags=%s]", this.summary, this.description, this.tags);
    }
}

