/*
 * Decompiled with CFR 0.152.
 */
package com.github.chhorz.javadoc;

import com.github.chhorz.javadoc.JavaDocParser;
import com.github.chhorz.javadoc.OutputType;
import com.github.chhorz.javadoc.tags.AuthorTag;
import com.github.chhorz.javadoc.tags.CategoryTag;
import com.github.chhorz.javadoc.tags.DeprecatedTag;
import com.github.chhorz.javadoc.tags.ExceptionTag;
import com.github.chhorz.javadoc.tags.ParamTag;
import com.github.chhorz.javadoc.tags.ReturnTag;
import com.github.chhorz.javadoc.tags.SeeTag;
import com.github.chhorz.javadoc.tags.SinceTag;
import com.github.chhorz.javadoc.tags.Tag;
import com.github.chhorz.javadoc.tags.ThrowsTag;
import com.github.chhorz.javadoc.tags.VersionTag;
import java.util.stream.Stream;

public class JavaDocParserBuilder {
    private static final String BASE_INLINE_PATTERN = "\\{@%s ([^\\{\\}]+)\\}([\\s.,:;-])?";
    private static final String INLINE_SUMMARY_PATTERN = String.format("\\{@%s ([^\\{\\}]+)\\}([\\s.,:;-])?", "summary");
    private static final String INLINE_CODE_PATTERN = String.format("\\{@%s ([^\\{\\}]+)\\}([\\s.,:;-])?", "code");
    private static final String INLINE_LINK_PATTERN = String.format("\\{@%s ([^\\{\\}]+)\\}([\\s.,:;-])?", "link");
    private static final String INLINE_LINKPLAIN_PATTERN = String.format("\\{@%s ([^\\{\\}]+)\\}([\\s.,:;-])?", "linkplain");
    private static final String INLINE_LITERAL_PATTERN = String.format("\\{@%s ([^\\{\\}]+)\\}([\\s.,:;-])?", "literal");
    private static final String INLINE_VALUE_PATTERN = String.format("\\{@%s ([^\\{\\}]+)\\}([\\s.,:;-])?", "value");
    private final JavaDocParser javaDocParser = new JavaDocParser();

    private JavaDocParserBuilder() {
        Stream.of(new AuthorTag(), new CategoryTag(), new DeprecatedTag(), new ExceptionTag(), new ParamTag(), new ReturnTag(), new SeeTag(), new SinceTag(), new ThrowsTag(), new VersionTag()).forEach(this.javaDocParser::addTag);
    }

    public static JavaDocParserBuilder withBasicTags() {
        return new JavaDocParserBuilder();
    }

    public <T extends Tag> JavaDocParserBuilder withCustomTag(T tag) {
        this.javaDocParser.addTag(tag);
        return this;
    }

    public JavaDocParserBuilder withOutputType(OutputType outputType) {
        this.javaDocParser.addReplacement(INLINE_SUMMARY_PATTERN, "$1$2");
        if (OutputType.ASCIIDOC.equals((Object)outputType) || OutputType.MARKDOWN.equals((Object)outputType)) {
            this.javaDocParser.addReplacement(INLINE_CODE_PATTERN, "`$1`$2");
            this.javaDocParser.addReplacement(INLINE_LINK_PATTERN, "$1$2");
            this.javaDocParser.addReplacement(INLINE_LINKPLAIN_PATTERN, "$1$2");
            this.javaDocParser.addReplacement(INLINE_LITERAL_PATTERN, "_$1_$2");
            this.javaDocParser.addReplacement(INLINE_VALUE_PATTERN, "`$1`$2");
        } else if (OutputType.HTML.equals((Object)outputType)) {
            this.javaDocParser.addReplacement(INLINE_CODE_PATTERN, "<code>$1</code>$2");
            this.javaDocParser.addReplacement(INLINE_LINK_PATTERN, "$1$2");
            this.javaDocParser.addReplacement(INLINE_LINKPLAIN_PATTERN, "$1$2");
            this.javaDocParser.addReplacement(INLINE_LITERAL_PATTERN, "<i>$1</i>$2");
            this.javaDocParser.addReplacement(INLINE_VALUE_PATTERN, "<pre>$1</pre>$2");
        }
        return this;
    }

    public JavaDocParserBuilder withReplacement(String regex, String replacement) {
        this.javaDocParser.addReplacement(regex, replacement);
        return this;
    }

    public JavaDocParser build() {
        return this.javaDocParser;
    }
}

