/*
 * Decompiled with CFR 0.152.
 */
package com.github.chhorz.javadoc.tags;

import com.github.chhorz.javadoc.tags.Tag;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class StructuredTag
extends Tag {
    private final String name;
    private final List<Tag.Segment> segments;
    private final TreeMap<String, String> values = new TreeMap();

    public StructuredTag(String name, Tag.Segment ... segments) {
        this.name = name;
        this.segments = Arrays.asList(segments);
        this.getSegments().stream().map(Tag.Segment::getName).forEach(segmentName -> this.values.put((String)segmentName, ""));
    }

    @Override
    public String getTagName() {
        return this.name;
    }

    @Override
    public List<Tag.Segment> getSegments() {
        return this.segments;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    @Override
    public void putValue(String segmentName, String segmentValue) {
        if (this.values.containsKey(segmentName)) {
            this.values.put(segmentName, segmentValue != null ? segmentValue : "");
        }
    }

    @Override
    public String createPattern(String allTagNames) {
        StringBuilder sb = new StringBuilder();
        this.getSegments().stream().map(segment -> segment.isRequired() ? String.format("\\s+?(?<%s>.+?)", segment.getName()) : String.format("\\s+?(?<%s>.+?)??", segment.getName())).forEach(sb::append);
        return "@" + this.name + sb + "\\s*" + allTagNames;
    }

    public String toString() {
        return String.format("Tag [name=%s, segments=%s]", this.name, this.segments);
    }
}

