/*
 * Decompiled with CFR 0.152.
 */
package com.github.chimmhuang.redislock.listener;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.listener.KeyspaceEventMessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

public class RedisListener
extends KeyspaceEventMessageListener {
    private static ConcurrentHashMap<CountDownLatch, String> countDownLatchMap = new ConcurrentHashMap();

    public static void addCountDownLatch(String lockKey, CountDownLatch countDownLatch) {
        countDownLatchMap.put(countDownLatch, lockKey);
    }

    public RedisListener(RedisMessageListenerContainer listenerContainer) {
        super(listenerContainer);
    }

    public void onMessage(Message message, byte[] pattern) {
        Set<Map.Entry<CountDownLatch, String>> entrySet = countDownLatchMap.entrySet();
        for (Map.Entry<CountDownLatch, String> entry : entrySet) {
            if (!message.toString().equals(entry.getValue())) continue;
            CountDownLatch countDownLatch = entry.getKey();
            countDownLatch.countDown();
            countDownLatchMap.remove(countDownLatch);
        }
    }

    protected void doHandleMessage(Message message) {
    }
}

