/*
 * Decompiled with CFR 0.152.
 */
package com.github.chimmhuang.redislock.lock;

import com.github.chimmhuang.redislock.listener.RedisListener;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisLock {
    private static final Logger log = LoggerFactory.getLogger(RedisLock.class);
    private RedisTemplate redisTemplate;

    public RedisLock(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void lock(String key, long expire) {
        if (this.tryLock(key, expire)) {
            return;
        }
        this.waitForLock(key);
        this.lock(key, expire);
    }

    private boolean tryLock(String key, long expire) {
        String script = "if redis.call('setNx',KEYS[1],ARGV[1]) then if redis.call('get',KEYS[1])==ARGV[1] then return redis.call('expire',KEYS[1],ARGV[2]) else return 0 end end";
        DefaultRedisScript redisScript = new DefaultRedisScript(script, Long.class);
        Object result = this.redisTemplate.execute((RedisScript)redisScript, (RedisSerializer)new StringRedisSerializer(), (RedisSerializer)new StringRedisSerializer(), Collections.singletonList(key), new Object[]{Thread.currentThread().getName(), expire + ""});
        return 1 == Integer.parseInt(result.toString());
    }

    private void waitForLock(String key) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        RedisListener.addCountDownLatch(key, countDownLatch);
        try {
            countDownLatch.await();
        }
        catch (Exception e) {
            log.error("Error releasing thread : {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public boolean unlock(String key) {
        String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
        DefaultRedisScript redisScript = new DefaultRedisScript(script, Long.class);
        Object result = this.redisTemplate.execute((RedisScript)redisScript, (RedisSerializer)new StringRedisSerializer(), (RedisSerializer)new StringRedisSerializer(), Collections.singletonList(key), new Object[]{Thread.currentThread().getName()});
        return 1 == Integer.parseInt(result.toString());
    }
}

