/*
 * Decompiled with CFR 0.152.
 */
package com.chivorn.smartmaterialspinner;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.SearchManager;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.app.DialogFragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SearchView;
import android.widget.TextView;
import com.chivorn.smartmaterialspinner.R;
import com.chivorn.smartmaterialspinner.SmartMaterialSpinner;
import java.io.Serializable;
import java.util.List;

public class SearchableSpinnerDialog
extends DialogFragment
implements SearchView.OnQueryTextListener,
SearchView.OnCloseListener {
    private static final String INSTANCE_LIST_ITEMS = "ListItems";
    private static final String INSTANCE_LISTENER_KEY = "OnSearchDialogEventListener";
    private static final String INSTANCE_SPINNER_KEY = "SmartMaterialSpinner";
    private ArrayAdapter searchArrayAdapter;
    private ViewGroup searchHeaderView;
    private TextView tvSearchHeader;
    private SearchView searchView;
    private ListView searchListView;
    private TextView tvListItem;
    private boolean isEnableSearchHeader = true;
    private int headerBackgroundColor;
    private Drawable headerBackgroundDrawable;
    private int searchListItemColor;
    private int selectedSearchItemColor;
    private int selectedPosition = -1;
    private String searchHeaderText;
    private int searchHeaderTextColor;
    private String searchHint;
    private int searchDialogGravity = 48;
    private OnSearchDialogEventListener onSearchDialogEventListener;
    private OnSearchTextChanged onSearchTextChanged;
    private DialogInterface.OnClickListener dialogListener;
    private SmartMaterialSpinner smartMaterialSpinner;
    private boolean isDismissOnSelected = true;

    public static SearchableSpinnerDialog newInstance(SmartMaterialSpinner smartMaterialSpinner, List items) {
        SearchableSpinnerDialog searchableSpinnerDialog = new SearchableSpinnerDialog();
        Bundle args = new Bundle();
        args.putSerializable(INSTANCE_LIST_ITEMS, (Serializable)((Object)items));
        args.putSerializable(INSTANCE_SPINNER_KEY, (Serializable)smartMaterialSpinner);
        searchableSpinnerDialog.setArguments(args);
        return searchableSpinnerDialog;
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        outState = this.setSavedInstanceState(outState);
        outState.putSerializable(INSTANCE_LISTENER_KEY, outState.getSerializable(INSTANCE_LISTENER_KEY));
        outState.putSerializable(INSTANCE_SPINNER_KEY, outState.getSerializable(INSTANCE_SPINNER_KEY));
        outState.putSerializable(INSTANCE_LIST_ITEMS, outState.getSerializable(INSTANCE_LIST_ITEMS));
        super.onSaveInstanceState(outState);
    }

    private Bundle setSavedInstanceState(Bundle savedInstanceState) {
        Bundle dialogInstanceState = this.getArguments();
        if (savedInstanceState == null || savedInstanceState.isEmpty() && dialogInstanceState != null) {
            savedInstanceState = dialogInstanceState;
        }
        return savedInstanceState;
    }

    public void onCreate(Bundle savedInstanceState) {
        savedInstanceState = this.setSavedInstanceState(savedInstanceState);
        this.smartMaterialSpinner = (SmartMaterialSpinner)savedInstanceState.get(INSTANCE_SPINNER_KEY);
        this.onSearchDialogEventListener = this.smartMaterialSpinner;
        savedInstanceState.putSerializable(INSTANCE_LISTENER_KEY, (Serializable)this.onSearchDialogEventListener);
        super.onCreate(savedInstanceState);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        savedInstanceState = this.setSavedInstanceState(savedInstanceState);
        LayoutInflater inflater = LayoutInflater.from((Context)this.getActivity());
        if (savedInstanceState != null) {
            this.onSearchDialogEventListener = (OnSearchDialogEventListener)savedInstanceState.getSerializable(INSTANCE_LISTENER_KEY);
        }
        View searchLayout = inflater.inflate(R.layout.smart_material_spinner_searchable_dialog_layout, null);
        this.initSearchDialog(searchLayout, savedInstanceState);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setView(searchLayout);
        AlertDialog dialog = builder.create();
        this.setGravity((Dialog)dialog);
        dialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                SearchableSpinnerDialog.this.scrollToSelectedItem();
            }
        });
        return dialog;
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        savedInstanceState = this.setSavedInstanceState(savedInstanceState);
        Window window = this.getDialog().getWindow();
        if (window != null) {
            window.setSoftInputMode(2);
        }
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    private void initSearchDialog(View rootView, Bundle savedInstanceState) {
        List items;
        SearchManager searchManager;
        this.searchHeaderView = (ViewGroup)rootView.findViewById(R.id.search_header_layout);
        this.tvSearchHeader = (TextView)rootView.findViewById(R.id.tv_search_header);
        this.searchView = (SearchView)rootView.findViewById(R.id.search_view);
        this.searchListView = (ListView)rootView.findViewById(R.id.search_list_item);
        if (this.getActivity() != null && (searchManager = (SearchManager)this.getActivity().getSystemService("search")) != null) {
            this.searchView.setSearchableInfo(searchManager.getSearchableInfo(this.getActivity().getComponentName()));
        }
        this.searchView.setIconifiedByDefault(false);
        this.searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        this.searchView.setOnCloseListener((SearchView.OnCloseListener)this);
        this.searchView.setFocusable(true);
        this.searchView.setIconified(false);
        this.searchView.requestFocusFromTouch();
        List list = items = savedInstanceState != null ? (List)((Object)savedInstanceState.getSerializable(INSTANCE_LIST_ITEMS)) : null;
        if (items != null) {
            this.searchArrayAdapter = new ArrayAdapter<Object>((Context)this.getActivity(), R.layout.smart_material_spinner_search_list_item_layout, items){

                @NonNull
                public View getView(int position, View convertView, @NonNull ViewGroup parent) {
                    View listView = super.getView(position, convertView, parent);
                    SearchableSpinnerDialog.this.tvListItem = (TextView)listView.findViewById(R.id.tv_search_list_item);
                    if (SearchableSpinnerDialog.this.searchListItemColor != 0) {
                        SearchableSpinnerDialog.this.tvListItem.setTextColor(SearchableSpinnerDialog.this.searchListItemColor);
                    }
                    if (SearchableSpinnerDialog.this.selectedSearchItemColor != 0 && position >= 0 && position == SearchableSpinnerDialog.this.selectedPosition) {
                        SearchableSpinnerDialog.this.tvListItem.setTextColor(SearchableSpinnerDialog.this.selectedSearchItemColor);
                    }
                    return listView;
                }
            };
        }
        this.searchListView.setAdapter((ListAdapter)this.searchArrayAdapter);
        this.searchListView.setTextFilterEnabled(true);
        this.searchListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (SearchableSpinnerDialog.this.onSearchDialogEventListener != null) {
                    SearchableSpinnerDialog.this.onSearchDialogEventListener.onSearchItemSelected(SearchableSpinnerDialog.this.searchArrayAdapter.getItem(position), position);
                }
                SearchableSpinnerDialog.this.getDialog().dismiss();
            }
        });
        this.initSearchHeader();
        this.initSearchBody();
    }

    private void initSearchHeader() {
        if (this.isEnableSearchHeader) {
            this.searchHeaderView.setVisibility(0);
        } else {
            this.searchHeaderView.setVisibility(8);
        }
        if (this.searchHeaderText != null) {
            this.tvSearchHeader.setText((CharSequence)this.searchHeaderText);
        }
        if (this.searchHeaderTextColor != 0) {
            this.tvSearchHeader.setTextColor(this.searchHeaderTextColor);
        }
        if (this.headerBackgroundColor != 0) {
            this.searchHeaderView.setBackgroundColor(this.headerBackgroundColor);
        } else if (this.headerBackgroundDrawable != null && Build.VERSION.SDK_INT >= 16) {
            this.searchHeaderView.setBackground(this.headerBackgroundDrawable);
        }
    }

    private void initSearchBody() {
        if (this.searchHint != null) {
            this.searchView.setQueryHint((CharSequence)this.searchHint);
        }
    }

    public void onPause() {
        super.onPause();
        this.dismiss();
    }

    public void onDismiss(DialogInterface dialog) {
        if (this.onSearchDialogEventListener != null) {
            this.onSearchDialogEventListener.onSearchableSpinnerDismiss();
        }
        super.onDismiss(dialog);
    }

    public boolean onQueryTextSubmit(String s) {
        this.searchView.clearFocus();
        return true;
    }

    public boolean onQueryTextChange(String s) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            ((ArrayAdapter)this.searchListView.getAdapter()).getFilter().filter(null);
        } else {
            ((ArrayAdapter)this.searchListView.getAdapter()).getFilter().filter((CharSequence)s);
        }
        if (this.onSearchTextChanged != null) {
            this.onSearchTextChanged.onSearchTextChanged(s);
        }
        return true;
    }

    public boolean onClose() {
        return false;
    }

    public void setOnSearchDialogEventListener(OnSearchDialogEventListener onSearchDialogEventListener) {
        this.onSearchDialogEventListener = onSearchDialogEventListener;
    }

    public void setOnSearchTextChangedListener(OnSearchTextChanged onSearchTextChanged) {
        this.onSearchTextChanged = onSearchTextChanged;
    }

    public void setEnableSearchHeader(boolean enableSearchHeader) {
        this.isEnableSearchHeader = enableSearchHeader;
    }

    public void setSearchHeaderText(String header) {
        this.searchHeaderText = header;
    }

    public void setSearchHeaderTextColor(int color2) {
        this.searchHeaderTextColor = color2;
    }

    public void setSearchHeaderBackgroundColor(int color2) {
        this.headerBackgroundColor = color2;
        this.headerBackgroundDrawable = null;
    }

    @RequiresApi(api=16)
    public void setSearchHeaderBackgroundColor(Drawable drawable2) {
        this.headerBackgroundDrawable = drawable2;
        this.headerBackgroundColor = 0;
    }

    public void setSearchHint(String searchHint) {
        this.searchHint = searchHint;
    }

    public void setSearchListItemColor(int searchListItemColor) {
        this.searchListItemColor = searchListItemColor;
    }

    public void setSelectedSearchItemColor(int selectedSearchItemColor) {
        this.selectedSearchItemColor = selectedSearchItemColor;
    }

    public void setSelectedPosition(int position) {
        this.selectedPosition = position;
    }

    public void setGravity(int gravity) {
        this.searchDialogGravity = gravity;
    }

    private void setGravity(Dialog dialog) {
        if (dialog != null && dialog.getWindow() != null) {
            dialog.getWindow().setGravity(this.searchDialogGravity);
        }
    }

    private void scrollToSelectedItem() {
        if (this.selectedPosition >= 0 && this.searchListView.isSmoothScrollbarEnabled()) {
            this.searchListView.smoothScrollToPositionFromTop(this.selectedPosition, 0, 0);
        }
    }

    public static interface OnSearchTextChanged {
        public void onSearchTextChanged(String var1);
    }

    public static interface OnSearchDialogEventListener
    extends Serializable {
        public void onSearchItemSelected(Object var1, int var2);

        public void onSearchableSpinnerDismiss();
    }
}

