/*
 * Decompiled with CFR 0.152.
 */
package com.chivorn.smartmaterialspinner;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.content.res.AppCompatResources;
import android.support.v7.widget.AppCompatSpinner;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.LinearInterpolator;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.EditText;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.chivorn.smartmaterialspinner.R;
import com.chivorn.smartmaterialspinner.SearchableSpinnerDialog;
import com.chivorn.smartmaterialspinner.util.SoftKeyboardUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class SmartMaterialSpinner<T>
extends AppCompatSpinner
implements ValueAnimator.AnimatorUpdateListener,
SearchableSpinnerDialog.OnSearchDialogEventListener,
Serializable {
    public static final int DEFAULT_ARROW_WIDTH_DP = 10;
    private static final String TAG = SmartMaterialSpinner.class.getSimpleName();
    private Paint paint;
    private TextPaint errorTextPaint;
    private TextPaint fltLabelTextPaint;
    private StaticLayout staticLayout;
    private Rect errorTextRect;
    private TextPaint itemTextPaint;
    private Rect itemTextRect;
    private SearchableSpinnerDialog searchableSpinnerDialog;
    private List<T> item;
    private List<Object> searchDialogItem;
    private boolean isSearchable = false;
    private boolean isEnableSearchHeader = true;
    private String searchHeaderText;
    private int searchHeaderTextColor;
    private String searchHint;
    private Path selectorPath;
    private Point[] selectorPoints;
    private int innerPaddingLeft;
    private int innerPaddingRight;
    private int innerPaddingTop;
    private int innerPaddingBottom;
    private int extraPaddingTop;
    private int extraPaddingBottom;
    private float itemTextWidth;
    private float itemTextHeight;
    private int underlineTopSpacing;
    private int errorTextPaddingTop;
    private int errorTextPaddingBottom;
    private int errorTextPaddingTopBottom;
    float errorTextWidth;
    float errorTextHeight;
    private int floatingLabelTopSpacing;
    private int floatingLabelBottomSpacing;
    private int floatingLabelInsideSpacing;
    private int rightLeftSpinnerPadding;
    private int minContentHeight;
    private int arrowPaddingLeft;
    private int arrowPaddingTop;
    private int arrowPaddingRight;
    private int arrowPaddingBottom;
    private int lastPosition = -1;
    private ObjectAnimator errorLabelAnimator;
    private int errorLabelPosX;
    private int minNbErrorLine;
    private float currentNbErrorLines;
    private ErrorTextAlignment errorTextAlignment = ErrorTextAlignment.ALIGN_LEFT;
    private float floatingLabelPercent;
    private ObjectAnimator floatingLabelAnimator;
    private boolean isSelected;
    private boolean isFloatingLabelVisible;
    private int baseAlpha;
    private int baseColor;
    private int highlightColor;
    private float errorTextSize;
    private int errorTextColor;
    private int disabledColor;
    private float underlineSize;
    private int underlineColor;
    private CharSequence errorText;
    private CharSequence hint;
    private int hintColor;
    private boolean isShowItemListHint = true;
    private int itemListHintColor;
    private int itemListHintBackground;
    private float itemSize;
    private int itemColor;
    private int itemListColor;
    private int selectedItemListColor;
    private float hintSize;
    private CharSequence floatingLabelText;
    private float floatingLabelSize;
    private int floatingLabelColor;
    private boolean isMultilineError;
    private Typeface typeface;
    private boolean alignLabel;
    private int arrowColor;
    private float arrowSize;
    private boolean enableErrorLabel;
    private boolean enableFloatingLabel;
    private boolean alwaysShowFloatingLabel;
    private boolean isRtl;
    private boolean isEnableDefaultSelect = true;
    private HintAdapter hintAdapter;
    private TextView tvSpinnerItem;
    private Integer itemView;
    private Integer dropdownView;
    private OnEmptySpinnerClickListener onEmptySpinnerClickListener;
    private OnSpinnerEventListener spinnerEventsListener;
    private boolean isShowing = false;
    private boolean isErrorScrollPaddingInvoked = false;
    private boolean isReSelectable = false;

    public SmartMaterialSpinner(Context context) {
        super(context);
        this.init(context, null);
    }

    public SmartMaterialSpinner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public SmartMaterialSpinner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.removeDefaultSelector(this.getBackground());
        this.initSearchableDialogObject();
        this.initAttributes(context, attrs);
        this.initDimensions(context, attrs);
        this.initPaintObjects();
        this.initPadding();
        this.initFloatingLabelAnimator();
        this.initOnItemSelectedListener();
        this.configSearchableDialog();
        this.setMinimumHeight((int)((float)(this.getPaddingTop() + this.getPaddingBottom() + this.minContentHeight) + (this.itemSize > this.hintSize ? this.itemSize : this.hintSize)));
        this.setItem(new ArrayList());
    }

    private void initAttributes(Context context, AttributeSet attrs) {
        TypedArray defaultArray = context.obtainStyledAttributes(new int[]{R.attr.colorControlNormal, R.attr.colorAccent});
        int defaultBaseColor = ContextCompat.getColor((Context)context, (int)R.color.smsp_base_color);
        int defaultHighlightColor = ContextCompat.getColor((Context)context, (int)R.color.smsp_base_color);
        int defaultErrorColor = ContextCompat.getColor((Context)context, (int)R.color.smsp_error_color);
        defaultArray.recycle();
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SmartMaterialSpinner);
        String typefacePath = typedArray.getString(R.styleable.SmartMaterialSpinner_smsp_typeface);
        if (typefacePath != null) {
            this.typeface = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)typefacePath);
        }
        this.baseColor = typedArray.getColor(R.styleable.SmartMaterialSpinner_smsp_baseColor, defaultBaseColor);
        this.highlightColor = typedArray.getColor(R.styleable.SmartMaterialSpinner_smsp_highlightColor, defaultHighlightColor);
        this.errorTextSize = typedArray.getDimension(R.styleable.SmartMaterialSpinner_smsp_errorTextSize, (float)this.getResources().getDimensionPixelSize(R.dimen.smsp_default_error_text_size));
        this.errorTextColor = typedArray.getColor(R.styleable.SmartMaterialSpinner_smsp_errorTextColor, defaultErrorColor);
        this.disabledColor = ContextCompat.getColor((Context)context, (int)R.color.smsp_disabled_color);
        this.underlineColor = typedArray.getColor(R.styleable.SmartMaterialSpinner_smsp_underlineColor, ContextCompat.getColor((Context)context, (int)R.color.smsp_underline_color));
        this.errorText = typedArray.getString(R.styleable.SmartMaterialSpinner_smsp_errorText);
        this.errorTextAlignment = this.getErrorTextAlignment(typedArray.getInt(R.styleable.SmartMaterialSpinner_smsp_errorTextAlignment, 0));
        this.hint = typedArray.getString(R.styleable.SmartMaterialSpinner_smsp_hint) == null ? "" : typedArray.getString(R.styleable.SmartMaterialSpinner_smsp_hint);
        this.floatingLabelText = typedArray.getString(R.styleable.SmartMaterialSpinner_smsp_floatingLabelText);
        this.hintColor = typedArray.getColor(R.styleable.SmartMaterialSpinner_smsp_hintColor, ContextCompat.getColor((Context)context, (int)R.color.smsp_hint_color));
        this.itemListHintColor = typedArray.getColor(R.styleable.SmartMaterialSpinner_smsp_itemListHintColor, ContextCompat.getColor((Context)context, (int)R.color.smsp_item_list_hint_color));
        this.itemListHintBackground = typedArray.getColor(R.styleable.SmartMaterialSpinner_smsp_itemListHintBackgroundColor, ContextCompat.getColor((Context)context, (int)R.color.smsp_item_list_hint_background));
        this.itemSize = typedArray.getDimension(R.styleable.SmartMaterialSpinner_smsp_itemSize, this.getResources().getDimension(R.dimen.smsp_default_text_and_hint_size));
        this.itemColor = typedArray.getColor(R.styleable.SmartMaterialSpinner_smsp_itemColor, -16777216);
        this.itemListColor = typedArray.getColor(R.styleable.SmartMaterialSpinner_smsp_itemListColor, -16777216);
        this.selectedItemListColor = typedArray.getColor(R.styleable.SmartMaterialSpinner_smsp_selectedItemListColor, ContextCompat.getColor((Context)context, (int)R.color.smsp_selected_color));
        this.hintSize = typedArray.getDimension(R.styleable.SmartMaterialSpinner_smsp_hintSize, this.getResources().getDimension(R.dimen.smsp_default_hint_size));
        this.floatingLabelSize = typedArray.getDimension(R.styleable.SmartMaterialSpinner_smsp_floatingLabelSize, this.getResources().getDimension(R.dimen.smsp_default_floating_label_size));
        this.floatingLabelColor = typedArray.getColor(R.styleable.SmartMaterialSpinner_smsp_floatingLabelColor, ContextCompat.getColor((Context)context, (int)R.color.smsp_floating_label_color));
        this.isMultilineError = typedArray.getBoolean(R.styleable.SmartMaterialSpinner_smsp_multilineError, true);
        this.minNbErrorLine = typedArray.getInt(R.styleable.SmartMaterialSpinner_smsp_nbErrorLine, 1);
        this.currentNbErrorLines = this.minNbErrorLine;
        this.alignLabel = typedArray.getBoolean(R.styleable.SmartMaterialSpinner_smsp_alignLabel, true);
        this.underlineSize = typedArray.getDimension(R.styleable.SmartMaterialSpinner_smsp_underlineSize, 0.6f);
        this.arrowColor = typedArray.getColor(R.styleable.SmartMaterialSpinner_smsp_arrowColor, this.baseColor);
        this.arrowSize = typedArray.getDimension(R.styleable.SmartMaterialSpinner_smsp_arrowSize, (float)this.dpToPx(10.0f));
        this.enableErrorLabel = typedArray.getBoolean(R.styleable.SmartMaterialSpinner_smsp_enableErrorLabel, true);
        this.enableFloatingLabel = typedArray.getBoolean(R.styleable.SmartMaterialSpinner_smsp_enableFloatingLabel, true);
        this.alwaysShowFloatingLabel = typedArray.getBoolean(R.styleable.SmartMaterialSpinner_smsp_alwaysShowFloatingLabel, false);
        this.isRtl = typedArray.getBoolean(R.styleable.SmartMaterialSpinner_smsp_isRtl, false);
        this.itemView = typedArray.getResourceId(R.styleable.SmartMaterialSpinner_smsp_itemView, R.layout.smart_material_spinner_item_layout);
        this.dropdownView = typedArray.getResourceId(R.styleable.SmartMaterialSpinner_smsp_dropdownView, R.layout.smart_material_spinner_dropdown_item_layout);
        this.isSearchable = typedArray.getBoolean(R.styleable.SmartMaterialSpinner_smsp_isSearchable, false);
        this.isEnableSearchHeader = typedArray.getBoolean(R.styleable.SmartMaterialSpinner_smsp_enableSearchHeader, true);
        this.searchHeaderText = typedArray.getString(R.styleable.SmartMaterialSpinner_smsp_searchHeaderText);
        this.searchHeaderTextColor = typedArray.getColor(R.styleable.SmartMaterialSpinner_smsp_searchHeaderTextColor, ContextCompat.getColor((Context)context, (int)R.color.smsp_search_header_text_color));
        int searchHeaderDrawableResId = typedArray.getResourceId(R.styleable.SmartMaterialSpinner_smsp_searchHeaderBackgroundColor, 0);
        if (Build.VERSION.SDK_INT >= 16 && searchHeaderDrawableResId != 0) {
            this.setSearchHeaderBackgroundColor(AppCompatResources.getDrawable((Context)this.getContext(), (int)searchHeaderDrawableResId));
        } else {
            this.setSearchHeaderBackgroundColor(typedArray.getColor(R.styleable.SmartMaterialSpinner_smsp_searchHeaderBackgroundColor, ContextCompat.getColor((Context)context, (int)R.color.smsp_search_header_background)));
        }
        this.searchHint = typedArray.getString(R.styleable.SmartMaterialSpinner_smsp_searchHint);
        this.isReSelectable = typedArray.getBoolean(R.styleable.SmartMaterialSpinner_smsp_isReSelectable, false);
        typedArray.recycle();
        this.lastPosition = -1;
    }

    private void initSearchableDialogObject() {
        this.searchDialogItem = new ArrayList<Object>();
        this.searchableSpinnerDialog = SearchableSpinnerDialog.newInstance(this, this.searchDialogItem);
    }

    private void configSearchableDialog() {
        this.setSearchable(this.isSearchable);
        this.setEnableSearchHeader(this.isEnableSearchHeader);
        this.setSearchHeaderText(this.searchHeaderText);
        this.setSearchHeaderTextColor(this.searchHeaderTextColor);
        this.setSearchHint(this.searchHint);
        this.setSearchListItemColor(this.itemListColor);
        this.setSelectedSearchItemColor(this.selectedItemListColor);
    }

    private void removeDefaultSelector(Drawable drawable2) {
        if (drawable2 instanceof LayerDrawable || drawable2 instanceof NinePatchDrawable || drawable2 instanceof StateListDrawable && drawable2.getCurrent() instanceof NinePatchDrawable) {
            this.setBackgroundResource(R.drawable.smsp_transparent_color);
        }
    }

    private void configDropdownWidthAfterDataReady() {
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT >= 16) {
                    SmartMaterialSpinner.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                if (SmartMaterialSpinner.this.getWidth() != 0 && SmartMaterialSpinner.this.getHeight() != 0) {
                    SmartMaterialSpinner.this.setDropDownWidth(SmartMaterialSpinner.this.getWidth());
                    SmartMaterialSpinner.this.setDropDownVerticalOffset(SmartMaterialSpinner.this.getHeight());
                }
                if (SmartMaterialSpinner.this.isSpinnerEmpty()) {
                    SmartMaterialSpinner.this.setDropDownWidth(0);
                    SmartMaterialSpinner.this.setDropDownVerticalOffset(0);
                }
                SmartMaterialSpinner.this.setErrorText(SmartMaterialSpinner.this.errorText);
            }
        });
    }

    private void initPaintObjects() {
        int errorTextSize = this.getResources().getDimensionPixelSize(R.dimen.smsp_default_error_text_size);
        int floatingLabelSize = this.getResources().getDimensionPixelSize(R.dimen.smsp_default_floating_label_size);
        this.paint = new Paint(1);
        this.errorTextPaint = new TextPaint(1);
        this.fltLabelTextPaint = new TextPaint(1);
        this.itemTextPaint = new TextPaint(1);
        this.errorTextRect = new Rect();
        this.itemTextRect = new Rect();
        this.errorTextPaint.setTextSize((float)errorTextSize);
        this.fltLabelTextPaint.setTextSize((float)floatingLabelSize);
        if (this.typeface != null) {
            this.errorTextPaint.setTypeface(this.typeface);
            this.fltLabelTextPaint.setTypeface(this.typeface);
            this.itemTextPaint.setTypeface(this.typeface);
        }
        this.errorTextPaint.setColor(this.baseColor);
        this.baseAlpha = this.errorTextPaint.getAlpha();
        this.selectorPath = new Path();
        this.selectorPath.setFillType(Path.FillType.EVEN_ODD);
        this.selectorPoints = new Point[3];
        for (int i = 0; i < 3; ++i) {
            this.selectorPoints[i] = new Point();
        }
    }

    private void initPadding() {
        this.innerPaddingTop = this.getPaddingTop();
        this.innerPaddingLeft = this.getPaddingLeft();
        this.innerPaddingRight = this.getPaddingRight();
        this.innerPaddingBottom = this.getPaddingBottom();
        this.extraPaddingTop = this.enableFloatingLabel ? this.floatingLabelTopSpacing + this.floatingLabelInsideSpacing + this.floatingLabelBottomSpacing : this.floatingLabelBottomSpacing;
        this.updateBottomPadding();
    }

    private void updateBottomPadding() {
        Paint.FontMetrics textMetrics = this.errorTextPaint.getFontMetrics();
        this.extraPaddingBottom = this.errorText != null ? (int)((float)(this.errorTextPaddingTop + this.underlineTopSpacing + this.errorTextPaddingBottom) + this.underlineSize) + this.errorTextPaddingTopBottom * 2 : this.underlineTopSpacing + this.errorTextPaddingBottom;
        if (this.enableErrorLabel) {
            this.extraPaddingBottom += (int)((textMetrics.descent - textMetrics.ascent) * this.currentNbErrorLines);
        }
        this.updatePadding();
        this.measureErrorText();
    }

    private void updatePadding() {
        int left = this.innerPaddingLeft;
        int top = this.innerPaddingTop + this.extraPaddingTop;
        int right = this.innerPaddingRight;
        int bottom = this.innerPaddingBottom + this.extraPaddingBottom;
        super.setPadding(left, top, right, bottom);
        this.setMinimumHeight((int)((float)(top + bottom + this.minContentHeight) + (this.itemSize > this.hintSize ? this.itemSize : this.hintSize)));
    }

    private void initDimensions(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SmartMaterialSpinner);
        this.underlineTopSpacing = this.getResources().getDimensionPixelSize(R.dimen.smsp_underline_top_spacing);
        this.errorTextPaddingBottom = this.getResources().getDimensionPixelSize(R.dimen.smsp_error_text_padding_bottom);
        this.floatingLabelTopSpacing = this.getResources().getDimensionPixelSize(R.dimen.smsp_floating_label_top_spacing);
        this.floatingLabelBottomSpacing = this.getResources().getDimensionPixelSize(R.dimen.smsp_floating_label_bottom_spacing);
        this.rightLeftSpinnerPadding = this.alignLabel ? this.getResources().getDimensionPixelSize(R.dimen.smsp_right_left_spinner_padding) : 0;
        this.floatingLabelInsideSpacing = this.getResources().getDimensionPixelSize(R.dimen.smsp_floating_label_inside_spacing);
        this.errorTextPaddingTop = this.getResources().getDimensionPixelSize(R.dimen.smsp_error_text_padding_top);
        this.errorTextPaddingTopBottom = this.getResources().getDimensionPixelSize(R.dimen.smsp_error_text_padding_top_bottom);
        this.minContentHeight = this.getResources().getDimensionPixelSize(R.dimen.smsp_min_content_height);
        this.arrowPaddingLeft = typedArray.getDimensionPixelSize(R.styleable.SmartMaterialSpinner_smsp_arrowPaddingLeft, 0);
        this.arrowPaddingTop = typedArray.getDimensionPixelSize(R.styleable.SmartMaterialSpinner_smsp_arrowPaddingTop, 0);
        this.arrowPaddingRight = typedArray.getDimensionPixelSize(R.styleable.SmartMaterialSpinner_smsp_arrowPaddingRight, this.getResources().getDimensionPixelSize(R.dimen.smsp_default_arrow_padding_right));
        this.arrowPaddingBottom = typedArray.getDimensionPixelSize(R.styleable.SmartMaterialSpinner_smsp_arrowPaddingBottom, 0);
        typedArray.recycle();
    }

    private void initOnItemSelectedListener() {
        this.setOnItemSelectedListener(null);
    }

    private void initFloatingLabelAnimator() {
        if (this.floatingLabelAnimator == null) {
            this.floatingLabelAnimator = ObjectAnimator.ofFloat((Object)this, (String)"floatingLabelPercent", (float[])new float[]{0.0f, 1.0f});
            this.floatingLabelAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        }
    }

    public void showFloatingLabel() {
        if (this.floatingLabelAnimator != null) {
            this.isFloatingLabelVisible = true;
            if (this.floatingLabelAnimator.isRunning()) {
                this.floatingLabelAnimator.reverse();
            } else {
                this.floatingLabelAnimator.start();
            }
        }
    }

    public void hideFloatingLabel() {
        if (this.floatingLabelAnimator != null) {
            this.isFloatingLabelVisible = false;
            this.floatingLabelAnimator.reverse();
        }
    }

    private void startErrorScrollingAnimator() {
        int textWidth = Math.round(this.errorTextPaint.measureText(this.errorText.toString()));
        if (this.errorLabelAnimator == null) {
            this.errorLabelAnimator = ObjectAnimator.ofInt((Object)this, (String)"errorLabelPosX", (int[])new int[]{0, textWidth + this.getWidth() / 2});
            this.errorLabelAnimator.setStartDelay(1000L);
            this.errorLabelAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.errorLabelAnimator.setDuration((long)((float)(230 * this.errorText.length()) + this.errorTextSize * 100.0f));
            this.errorLabelAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
            this.errorLabelAnimator.setRepeatCount(-1);
        } else {
            this.errorLabelAnimator.setIntValues(new int[]{0, textWidth + this.getWidth() / 2});
        }
        this.errorLabelAnimator.start();
    }

    private void startErrorMultilineAnimator(float destLines) {
        if (this.errorLabelAnimator == null) {
            this.errorLabelAnimator = ObjectAnimator.ofFloat((Object)this, (String)"currentNbErrorLines", (float[])new float[]{destLines});
        } else {
            this.errorLabelAnimator.setFloatValues(new float[]{destLines});
        }
        this.errorLabelAnimator.start();
    }

    private int dpToPx(float dp) {
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        float px = TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)displayMetrics);
        return Math.round(px);
    }

    private float pxToDp(float px) {
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        return px * displayMetrics.density;
    }

    private boolean needScrollingAnimation() {
        if (this.errorText != null) {
            float screenWidth = this.getWidth() - this.rightLeftSpinnerPadding;
            float errorTextWidth = this.errorTextPaint.measureText(this.errorText.toString(), 0, this.errorText.length());
            return errorTextWidth > screenWidth;
        }
        return false;
    }

    private void configStaticLayout(CharSequence charSequence, TextPaint textPaint, int mWidth) {
        textPaint.setTextSize(this.errorTextSize);
        if (Build.VERSION.SDK_INT >= 23) {
            StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)charSequence, (int)0, (int)charSequence.length(), (TextPaint)textPaint, (int)mWidth).setAlignment(this.getErrorTextLayoutAlignment(this.errorTextAlignment)).setLineSpacing(0.0f, 1.0f).setIncludePad(true);
            this.staticLayout = builder.build();
        } else {
            this.staticLayout = new StaticLayout(this.errorText, textPaint, mWidth, this.getErrorTextLayoutAlignment(this.errorTextAlignment), 1.0f, 0.0f, true);
        }
    }

    private int prepareBottomPadding() {
        final int[] targetNbLines = new int[]{this.minNbErrorLine};
        if (this.errorText != null) {
            final int[] mWidth = new int[]{this.getWidth() - this.getPaddingRight() - this.getPaddingLeft()};
            if (mWidth[0] <= 0) {
                this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        if (Build.VERSION.SDK_INT >= 16) {
                            SmartMaterialSpinner.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                        mWidth[0] = SmartMaterialSpinner.this.getWidth() - SmartMaterialSpinner.this.getPaddingRight() - SmartMaterialSpinner.this.getPaddingLeft();
                        SmartMaterialSpinner.this.configStaticLayout(SmartMaterialSpinner.this.errorText, SmartMaterialSpinner.this.errorTextPaint, mWidth[0]);
                        int nbErrorLines = SmartMaterialSpinner.this.staticLayout.getLineCount();
                        targetNbLines[0] = Math.max(SmartMaterialSpinner.this.minNbErrorLine, nbErrorLines);
                    }
                });
                this.currentNbErrorLines = targetNbLines[0];
                return targetNbLines[0];
            }
            this.configStaticLayout(this.errorText, this.errorTextPaint, mWidth[0]);
            int nbErrorLines = this.staticLayout.getLineCount();
            targetNbLines[0] = Math.max(this.minNbErrorLine, nbErrorLines);
        }
        this.currentNbErrorLines = targetNbLines[0];
        return targetNbLines[0];
    }

    private boolean isSpinnerEmpty() {
        return this.hintAdapter != null && this.hintAdapter.getCount() == 0 && this.hint == null || this.hintAdapter != null && this.hintAdapter.getCount() == 1 && this.getCount() == 0 && this.hint != null || this.item != null && this.item.size() == 0 && this.getCount() == 1 && this.hint != null;
    }

    private AppCompatActivity scanForActivity(Context context) {
        if (context instanceof AppCompatActivity) {
            return (AppCompatActivity)context;
        }
        if (context instanceof ContextWrapper) {
            return this.scanForActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int startX = 0;
        int endX = this.getWidth();
        int lineHeight = this.dpToPx(this.underlineSize);
        int startYLine = this.getHeight() - this.getPaddingBottom() + this.underlineTopSpacing;
        int startYFloatingLabel = (int)((float)this.getPaddingTop() - this.floatingLabelPercent * (float)this.floatingLabelBottomSpacing);
        if (this.errorText != null && this.enableErrorLabel) {
            this.paint.setColor(this.underlineColor);
            this.errorTextPaint.setColor(this.errorTextColor);
            this.errorTextPaint.setTextSize(this.errorTextSize);
            float startYErrorLabel = startYLine + this.errorTextPaddingTop + this.errorTextPaddingTopBottom + lineHeight;
            if (this.isMultilineError) {
                if (this.staticLayout == null) {
                    this.prepareBottomPadding();
                }
                canvas.save();
                canvas.translate((float)(startX + this.rightLeftSpinnerPadding - this.errorLabelPosX), startYErrorLabel - (float)this.dpToPx(4.0f));
                this.staticLayout.draw(canvas);
                canvas.restore();
            } else {
                if (!this.isErrorScrollPaddingInvoked) {
                    this.isErrorScrollPaddingInvoked = true;
                    this.updateBottomPadding();
                }
                canvas.drawText(this.errorText.toString(), (float)(startX + this.rightLeftSpinnerPadding - this.errorLabelPosX), startYErrorLabel + this.errorTextHeight, (Paint)this.errorTextPaint);
                if (this.errorLabelPosX > 0) {
                    canvas.save();
                    canvas.translate(this.errorTextPaint.measureText(this.errorText.toString()) + (float)this.getWidth() / 2.0f, 0.0f);
                    canvas.drawText(this.errorText.toString(), (float)(startX + this.rightLeftSpinnerPadding - this.errorLabelPosX), startYErrorLabel + this.errorTextHeight, (Paint)this.errorTextPaint);
                    canvas.restore();
                }
            }
        } else if (this.isSelected || this.hasFocus()) {
            this.paint.setColor(this.underlineColor);
        } else {
            this.paint.setColor(this.isEnabled() ? this.underlineColor : this.disabledColor);
        }
        canvas.drawRect((float)startX, (float)startYLine, (float)endX, (float)(startYLine + lineHeight), this.paint);
        if ((this.hint != null || this.floatingLabelText != null) && this.enableFloatingLabel) {
            String textToDraw;
            if (this.isSelected || this.hasFocus()) {
                this.fltLabelTextPaint.setColor(this.floatingLabelColor);
            } else {
                this.fltLabelTextPaint.setColor(this.isEnabled() ? this.floatingLabelColor : this.disabledColor);
            }
            if (this.floatingLabelAnimator.isRunning() || !this.isFloatingLabelVisible) {
                this.fltLabelTextPaint.setAlpha((int)((0.8 * (double)this.floatingLabelPercent + 0.2) * (double)this.baseAlpha * (double)this.floatingLabelPercent));
            }
            this.fltLabelTextPaint.setTextSize(this.floatingLabelSize);
            String string = textToDraw = this.floatingLabelText != null ? this.floatingLabelText.toString() : this.hint.toString();
            if (this.isRtl) {
                canvas.drawText(textToDraw, (float)(this.getWidth() - this.rightLeftSpinnerPadding) - this.fltLabelTextPaint.measureText(textToDraw), (float)startYFloatingLabel, (Paint)this.fltLabelTextPaint);
            } else {
                canvas.drawText(textToDraw, (float)(startX + this.rightLeftSpinnerPadding), (float)startYFloatingLabel, (Paint)this.fltLabelTextPaint);
            }
        }
        this.drawSelector(canvas, this.getWidth() - this.rightLeftSpinnerPadding - this.arrowPaddingRight + this.arrowPaddingLeft, (int)((float)(this.getPaddingTop() - this.arrowPaddingBottom + this.arrowPaddingTop) + (float)this.minContentHeight / 2.0f + this.itemSize / 2.0f - (float)this.floatingLabelTopSpacing));
    }

    private void drawSelector(Canvas canvas, int posX, int posY) {
        if (this.isSelected || this.hasFocus()) {
            this.paint.setColor(this.arrowColor);
        } else {
            this.paint.setColor(this.isEnabled() ? this.arrowColor : this.disabledColor);
        }
        Point point1 = this.selectorPoints[0];
        Point point2 = this.selectorPoints[1];
        Point point3 = this.selectorPoints[2];
        point1.set(posX, posY);
        point2.set((int)((float)posX - this.arrowSize), posY);
        point3.set((int)((float)posX - this.arrowSize / 2.0f), (int)((float)posY + this.arrowSize / 2.0f));
        this.selectorPath.reset();
        this.selectorPath.moveTo((float)point1.x, (float)point1.y);
        this.selectorPath.lineTo((float)point2.x, (float)point2.y);
        this.selectorPath.lineTo((float)point3.x, (float)point3.y);
        this.selectorPath.close();
        canvas.drawPath(this.selectorPath, this.paint);
    }

    protected void onVisibilityChanged(@NonNull View view, int visibility) {
        if (visibility == 0) {
            this.configDropdownWidthAfterDataReady();
        }
        super.onVisibilityChanged(view, visibility);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            SoftKeyboardUtil.hideSoftKeyboard(this.getContext());
            AppCompatActivity appCompatActivity = this.scanForActivity(this.getContext());
            if (appCompatActivity != null) {
                appCompatActivity.getWindow().setSoftInputMode(3);
                View view = appCompatActivity.getCurrentFocus();
                if (view instanceof EditText) {
                    view.clearFocus();
                    SoftKeyboardUtil.hideSoftKeyboard(this.getContext());
                }
            }
        }
        return super.dispatchTouchEvent(event);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 1) {
            return this.performClick();
        }
        return true;
    }

    public boolean performClick() {
        if (this.isSpinnerClickable()) {
            this.isShowing = false;
            this.onEmptySpinnerClickListener.onEmptySpinnerClicked();
            return true;
        }
        if (this.isSearchable && this.hintAdapter != null) {
            this.searchDialogItem.clear();
            int itemStart = 0;
            if (this.hint != null) {
                itemStart = 1;
            }
            for (int i = itemStart; i < this.hintAdapter.getCount(); ++i) {
                this.searchDialogItem.add(this.hintAdapter.getItem(i));
            }
            AppCompatActivity appCompatActivity = this.scanForActivity(this.getContext());
            if (appCompatActivity != null) {
                FragmentManager fragmentManager = appCompatActivity.getSupportFragmentManager();
                if (!this.isShowing()) {
                    this.isShowing = true;
                    this.searchableSpinnerDialog.show(fragmentManager, "TAG");
                }
                if (this.spinnerEventsListener != null) {
                    this.spinnerEventsListener.onSpinnerOpened(this);
                }
                return true;
            }
        } else if (this.isSpinnerEmpty()) {
            this.isShowing = false;
            return true;
        }
        this.isShowing = true;
        if (this.spinnerEventsListener != null) {
            this.spinnerEventsListener.onSpinnerOpened(this);
        }
        return super.performClick();
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        if (this.isShowing() && hasWindowFocus) {
            this.dismiss();
        }
        super.onWindowFocusChanged(hasWindowFocus);
    }

    public void setOnSpinnerEventListener(OnSpinnerEventListener onSpinnerEventListener) {
        this.spinnerEventsListener = onSpinnerEventListener;
    }

    public void dismiss() {
        this.isShowing = false;
        if (this.spinnerEventsListener != null) {
            this.spinnerEventsListener.onSpinnerClosed(this);
        }
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    public int getSelectedItemPosition() {
        int selectedIndex = super.getSelectedItemPosition();
        if (this.hint != null) {
            --selectedIndex;
        }
        return selectedIndex;
    }

    public long getSelectedItemId() {
        long itemId = super.getSelectedItemId();
        return this.hint != null ? itemId - 1L : itemId;
    }

    public Object getItemAtPosition(int position) {
        if (this.hint != null) {
            ++position;
        }
        return this.hintAdapter == null || position < 0 ? null : this.hintAdapter.getItem(position);
    }

    public long getItemIdAtPosition(int position) {
        if (this.hint != null) {
            ++position;
        }
        return this.hintAdapter == null || position < 0 ? Long.MIN_VALUE : this.hintAdapter.getItemId(position);
    }

    public void setSelection(int position) {
        if (this.isShowing && !this.isSearchable && this.hint != null) {
            --position;
        }
        if (this.isReSelectable) {
            this.ignoreOldSelectionByReflection();
        }
        final int finalPosition = position;
        this.post(new Runnable(){

            @Override
            public void run() {
                SmartMaterialSpinner.super.setSelection(SmartMaterialSpinner.this.hint != null ? finalPosition + 1 : finalPosition);
            }
        });
    }

    public void setSelection(int position, boolean animate) {
        if (this.isShowing && !this.isSearchable && this.hint != null) {
            --position;
        }
        if (this.isReSelectable) {
            this.ignoreOldSelectionByReflection();
        }
        int finalPosition = position;
        super.setSelection(this.hint != null ? finalPosition + 1 : finalPosition, animate);
    }

    public void clearSelection() {
        this.setSelection(-1);
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    private boolean ignoreOldSelectionByReflection() {
        try {
            Class<?> c = this.getClass().getSuperclass().getSuperclass().getSuperclass().getSuperclass();
            Field reqField = c.getDeclaredField("mOldSelectedPosition");
            reqField.setAccessible(true);
            reqField.setInt(this, -1);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setOnItemSelectedListener(final AdapterView.OnItemSelectedListener listener) {
        AdapterView.OnItemSelectedListener onItemSelectedListener = new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                SmartMaterialSpinner.this.lastPosition = position;
                if (SmartMaterialSpinner.this.isSearchable) {
                    SoftKeyboardUtil.hideSoftKeyboard(SmartMaterialSpinner.this.getContext());
                }
                if (SmartMaterialSpinner.this.hint != null || SmartMaterialSpinner.this.floatingLabelText != null) {
                    if (!SmartMaterialSpinner.this.isFloatingLabelVisible && position != -1) {
                        SmartMaterialSpinner.this.showFloatingLabel();
                    } else if (SmartMaterialSpinner.this.isFloatingLabelVisible && position == -1 && !SmartMaterialSpinner.this.alwaysShowFloatingLabel) {
                        SmartMaterialSpinner.this.hideFloatingLabel();
                    }
                }
                if (listener != null) {
                    listener.onItemSelected(parent, view, position, id2);
                    SmartMaterialSpinner.this.setSearchSelectedPosition(position);
                }
            }

            public void onNothingSelected(AdapterView<?> parent) {
                if (SmartMaterialSpinner.this.lastPosition != -1 && listener != null) {
                    listener.onNothingSelected(parent);
                    if (SmartMaterialSpinner.this.isFloatingLabelVisible && !SmartMaterialSpinner.this.alwaysShowFloatingLabel) {
                        SmartMaterialSpinner.this.hideFloatingLabel();
                    }
                }
            }
        };
        super.setOnItemSelectedListener(onItemSelectedListener);
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        this.invalidate();
    }

    @Override
    public void onSearchItemSelected(Object item, int position) {
        int selectedIndex = this.searchDialogItem.indexOf(item);
        if (position >= 0) {
            this.setSelection(selectedIndex);
        }
    }

    @Override
    public void onSearchableSpinnerDismiss() {
        this.dismiss();
    }

    public int getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(int baseColor) {
        this.baseColor = baseColor;
        this.errorTextPaint.setColor(baseColor);
        this.fltLabelTextPaint.setColor(baseColor);
        this.baseAlpha = this.errorTextPaint.getAlpha();
        this.invalidate();
    }

    public int getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(int highlightColor) {
        this.highlightColor = highlightColor;
        this.invalidate();
    }

    public int getHintColor() {
        return this.hintColor;
    }

    public void setHintColor(int hintColor) {
        this.hintColor = hintColor;
        this.invalidate();
    }

    public int getItemListHintColor() {
        return this.itemListHintColor;
    }

    public void setItemListHintColor(int itemListHintColor) {
        this.itemListHintColor = itemListHintColor;
        this.invalidate();
    }

    public int getItemListHintBackground() {
        return this.itemListHintBackground;
    }

    public void setItemListHintBackground(int itemListHintBackground) {
        this.itemListHintBackground = itemListHintBackground;
        this.invalidate();
    }

    public float getHintSize() {
        return this.hintSize;
    }

    public void setHintSize(float hintSize) {
        this.hintSize = this.dpToPx(hintSize);
        this.updatePadding();
        this.invalidate();
    }

    public float getErrorTextSize() {
        return this.errorTextSize;
    }

    public void setErrorTextSize(float errorTextSize) {
        this.errorTextSize = this.dpToPx(errorTextSize);
        this.measureErrorText();
        this.invalidate();
    }

    public int getErrorTextColor() {
        return this.errorTextColor;
    }

    public void setErrorTextColor(int errorTextColor) {
        this.errorTextColor = errorTextColor;
        this.invalidate();
    }

    private Layout.Alignment getErrorTextLayoutAlignment(ErrorTextAlignment errorTextAlignment) {
        switch (errorTextAlignment) {
            case ALIGN_LEFT: {
                return Layout.Alignment.ALIGN_NORMAL;
            }
            case ALIGN_CENTER: {
                return Layout.Alignment.ALIGN_CENTER;
            }
            case ALIGN_RIGHT: {
                return Layout.Alignment.ALIGN_OPPOSITE;
            }
        }
        return Layout.Alignment.ALIGN_NORMAL;
    }

    private ErrorTextAlignment getErrorTextAlignment(int attrNum) {
        switch (attrNum) {
            case 0: {
                return ErrorTextAlignment.ALIGN_LEFT;
            }
            case 1: {
                return ErrorTextAlignment.ALIGN_CENTER;
            }
            case 2: {
                return ErrorTextAlignment.ALIGN_RIGHT;
            }
        }
        return ErrorTextAlignment.ALIGN_LEFT;
    }

    public ErrorTextAlignment getErrorTextAlignment() {
        return this.errorTextAlignment;
    }

    public void setErrorTextAlignment(ErrorTextAlignment errorTextAlignment) {
        this.errorTextAlignment = errorTextAlignment;
        this.invalidate();
    }

    public int getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(int disabledColor) {
        this.disabledColor = disabledColor;
        this.invalidate();
    }

    public CharSequence getHint() {
        return this.hint;
    }

    public void setHint(CharSequence hint) {
        this.hint = hint;
        if (hint == null) {
            this.hint = "";
        }
        if (this.isSpinnerEmpty()) {
            this.setAdapter(this.getAdapter());
        }
        this.invalidate();
    }

    public void setHint(int resId) {
        String hint = this.getResources().getString(resId);
        this.setHint(hint);
    }

    public void setItemView(Integer resId) {
        this.itemView = resId;
        this.invalidate();
    }

    public void setDropdownView(Integer resId) {
        this.dropdownView = resId;
        this.invalidate();
    }

    public CharSequence getFloatingLabelText() {
        return this.floatingLabelText;
    }

    public void setFloatingLabelText(CharSequence floatingLabelText) {
        this.floatingLabelText = floatingLabelText;
        this.invalidate();
    }

    public void setFloatingLabelText(int resId) {
        String floatingLabelText = this.getResources().getString(resId);
        this.setFloatingLabelText(floatingLabelText);
    }

    public float getFloatingLabelSize() {
        return this.floatingLabelSize;
    }

    public void setFloatingLabelSize(float floatingLabelSize) {
        this.floatingLabelSize = this.dpToPx(floatingLabelSize);
        this.invalidate();
    }

    public int getFloatingLabelColor() {
        return this.floatingLabelColor;
    }

    public void setFloatingLabelColor(int floatingLabelColor) {
        this.floatingLabelColor = floatingLabelColor;
        this.invalidate();
    }

    public boolean isMultilineError() {
        return this.isMultilineError;
    }

    public void setMultilineError(boolean multilineError) {
        this.isMultilineError = multilineError;
        this.invalidate();
    }

    public Typeface getTypeface() {
        return this.typeface;
    }

    public void setTypeface(Typeface typeface) {
        this.typeface = typeface;
        if (typeface != null) {
            this.errorTextPaint.setTypeface(typeface);
            this.fltLabelTextPaint.setTypeface(typeface);
        }
        this.invalidate();
    }

    public boolean isAlignLabel() {
        return this.alignLabel;
    }

    public void setAlignLabel(boolean alignLabel) {
        this.alignLabel = alignLabel;
        this.rightLeftSpinnerPadding = alignLabel ? this.getResources().getDimensionPixelSize(R.dimen.smsp_right_left_spinner_padding) : 0;
        this.invalidate();
    }

    public float getArrowSize() {
        return this.arrowSize;
    }

    public void setArrowSize(float arrowSize) {
        this.arrowSize = arrowSize;
        this.invalidate();
    }

    public int getArrowColor() {
        return this.arrowColor;
    }

    public void setArrowColor(int arrowColor) {
        this.arrowColor = arrowColor;
        this.invalidate();
    }

    public float getUnderlineSize() {
        return this.underlineSize;
    }

    public void setUnderlineSize(float underlineSize) {
        this.underlineSize = underlineSize;
        this.invalidate();
    }

    public int getUnderlineColor() {
        return this.underlineColor;
    }

    public void setUnderlineColor(int underlineColor) {
        this.underlineColor = underlineColor;
        this.invalidate();
    }

    public boolean isEnableErrorLabel() {
        return this.enableErrorLabel;
    }

    public void setEnableErrorLabel(boolean enableErrorLabel) {
        this.enableErrorLabel = enableErrorLabel;
        this.updateBottomPadding();
        this.invalidate();
    }

    public boolean isEnableFloatingLabel() {
        return this.enableFloatingLabel;
    }

    public void setEnableFloatingLabel(boolean enableFloatingLabel) {
        this.enableFloatingLabel = enableFloatingLabel;
        this.extraPaddingTop = enableFloatingLabel ? this.floatingLabelTopSpacing + this.floatingLabelInsideSpacing + this.floatingLabelBottomSpacing : this.floatingLabelBottomSpacing;
        this.updateBottomPadding();
        this.invalidate();
    }

    public boolean isAlwaysShowFloatingLabel() {
        return this.alwaysShowFloatingLabel;
    }

    public void setAlwaysShowFloatingLabel(boolean alwaysShowFloatingLabel) {
        this.alwaysShowFloatingLabel = alwaysShowFloatingLabel;
        this.invalidate();
    }

    public CharSequence getErrorText() {
        return this.errorText;
    }

    public void setErrorText(CharSequence errorText) {
        this.errorText = errorText;
        if (this.errorLabelAnimator != null) {
            this.errorLabelAnimator.end();
        }
        if (this.isMultilineError) {
            this.startErrorMultilineAnimator(this.prepareBottomPadding());
        } else if (this.needScrollingAnimation()) {
            this.startErrorScrollingAnimator();
        }
        this.updateBottomPadding();
        this.requestLayout();
    }

    public void setErrorText(int resId) {
        String error = this.getResources().getString(resId);
        this.setErrorText(error);
    }

    private void measureErrorText() {
        if (this.errorText != null) {
            this.errorTextPaint.setTextSize(this.errorTextSize);
            this.errorTextPaint.getTextBounds(this.errorText.toString(), 0, this.errorText.length(), this.errorTextRect);
            this.errorTextWidth = this.errorTextPaint.measureText(this.errorText.toString());
            this.errorTextHeight = this.errorTextRect.height();
        }
    }

    private void measureItemText(String itemText) {
        if (itemText != null) {
            this.itemTextPaint.getTextBounds(itemText, 0, itemText.length(), this.itemTextRect);
            this.itemTextWidth = this.itemTextPaint.measureText(itemText);
            this.itemTextHeight = this.itemTextRect.height();
        }
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.isSelected = false;
            this.invalidate();
        }
        super.setEnabled(enabled);
    }

    public boolean isRtl() {
        return this.isRtl;
    }

    public void setRtl() {
        this.isRtl = true;
        this.invalidate();
    }

    public float getItemSize() {
        return this.itemSize;
    }

    public void setItemSize(float itemSize) {
        this.itemSize = this.dpToPx(itemSize);
        this.updatePadding();
        this.invalidate();
    }

    public int getItemColor() {
        return this.itemColor;
    }

    public void setItemColor(int color2) {
        this.itemColor = color2;
        this.invalidate();
    }

    public int getItemListColor() {
        return this.itemListColor;
    }

    public void setItemListColor(int color2) {
        this.itemListColor = color2;
        this.setSearchListItemColor(this.itemListColor);
        if (this.selectedItemListColor == -16777216 && color2 != -16777216) {
            this.selectedItemListColor = color2;
            this.setSelectedSearchItemColor(this.selectedItemListColor);
        }
        this.invalidate();
    }

    public int getSelectedItemListColor() {
        return this.selectedItemListColor;
    }

    public void setSelectedItemListColor(int selectedItemListColor) {
        this.selectedItemListColor = selectedItemListColor;
        this.setSelectedSearchItemColor(this.selectedItemListColor);
        this.invalidate();
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public void setSearchable(boolean searchable) {
        this.isSearchable = searchable;
        this.invalidate();
    }

    public boolean isEnableSearchHeader() {
        return this.isEnableSearchHeader;
    }

    public void setEnableSearchHeader(boolean isEnableSearchHeader) {
        this.isEnableSearchHeader = isEnableSearchHeader;
        if (this.searchableSpinnerDialog != null) {
            this.searchableSpinnerDialog.setEnableSearchHeader(isEnableSearchHeader);
        }
        this.invalidate();
    }

    public String getSearchHeaderText() {
        return this.searchHeaderText;
    }

    public void setSearchHeaderText(String searchHeaderText) {
        this.searchHeaderText = searchHeaderText;
        if (this.searchableSpinnerDialog != null) {
            this.searchableSpinnerDialog.setSearchHeaderText(searchHeaderText);
        }
        this.invalidate();
    }

    public int getSearchHeaderTextColor() {
        return this.searchHeaderTextColor;
    }

    public void setSearchHeaderTextColor(int color2) {
        this.searchHeaderTextColor = color2;
        if (this.searchableSpinnerDialog != null) {
            this.searchableSpinnerDialog.setSearchHeaderTextColor(color2);
        }
        this.invalidate();
    }

    public void setSearchHeaderBackgroundColor(int color2) {
        if (this.searchableSpinnerDialog != null) {
            this.searchableSpinnerDialog.setSearchHeaderBackgroundColor(color2);
        }
        this.invalidate();
    }

    @RequiresApi(api=16)
    public void setSearchHeaderBackgroundColor(Drawable drawable2) {
        if (this.searchableSpinnerDialog != null) {
            this.searchableSpinnerDialog.setSearchHeaderBackgroundColor(drawable2);
        }
        this.invalidate();
    }

    public String getSearchHint() {
        return this.searchHint;
    }

    public void setSearchHint(String searchHint) {
        this.searchHint = searchHint;
        if (this.searchableSpinnerDialog != null) {
            this.searchableSpinnerDialog.setSearchHint(searchHint);
        }
        this.invalidate();
    }

    public void setSearchListItemColor(int searchListItemColor) {
        if (this.searchableSpinnerDialog != null) {
            this.searchableSpinnerDialog.setSearchListItemColor(searchListItemColor);
        }
        this.invalidate();
    }

    public void setSelectedSearchItemColor(int selectedSearchItemColor) {
        if (this.searchableSpinnerDialog != null) {
            this.searchableSpinnerDialog.setSelectedSearchItemColor(selectedSearchItemColor);
        }
        this.invalidate();
    }

    private void setSearchSelectedPosition(int position) {
        if (this.searchableSpinnerDialog != null) {
            this.searchableSpinnerDialog.setSelectedPosition(position);
        }
        this.invalidate();
    }

    public void setSearchDialogGravity(int gravity) {
        if (this.searchableSpinnerDialog != null) {
            this.searchableSpinnerDialog.setGravity(gravity);
        }
        this.invalidate();
    }

    public int getArrowPaddingLeft() {
        return this.arrowPaddingLeft;
    }

    public void setArrowPaddingLeft(int padding) {
        this.arrowPaddingLeft = this.dpToPx(padding);
        this.invalidate();
    }

    public int getArrowPaddingTop() {
        return this.arrowPaddingTop;
    }

    public void setArrowPaddingTop(int padding) {
        this.arrowPaddingTop = this.dpToPx(padding);
        this.invalidate();
    }

    public int getArrowPaddingRight() {
        return this.arrowPaddingRight;
    }

    public void setArrowPaddingRight(int padding) {
        this.arrowPaddingRight = this.dpToPx(padding);
        this.invalidate();
    }

    public int getArrowPaddingBottom() {
        return this.arrowPaddingBottom;
    }

    public void setArrowPaddingBottom(int padding) {
        this.arrowPaddingBottom = this.dpToPx(padding);
        this.invalidate();
    }

    public void setArrowPadding(int left, int top, int right, int bottom) {
        this.arrowPaddingLeft = left;
        this.arrowPaddingTop = top;
        this.arrowPaddingRight = right;
        this.arrowPaddingBottom = bottom;
        this.invalidate();
    }

    public void setOnEmptySpinnerClickListener(OnEmptySpinnerClickListener onEmptySpinnerClickListener) {
        this.onEmptySpinnerClickListener = onEmptySpinnerClickListener;
    }

    private boolean isSpinnerClickable() {
        return this.isSpinnerEmpty() && this.onEmptySpinnerClickListener != null;
    }

    @Deprecated
    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
    }

    public void setPaddingSafe(int left, int top, int right, int bottom) {
        this.innerPaddingRight = right;
        this.innerPaddingLeft = left;
        this.innerPaddingTop = top;
        this.innerPaddingBottom = bottom;
        this.updatePadding();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void setAdapter(SpinnerAdapter adapter) {
        this.hintAdapter = new HintAdapter(adapter, this.getContext());
        super.setAdapter((SpinnerAdapter)this.hintAdapter);
    }

    public void setItem(@NonNull List<T> item) {
        this.item = item;
        ArrayAdapter adapter = new ArrayAdapter(this.getContext(), R.layout.smart_material_spinner_item_layout, item);
        adapter.setDropDownViewResource(R.layout.smart_material_spinner_dropdown_item_layout);
        this.setAdapter((SpinnerAdapter)adapter);
        this.configDropdownWidthAfterDataReady();
        this.invalidate();
    }

    public List<T> getItem() {
        return this.item;
    }

    public SpinnerAdapter getAdapter() {
        return this.hintAdapter != null ? this.hintAdapter.getWrappedAdapter() : null;
    }

    private float getFloatingLabelPercent() {
        return this.floatingLabelPercent;
    }

    private void setFloatingLabelPercent(float floatingLabelPercent) {
        this.floatingLabelPercent = floatingLabelPercent;
    }

    private int getErrorLabelPosX() {
        return this.errorLabelPosX;
    }

    private void setErrorLabelPosX(int errorLabelPosX) {
        this.errorLabelPosX = errorLabelPosX;
    }

    private float getCurrentNbErrorLines() {
        return this.currentNbErrorLines;
    }

    private void setCurrentNbErrorLines(float currentNbErrorLines) {
        this.currentNbErrorLines = currentNbErrorLines;
        this.updateBottomPadding();
    }

    public boolean isReSelectable() {
        return this.isReSelectable;
    }

    public void setReSelectable(boolean reSelectable) {
        this.isReSelectable = reSelectable;
    }

    public static enum ErrorTextAlignment {
        ALIGN_LEFT,
        ALIGN_CENTER,
        ALIGN_RIGHT;

    }

    public static interface OnSpinnerEventListener {
        public void onSpinnerOpened(SmartMaterialSpinner var1);

        public void onSpinnerClosed(SmartMaterialSpinner var1);
    }

    public static interface OnEmptySpinnerClickListener {
        public void onEmptySpinnerClicked();
    }

    private class HintAdapter<T>
    extends BaseAdapter {
        private static final int HINT_TYPE = -1;
        private SpinnerAdapter mSpinnerAdapter;
        private Context mContext;

        public HintAdapter(SpinnerAdapter spinnerAdapter, Context context) {
            this.mSpinnerAdapter = spinnerAdapter;
            this.mContext = context;
        }

        public int getViewTypeCount() {
            if (Build.VERSION.SDK_INT >= 21) {
                return 1;
            }
            return this.mSpinnerAdapter.getViewTypeCount();
        }

        public int getItemViewType(int position) {
            position = SmartMaterialSpinner.this.hint != null ? position - 1 : position;
            return position == -1 ? -1 : this.mSpinnerAdapter.getItemViewType(position);
        }

        public int getCount() {
            int count = this.mSpinnerAdapter.getCount();
            return SmartMaterialSpinner.this.hint != null ? count + 1 : count;
        }

        public Object getItem(int position) {
            position = SmartMaterialSpinner.this.hint != null ? position - 1 : position;
            return position == -1 ? SmartMaterialSpinner.this.hint : this.mSpinnerAdapter.getItem(position);
        }

        public long getItemId(int position) {
            position = SmartMaterialSpinner.this.hint != null ? position - 1 : position;
            return position == -1 ? 0L : this.mSpinnerAdapter.getItemId(position);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            return this.buildView(position, convertView, parent, false);
        }

        public View getDropDownView(int position, View convertView, ViewGroup parent) {
            return this.buildView(position, convertView, parent, true);
        }

        private View buildView(int position, View convertView, ViewGroup parent, boolean isDropDownView) {
            View dropdownItemView;
            if (this.getItemViewType(position) == -1) {
                if (SmartMaterialSpinner.this.hint != null && !SmartMaterialSpinner.this.hint.toString().isEmpty()) {
                    return this.getItemView(convertView, parent, isDropDownView);
                }
                return new View(SmartMaterialSpinner.this.getContext());
            }
            if (convertView != null) {
                convertView = convertView.getTag() != null && convertView.getTag() instanceof Integer && (Integer)convertView.getTag() != -1 ? convertView : null;
            }
            position = SmartMaterialSpinner.this.hint != null ? position - 1 : position;
            View view = dropdownItemView = isDropDownView ? this.mSpinnerAdapter.getDropDownView(position, convertView, parent) : this.mSpinnerAdapter.getView(position, convertView, parent);
            if (dropdownItemView instanceof TextView) {
                TextView textView = (TextView)dropdownItemView;
                this.updateSpinnerItemStyle(parent, textView, isDropDownView, false, position);
            }
            return dropdownItemView;
        }

        private View getItemView(View convertView, ViewGroup parent, boolean isDropDownView) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
            int resId = isDropDownView ? SmartMaterialSpinner.this.dropdownView : SmartMaterialSpinner.this.itemView;
            TextView textView = (TextView)inflater.inflate(resId, parent, false);
            textView.setTag((Object)-1);
            this.updateSpinnerItemStyle(parent, textView, isDropDownView, true, -1);
            if (SmartMaterialSpinner.this.isShowing()) {
                textView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                    }
                });
            }
            return textView;
        }

        private SpinnerAdapter getWrappedAdapter() {
            return this.mSpinnerAdapter;
        }

        private void updateSpinnerItemStyle(ViewGroup parent, TextView textView, boolean isDropDownView, boolean isHint, int position) {
            if (isHint) {
                textView.setText(SmartMaterialSpinner.this.hint);
                textView.setTextSize(0, SmartMaterialSpinner.this.hintSize);
                if (isDropDownView) {
                    textView.setTextColor(SmartMaterialSpinner.this.itemListHintColor);
                    textView.setBackgroundColor(SmartMaterialSpinner.this.itemListHintBackground);
                } else {
                    textView.setTextColor(SmartMaterialSpinner.this.isEnabled() ? SmartMaterialSpinner.this.hintColor : SmartMaterialSpinner.this.disabledColor);
                    SmartMaterialSpinner.this.measureItemText(textView.getText().toString());
                    textView.setPadding(textView.getPaddingLeft(), textView.getPaddingTop(), (int)((float)SmartMaterialSpinner.this.arrowPaddingRight + SmartMaterialSpinner.this.itemTextHeight), textView.getPaddingBottom());
                }
            } else if (isDropDownView) {
                parent.setPadding(0, 0, 0, 0);
                textView.setTextColor(SmartMaterialSpinner.this.itemListColor);
                if (position >= 0 && position == SmartMaterialSpinner.this.getSelectedItemPosition()) {
                    textView.setTextColor(SmartMaterialSpinner.this.selectedItemListColor);
                }
            } else {
                textView.setTextSize(0, SmartMaterialSpinner.this.itemSize);
                textView.setTextColor(SmartMaterialSpinner.this.itemColor);
                SmartMaterialSpinner.this.measureItemText(textView.getText().toString());
                textView.setPadding(textView.getPaddingLeft(), textView.getPaddingTop(), (int)((float)SmartMaterialSpinner.this.arrowPaddingRight + SmartMaterialSpinner.this.itemTextHeight), textView.getPaddingBottom());
            }
        }
    }
}

