/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp;

import cn.beecp.BeeDataSourceConfig;
import cn.beecp.BeeDataSourceConfigException;
import cn.beecp.pool.ConnectionPool;
import cn.beecp.pool.ConnectionPoolMonitorVo;
import cn.beecp.pool.FastConnectionPool;
import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.xa.ProxyXaConnection;
import cn.beecp.xa.RawXaConnectionFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class BeeDataSource
extends BeeDataSourceConfig
implements DataSource,
XADataSource {
    private static final HashMap<String, String> XaConnectionFactoryMap = new HashMap(5);
    private static final SQLException XaConnectionFactoryNotFound = new SQLException("xaConnectionFactory can't be null,please config xaConnectionFactory or xaConnectionFactoryClassName");
    private volatile boolean inited;
    private volatile ConnectionPool pool;
    private volatile SQLException failedCause;
    private RawXaConnectionFactory xaConnectionFactory;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock.ReadLock rLock = this.lock.readLock();
    private ReentrantReadWriteLock.WriteLock wLock = this.lock.writeLock();

    public BeeDataSource() {
    }

    public BeeDataSource(String driver, String url, String user, String password) {
        super(driver, url, user, password);
    }

    public BeeDataSource(BeeDataSourceConfig config) {
        try {
            config.copyTo(this);
            this.pool = this.createPool(this);
            this.inited = true;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Connection getConnection() throws SQLException {
        if (this.inited) {
            return this.pool.getConnection();
        }
        if (this.wLock.tryLock()) {
            try {
                if (this.inited) return this.pool.getConnection();
                this.failedCause = null;
                this.pool = this.createPool(this);
                this.inited = true;
                return this.pool.getConnection();
            }
            catch (Throwable e) {
                this.failedCause = e instanceof SQLException ? (SQLException)e : new SQLException(e);
                throw this.failedCause;
            }
            finally {
                this.wLock.unlock();
            }
        } else {
            try {
                this.rLock.lock();
                if (this.failedCause == null) return this.pool.getConnection();
                throw this.failedCause;
            }
            finally {
                this.rLock.unlock();
            }
        }
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        if (this.xaConnectionFactory == null) {
            throw XaConnectionFactoryNotFound;
        }
        ProxyConnectionBase proxyCon = (ProxyConnectionBase)this.getConnection();
        return new ProxyXaConnection(this.xaConnectionFactory.create(proxyCon.getRaw()), proxyCon);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("Not support");
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        throw new SQLException("Not support");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("Wrapped object was not an instance of " + iface);
    }

    public boolean isClosed() {
        return this.pool != null ? this.pool.isClosed() : true;
    }

    public void close() {
        if (this.pool != null) {
            try {
                this.pool.close();
            }
            catch (Throwable e) {
                PoolStaticCenter.CommonLog.error("Error at closing connection pool,cause:", e);
            }
        }
    }

    @Override
    public void setPrintRuntimeLog(boolean printRuntimeLog) {
        if (this.pool != null) {
            this.pool.setPrintRuntimeLog(printRuntimeLog);
        }
    }

    public ConnectionPoolMonitorVo getPoolMonitorVo() throws SQLException {
        if (this.pool == null) {
            throw new SQLException("Connection pool not be initialized");
        }
        return this.pool.getMonitorVo();
    }

    public void clearAllConnections() throws SQLException {
        this.clearAllConnections(false);
    }

    public void clearAllConnections(boolean force) throws SQLException {
        if (this.pool == null) {
            throw new SQLException("Connection pool not be initialized");
        }
        this.pool.clearAllConnections(force);
    }

    private final ConnectionPool createPool(BeeDataSourceConfig config) throws SQLException {
        String driverType;
        this.xaConnectionFactory = this.tryCreateXAConnectionFactoryByConfig(config);
        if (this.xaConnectionFactory == null && !PoolStaticCenter.isBlank(config.getUrl()) && !PoolStaticCenter.isBlank(driverType = this.getDriverType(config.getUrl()))) {
            String xaConnectionFactoryClassName = XaConnectionFactoryMap.get(driverType);
            this.xaConnectionFactory = this.createXAConnectionFactoryByClassName(xaConnectionFactoryClassName);
        }
        ConnectionPool pool = this.createPoolInstanceByConfig(config);
        pool.init(config);
        return pool;
    }

    private final ConnectionPool createPoolInstanceByConfig(BeeDataSourceConfig config) throws BeeDataSourceConfigException {
        String poolImplementClassName = config.getPoolImplementClassName();
        if (PoolStaticCenter.isBlank(poolImplementClassName)) {
            poolImplementClassName = FastConnectionPool.class.getName();
        }
        try {
            Class<?> poolClass = Class.forName(poolImplementClassName, true, this.getClass().getClassLoader());
            if (ConnectionPool.class.isAssignableFrom(poolClass)) {
                return (ConnectionPool)poolClass.newInstance();
            }
            throw new BeeDataSourceConfigException("poolImplementClassName error,must implement '" + ConnectionPool.class.getName() + "' interface");
        }
        catch (ClassNotFoundException e) {
            throw new BeeDataSourceConfigException("Not found connection pool class:" + poolImplementClassName);
        }
        catch (InstantiationException e) {
            throw new BeeDataSourceConfigException("Failed to instantiate connection pool class:" + poolImplementClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new BeeDataSourceConfigException("Failed to instantiate connection pool class:" + poolImplementClassName, e);
        }
    }

    private final RawXaConnectionFactory tryCreateXAConnectionFactoryByConfig(BeeDataSourceConfig config) throws BeeDataSourceConfigException {
        if (config.getXaConnectionFactory() != null) {
            return config.getXaConnectionFactory();
        }
        return this.createXAConnectionFactoryByClassName(config.getXaConnectionFactoryClassName());
    }

    private final RawXaConnectionFactory createXAConnectionFactoryByClassName(String xaConnectionFactoryClassName) throws BeeDataSourceConfigException {
        if (!PoolStaticCenter.isBlank(xaConnectionFactoryClassName)) {
            try {
                Class<?> xaConnectionFactoryClass = Class.forName(xaConnectionFactoryClassName, true, this.getClass().getClassLoader());
                if (RawXaConnectionFactory.class.isAssignableFrom(xaConnectionFactoryClass)) {
                    return (RawXaConnectionFactory)xaConnectionFactoryClass.newInstance();
                }
                throw new BeeDataSourceConfigException("xaConnectionFactoryClassName error,must implement '" + RawXaConnectionFactory.class.getName() + "' interface");
            }
            catch (ClassNotFoundException e) {
                throw new BeeDataSourceConfigException("Not found XAConnection factory class:" + xaConnectionFactoryClassName);
            }
            catch (InstantiationException e) {
                throw new BeeDataSourceConfigException("Failed to instantiate XAConnection factory class:" + xaConnectionFactoryClassName, e);
            }
            catch (IllegalAccessException e) {
                throw new BeeDataSourceConfigException("Failed to instantiate XAConnection factory class:" + xaConnectionFactoryClassName, e);
            }
        }
        return null;
    }

    private String getDriverType(String url) {
        try {
            int pos;
            Driver driver = DriverManager.getDriver(url);
            url = url.toLowerCase(Locale.US);
            String urlPrefix = "jdbc:";
            if (url.startsWith(urlPrefix) && (pos = url.indexOf(58, urlPrefix.length())) > 0) {
                return url.substring(urlPrefix.length(), pos);
            }
            if (url.indexOf("oracle") > 1) {
                return "oracle";
            }
            if (url.indexOf("mysql") > 1) {
                return "mysql" + driver.getMajorVersion();
            }
            if (url.indexOf("mariadb") > 1) {
                return "mariadb";
            }
            if (url.indexOf("postgresql") > 1) {
                return "postgresql";
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    static {
        XaConnectionFactoryMap.put("oracle", "cn.beecp.xa.impl.OracleXaConnectionFactory");
        XaConnectionFactoryMap.put("mariadb", "cn.beecp.xa.impl.MariadbXaConnectionFactory");
        XaConnectionFactoryMap.put("mysql5", "cn.beecp.xa.impl.Mysql5XaConnectionFactory");
        XaConnectionFactoryMap.put("mysql8", "cn.beecp.xa.impl.Mysql8XaConnectionFactory");
        XaConnectionFactoryMap.put("postgresql", "cn.beecp.xa.impl.PostgresXaConnectionFactory");
    }
}

