/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp;

import cn.beecp.BeeDataSourceConfigException;
import cn.beecp.BeeDataSourceConfigJmxBean;
import cn.beecp.RawConnectionFactory;
import cn.beecp.TransactionIsolationLevel;
import cn.beecp.pool.DataSourceConnectionFactory;
import cn.beecp.pool.DriverConnectionFactory;
import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.xa.RawXaConnectionFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;

public class BeeDataSourceConfig
implements BeeDataSourceConfigJmxBean {
    private static final int NCPUS = Runtime.getRuntime().availableProcessors();
    private static final AtomicInteger PoolNameIndex = new AtomicInteger(1);
    private String username;
    private String password;
    private String jdbcUrl;
    private String driverClassName;
    private String poolName;
    private boolean fairMode;
    private int initialSize;
    private int maxActive = Math.min(Math.max(10, NCPUS), 50);
    private int borrowSemaphoreSize = Math.min(this.maxActive / 2, NCPUS);
    private long maxWait = TimeUnit.SECONDS.toMillis(8L);
    private long idleTimeout = TimeUnit.MINUTES.toMillis(3L);
    private long holdTimeout = TimeUnit.MINUTES.toMillis(3L);
    private String validTestSql = "SELECT 1";
    private int validTestTimeout = 3;
    private long validAssumeTime = 500L;
    private long timerCheckInterval = TimeUnit.MINUTES.toMillis(3L);
    private boolean forceCloseUsingOnClear;
    private long delayTimeForNextClear = 3000L;
    private String defaultCatalog;
    private String defaultSchema;
    private boolean defaultReadOnly;
    private boolean defaultAutoCommit = true;
    private int defaultTransactionIsolationCode = -999;
    private String defaultTransactionIsolationName;
    private RawConnectionFactory connectionFactory;
    private String connectionFactoryClassName;
    private RawXaConnectionFactory xaConnectionFactory;
    private String xaConnectionFactoryClassName;
    private Properties connectProperties = new Properties();
    private String poolImplementClassName;
    private boolean enableJmx;
    private boolean printConfigLog;
    private boolean printRuntimeLog;

    public BeeDataSourceConfig() {
    }

    public BeeDataSourceConfig(File propertiesFile) {
        this.loadFromPropertiesFile(propertiesFile);
    }

    public BeeDataSourceConfig(String propertiesFileName) {
        this.loadFromPropertiesFile(propertiesFileName);
    }

    public BeeDataSourceConfig(Properties configProperties) {
        this.loadFromProperties(configProperties);
    }

    public BeeDataSourceConfig(String driver, String url, String user, String password) {
        this.jdbcUrl = PoolStaticCenter.trimString(url);
        this.username = PoolStaticCenter.trimString(user);
        this.password = PoolStaticCenter.trimString(password);
        this.driverClassName = PoolStaticCenter.trimString(driver);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = PoolStaticCenter.trimString(username);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = PoolStaticCenter.trimString(password);
    }

    @Override
    public String getUrl() {
        return this.jdbcUrl;
    }

    public void setUrl(String jdbcUrl) {
        this.jdbcUrl = PoolStaticCenter.trimString(jdbcUrl);
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = PoolStaticCenter.trimString(jdbcUrl);
    }

    @Override
    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = PoolStaticCenter.trimString(driverClassName);
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = PoolStaticCenter.trimString(poolName);
    }

    @Override
    public boolean isFairMode() {
        return this.fairMode;
    }

    public void setFairMode(boolean fairMode) {
        this.fairMode = fairMode;
    }

    @Override
    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        if (initialSize >= 0) {
            this.initialSize = initialSize;
        }
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        if (maxActive > 0) {
            this.maxActive = maxActive;
            this.borrowSemaphoreSize = maxActive > 1 ? Math.min(maxActive / 2, NCPUS) : 1;
        }
    }

    @Override
    public int getBorrowSemaphoreSize() {
        return this.borrowSemaphoreSize;
    }

    public void setBorrowSemaphoreSize(int borrowSemaphoreSize) {
        if (borrowSemaphoreSize > 0) {
            this.borrowSemaphoreSize = borrowSemaphoreSize;
        }
    }

    @Override
    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        if (maxWait > 0L) {
            this.maxWait = maxWait;
        }
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        if (idleTimeout > 0L) {
            this.idleTimeout = idleTimeout;
        }
    }

    @Override
    public long getHoldTimeout() {
        return this.holdTimeout;
    }

    public void setHoldTimeout(long holdTimeout) {
        if (holdTimeout > 0L) {
            this.holdTimeout = holdTimeout;
        }
    }

    @Override
    public String getValidTestSql() {
        return this.validTestSql;
    }

    public void setValidTestSql(String validTestSql) {
        if (!PoolStaticCenter.isBlank(validTestSql)) {
            this.validTestSql = PoolStaticCenter.trimString(validTestSql);
        }
    }

    @Override
    public int getValidTestTimeout() {
        return this.validTestTimeout;
    }

    public void setValidTestTimeout(int validTestTimeout) {
        if (validTestTimeout >= 0) {
            this.validTestTimeout = validTestTimeout;
        }
    }

    @Override
    public long getValidAssumeTime() {
        return this.validAssumeTime;
    }

    public void setValidAssumeTime(long validAssumeTime) {
        if (validAssumeTime >= 0L) {
            this.validAssumeTime = validAssumeTime;
        }
    }

    @Override
    public long getTimerCheckInterval() {
        return this.timerCheckInterval;
    }

    public void setTimerCheckInterval(long timerCheckInterval) {
        if (timerCheckInterval > 0L) {
            this.timerCheckInterval = timerCheckInterval;
        }
    }

    @Override
    public boolean isForceCloseUsingOnClear() {
        return this.forceCloseUsingOnClear;
    }

    public void setForceCloseUsingOnClear(boolean forceCloseUsingOnClear) {
        this.forceCloseUsingOnClear = forceCloseUsingOnClear;
    }

    @Override
    public long getDelayTimeForNextClear() {
        return this.delayTimeForNextClear;
    }

    public void setDelayTimeForNextClear(long delayTimeForNextClear) {
        if (delayTimeForNextClear > 0L) {
            this.delayTimeForNextClear = delayTimeForNextClear;
        }
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = PoolStaticCenter.trimString(defaultCatalog);
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = PoolStaticCenter.trimString(defaultSchema);
    }

    @Override
    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    @Override
    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    @Override
    public int getDefaultTransactionIsolationCode() {
        return this.defaultTransactionIsolationCode;
    }

    public void setDefaultTransactionIsolationCode(int defaultTransactionIsolationCode) {
        this.defaultTransactionIsolationCode = defaultTransactionIsolationCode;
    }

    @Override
    public String getDefaultTransactionIsolationName() {
        return this.defaultTransactionIsolationName;
    }

    public void setDefaultTransactionIsolationName(String defaultTransactionIsolationName) {
        this.defaultTransactionIsolationName = PoolStaticCenter.trimString(defaultTransactionIsolationName);
    }

    public RawConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(RawConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public String getConnectionFactoryClassName() {
        return this.connectionFactoryClassName;
    }

    public void setConnectionFactoryClassName(String connectionFactoryClassName) {
        this.connectionFactoryClassName = PoolStaticCenter.trimString(connectionFactoryClassName);
    }

    public RawXaConnectionFactory getXaConnectionFactory() {
        return this.xaConnectionFactory;
    }

    public void setXaConnectionFactory(RawXaConnectionFactory xaConnectionFactory) {
        this.xaConnectionFactory = xaConnectionFactory;
    }

    public String getXaConnectionFactoryClassName() {
        return this.xaConnectionFactoryClassName;
    }

    public void setXaConnectionFactoryClassName(String xaConnectionFactoryClassName) {
        this.xaConnectionFactoryClassName = PoolStaticCenter.trimString(xaConnectionFactoryClassName);
    }

    public void removeConnectProperty(String key) {
        if (!PoolStaticCenter.isBlank(key)) {
            this.connectProperties.remove(key);
        }
    }

    public void addConnectProperty(String key, Object value) {
        if (!PoolStaticCenter.isBlank(key) && value != null) {
            this.connectProperties.put(key, value);
        }
    }

    public void addConnectProperty(String connectPropertyText) {
        if (!PoolStaticCenter.isBlank(connectPropertyText)) {
            String[] attributeArray;
            for (String attribute : attributeArray = connectPropertyText.split("&")) {
                String[] pair = attribute.split("=");
                if (pair.length == 2) {
                    this.addConnectProperty(pair[0].trim(), pair[1].trim());
                    continue;
                }
                pair = attribute.split(":");
                if (pair.length != 2) continue;
                this.addConnectProperty(pair[0].trim(), pair[1].trim());
            }
        }
    }

    @Override
    public String getPoolImplementClassName() {
        return this.poolImplementClassName;
    }

    public void setPoolImplementClassName(String poolImplementClassName) {
        this.poolImplementClassName = PoolStaticCenter.trimString(poolImplementClassName);
    }

    @Override
    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public void setPrintConfigLog(boolean printConfigLog) {
        this.printConfigLog = printConfigLog;
    }

    public boolean isPrintRuntimeLog() {
        return this.printRuntimeLog;
    }

    public void setPrintRuntimeLog(boolean printRuntimeLog) {
        this.printRuntimeLog = printRuntimeLog;
    }

    void copyTo(BeeDataSourceConfig config) {
        String fieldName = "";
        try {
            for (Field field : BeeDataSourceConfig.class.getDeclaredFields()) {
                if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || "connectProperties".equals(field.getName())) continue;
                Object fieldValue = field.get(this);
                fieldName = field.getName();
                if (this.printConfigLog) {
                    PoolStaticCenter.CommonLog.info("{}.{}={}", new Object[]{this.poolName, fieldName, fieldValue});
                }
                field.set(config, fieldValue);
            }
        }
        catch (Exception e) {
            throw new BeeDataSourceConfigException("Failed to copy field[" + fieldName + "]", e);
        }
        for (Map.Entry<Object, Object> entry : this.connectProperties.entrySet()) {
            if (this.printConfigLog) {
                PoolStaticCenter.CommonLog.info("{}.connectProperties.{}={}", new Object[]{this.poolName, entry.getKey(), entry.getValue()});
            }
            config.addConnectProperty((String)entry.getKey(), entry.getValue());
        }
    }

    public BeeDataSourceConfig check() throws SQLException {
        if (this.maxActive <= 0) {
            throw new BeeDataSourceConfigException("maxActive must be greater than zero");
        }
        if (this.initialSize < 0) {
            throw new BeeDataSourceConfigException("initialSize must not be less than zero");
        }
        if (this.initialSize > this.maxActive) {
            throw new BeeDataSourceConfigException("initialSize must not be greater than maxActive");
        }
        if (this.borrowSemaphoreSize <= 0) {
            throw new BeeDataSourceConfigException("borrowSemaphoreSize must be greater than zero");
        }
        if (this.idleTimeout <= 0L) {
            throw new BeeDataSourceConfigException("idleTimeout must be greater than zero");
        }
        if (this.holdTimeout <= 0L) {
            throw new BeeDataSourceConfigException("holdTimeout must be greater than zero");
        }
        if (this.maxWait <= 0L) {
            throw new BeeDataSourceConfigException("maxWait must be greater than zero");
        }
        if (PoolStaticCenter.isBlank(this.validTestSql)) {
            throw new BeeDataSourceConfigException("validTestSql cant be null or empty");
        }
        if (!this.validTestSql.toUpperCase(Locale.US).startsWith("SELECT ")) {
            throw new BeeDataSourceConfigException("validTestSql must be start with 'select '");
        }
        if (PoolStaticCenter.isBlank(this.poolName)) {
            this.poolName = "FastPool-" + PoolNameIndex.getAndIncrement();
        }
        int transactionIsolationCode = this.getTransactionIsolationCode();
        this.setDefaultTransactionIsolationCode(transactionIsolationCode);
        RawConnectionFactory connectionFactory = this.tryCreateConnectionFactory();
        BeeDataSourceConfig configCopy = new BeeDataSourceConfig();
        this.copyTo(configCopy);
        configCopy.setConnectionFactory(connectionFactory);
        configCopy.setDefaultTransactionIsolationCode(transactionIsolationCode);
        return configCopy;
    }

    public void loadFromPropertiesFile(String filename) {
        if (PoolStaticCenter.isBlank(filename)) {
            throw new IllegalArgumentException("Properties file can't be null");
        }
        this.loadFromPropertiesFile(new File(filename));
    }

    public void loadFromPropertiesFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Properties file can't be null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File not found:" + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Target object is not a valid file");
        }
        if (!file.getAbsolutePath().toLowerCase(Locale.US).endsWith(".properties")) {
            throw new IllegalArgumentException("Target file is not a properties file");
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            Properties configProperties = new Properties();
            configProperties.load(stream);
            this.loadFromProperties(configProperties);
        }
        catch (BeeDataSourceConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to load properties file:", e);
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void loadFromProperties(Properties configProperties) {
        if (configProperties == null || configProperties.isEmpty()) {
            throw new IllegalArgumentException("Properties can't be null or empty");
        }
        Map<String, Method> setMethodMap = PoolStaticCenter.getSetMethodMap(BeeDataSourceConfig.class);
        HashMap<String, Object> setValueMap = new HashMap<String, Object>(setMethodMap.size());
        for (String propertyName : setMethodMap.keySet()) {
            String configVal = PoolStaticCenter.getConfigValue(configProperties, propertyName);
            if (PoolStaticCenter.isBlank(configVal)) continue;
            setValueMap.put(propertyName, configVal);
        }
        PoolStaticCenter.setPropertiesValue(this, setMethodMap, setValueMap);
        this.addConnectProperty(PoolStaticCenter.getConfigValue(configProperties, "connectProperties"));
        String connectPropertiesCount = PoolStaticCenter.getConfigValue(configProperties, "connectProperties.count");
        if (!PoolStaticCenter.isBlank(connectPropertiesCount)) {
            int count = 0;
            try {
                count = Integer.parseInt(connectPropertiesCount.trim());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (int i = 1; i <= count; ++i) {
                this.addConnectProperty(PoolStaticCenter.getConfigValue(configProperties, "connectProperties." + i));
            }
        }
    }

    private final int getTransactionIsolationCode() throws BeeDataSourceConfigException {
        if (!PoolStaticCenter.isBlank(this.defaultTransactionIsolationName)) {
            return TransactionIsolationLevel.getTransactionIsolationCode(this.defaultTransactionIsolationName);
        }
        if (this.defaultTransactionIsolationCode != -999 && !TransactionIsolationLevel.isValidTransactionIsolationCode(this.defaultTransactionIsolationCode)) {
            throw new BeeDataSourceConfigException("defaultTransactionIsolationCode error,valid value is one of[" + TransactionIsolationLevel.TRANS_LEVEL_CODE_LIST + "]");
        }
        return this.defaultTransactionIsolationCode;
    }

    private final RawConnectionFactory tryCreateConnectionFactory() throws BeeDataSourceConfigException, SQLException {
        if (this.connectionFactory != null) {
            return this.connectionFactory;
        }
        if (PoolStaticCenter.isBlank(this.connectionFactoryClassName)) {
            if (PoolStaticCenter.isBlank(this.jdbcUrl)) {
                throw new BeeDataSourceConfigException("jdbcUrl can't be null");
            }
            Driver connectDriver = null;
            if (!PoolStaticCenter.isBlank(this.driverClassName)) {
                connectDriver = PoolStaticCenter.loadJdbcDriver(this.driverClassName);
            } else if (!PoolStaticCenter.isBlank(this.jdbcUrl)) {
                connectDriver = DriverManager.getDriver(this.jdbcUrl);
            }
            if (connectDriver == null) {
                throw new BeeDataSourceConfigException("Failed to load jdbc Driver:" + this.driverClassName);
            }
            if (!connectDriver.acceptsURL(this.jdbcUrl)) {
                throw new BeeDataSourceConfigException("jdbcUrl(" + this.jdbcUrl + ")can not match driver:" + connectDriver.getClass().getName());
            }
            Properties connectProperties = new Properties();
            connectProperties.putAll((Map<?, ?>)this.connectProperties);
            if (!PoolStaticCenter.isBlank(this.username)) {
                connectProperties.put("user", this.username);
            }
            if (!PoolStaticCenter.isBlank(this.password)) {
                connectProperties.put("password", this.password);
            }
            return new DriverConnectionFactory(this.jdbcUrl, connectDriver, connectProperties);
        }
        try {
            Class<?> conFactClass = Class.forName(this.connectionFactoryClassName, true, BeeDataSourceConfig.class.getClassLoader());
            if (RawConnectionFactory.class.isAssignableFrom(conFactClass)) {
                return (RawConnectionFactory)conFactClass.newInstance();
            }
            if (DataSource.class.isAssignableFrom(conFactClass)) {
                DataSource dataSource = (DataSource)conFactClass.newInstance();
                Properties connectProperties = this.connectProperties;
                HashMap<String, Object> setValueMap = new HashMap<String, Object>(connectProperties.size());
                for (Map.Entry<Object, Object> entry : connectProperties.entrySet()) {
                    if (!(entry.getKey() instanceof String)) continue;
                    setValueMap.put((String)entry.getKey(), entry.getValue());
                }
                try {
                    PoolStaticCenter.setPropertiesValue(dataSource, setValueMap);
                }
                catch (Exception e) {
                    throw new BeeDataSourceConfigException("Failed to set config value to connection dataSource", e);
                }
                return new DataSourceConnectionFactory(dataSource, this.username, this.password);
            }
            throw new BeeDataSourceConfigException("Error connection factory class,must implement '" + RawConnectionFactory.class.getName() + "' interface");
        }
        catch (ClassNotFoundException e) {
            throw new BeeDataSourceConfigException("Not found connection factory class:" + this.connectionFactoryClassName);
        }
        catch (InstantiationException e) {
            throw new BeeDataSourceConfigException("Failed to instantiate connection factory class:" + this.connectionFactoryClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new BeeDataSourceConfigException("Failed to instantiate connection factory class:" + this.connectionFactoryClassName, e);
        }
    }
}

