/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp;

import cn.beecp.BeeDataSource;
import cn.beecp.BeeDataSourceConfig;
import cn.beecp.pool.PoolStaticCenter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public final class BeeDataSourceFactory
implements ObjectFactory {
    private static final String getConfigValue(Reference ref, String propertyName) {
        String value = BeeDataSourceFactory.readConfig(ref, propertyName);
        if (PoolStaticCenter.isBlank(value)) {
            value = BeeDataSourceFactory.readConfig(ref, PoolStaticCenter.propertyNameToFieldId(propertyName, "-"));
        }
        if (PoolStaticCenter.isBlank(value)) {
            value = BeeDataSourceFactory.readConfig(ref, PoolStaticCenter.propertyNameToFieldId(propertyName, "_"));
        }
        return value;
    }

    private static final String readConfig(Reference ref, String propertyName) {
        RefAddr refAddr = ref.get(propertyName);
        if (refAddr != null) {
            Object refObject = refAddr.getContent();
            if (refObject == null) {
                return null;
            }
            String value = refObject.toString().trim();
            if (!PoolStaticCenter.isBlank(value)) {
                PoolStaticCenter.CommonLog.info("beecp.{}={}", (Object)propertyName, (Object)value);
                return value;
            }
        }
        return null;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        BeeDataSourceConfig config = new BeeDataSourceConfig();
        Map<String, Method> setMethodMap = PoolStaticCenter.getSetMethodMap(config.getClass());
        HashMap<String, Object> setValueMap = new HashMap<String, Object>(setMethodMap.size());
        for (String propertyName : setMethodMap.keySet()) {
            String configVal = BeeDataSourceFactory.getConfigValue(ref, propertyName);
            if (PoolStaticCenter.isBlank(configVal)) continue;
            setValueMap.put(propertyName, configVal);
        }
        PoolStaticCenter.setPropertiesValue(config, setMethodMap, setValueMap);
        config.addConnectProperty(BeeDataSourceFactory.getConfigValue(ref, "connectProperties"));
        String connectPropertiesCount = BeeDataSourceFactory.getConfigValue(ref, "connectProperties.count");
        if (!PoolStaticCenter.isBlank(connectPropertiesCount)) {
            int count = 0;
            try {
                count = Integer.parseInt(connectPropertiesCount.trim());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (int i = 1; i <= count; ++i) {
                config.addConnectProperty(BeeDataSourceFactory.getConfigValue(ref, "connectProperties." + i));
            }
        }
        return new BeeDataSource(config);
    }
}

