/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.BeeDataSourceConfig;
import cn.beecp.RawConnectionFactory;
import cn.beecp.pool.Borrower;
import cn.beecp.pool.ConnectionPool;
import cn.beecp.pool.ConnectionPoolJmxBean;
import cn.beecp.pool.ConnectionPoolMonitorVo;
import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.PooledConnectionTransferPolicy;
import cn.beecp.pool.PooledConnectionValidTest;
import cn.beecp.pool.ProxyConnectionBase;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FastConnectionPool
extends Thread
implements ConnectionPool,
ConnectionPoolJmxBean,
PooledConnectionTransferPolicy,
PooledConnectionValidTest {
    private static final long spinForTimeoutThreshold = 1000L;
    private static final int maxTimedSpins = Runtime.getRuntime().availableProcessors() < 2 ? 0 : 32;
    private static final Logger Log = LoggerFactory.getLogger(FastConnectionPool.class);
    private static final AtomicIntegerFieldUpdater<PooledConnection> ConStUpd = AtomicIntegerFieldUpdater.newUpdater(PooledConnection.class, "state");
    private static final AtomicReferenceFieldUpdater<Borrower, Object> BorrowStUpd = AtomicReferenceFieldUpdater.newUpdater(Borrower.class, Object.class, "state");
    private final ConcurrentLinkedQueue<Borrower> waitQueue = new ConcurrentLinkedQueue();
    private final ThreadLocal<WeakReference<Borrower>> threadLocal = new ThreadLocal();
    private final ConnectionPoolMonitorVo monitorVo = new ConnectionPoolMonitorVo();
    private final AtomicInteger poolState = new AtomicInteger(1);
    private final AtomicInteger servantState = new AtomicInteger(1);
    private final AtomicInteger servantTryCount = new AtomicInteger(0);
    private final AtomicInteger idleScanState = new AtomicInteger(1);
    private final IdleTimeoutScanThread idleScanThread = new IdleTimeoutScanThread(this);
    private boolean printRuntimeLog;
    private String poolName;
    private String poolMode;
    private int poolMaxSize;
    private long maxWaitNs;
    private long idleTimeoutMs;
    private long holdTimeoutMs;
    private int unCatchStateCode;
    private long conValidAssumeTime;
    private int conValidTestTimeout;
    private long delayTimeForNextClearNs;
    private PooledConnectionValidTest conValidTest;
    private PooledConnectionTransferPolicy transferPolicy;
    private ConnectionPoolHook exitHook;
    private BeeDataSourceConfig poolConfig;
    private int semaphoreSize;
    private PoolSemaphore semaphore;
    private RawConnectionFactory conFactory;
    private volatile PooledConnection[] conArray = new PooledConnection[0];
    private ThreadPoolExecutor networkTimeoutExecutor;
    private boolean isFirstValidConnection = true;
    private PooledConnection clonePooledConn;

    @Override
    public void init(BeeDataSourceConfig config) throws SQLException {
        if (this.poolState.get() == 1) {
            this.checkProxyClasses();
            if (config == null) {
                throw new SQLException("Configuration can't be null");
            }
            this.poolConfig = config.check();
            this.poolName = this.poolConfig.getPoolName();
            Log.info("BeeCP({})starting....", (Object)this.poolName);
            this.poolMaxSize = this.poolConfig.getMaxActive();
            this.conFactory = this.poolConfig.getConnectionFactory();
            this.idleTimeoutMs = this.poolConfig.getIdleTimeout();
            this.holdTimeoutMs = this.poolConfig.getHoldTimeout();
            this.maxWaitNs = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getMaxWait());
            this.delayTimeForNextClearNs = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getDelayTimeForNextClear());
            this.conValidAssumeTime = this.poolConfig.getValidAssumeTime();
            this.conValidTestTimeout = this.poolConfig.getValidTestTimeout();
            if (this.poolConfig.isFairMode()) {
                this.poolMode = "fair";
                this.transferPolicy = new FairTransferPolicy();
            } else {
                this.poolMode = "compete";
                this.transferPolicy = this;
            }
        } else {
            throw new SQLException("Pool has initialized");
        }
        this.printRuntimeLog = this.poolConfig.isPrintRuntimeLog();
        this.unCatchStateCode = this.transferPolicy.getCheckStateCode();
        this.semaphoreSize = this.poolConfig.getBorrowSemaphoreSize();
        this.semaphore = new PoolSemaphore(this.semaphoreSize, this.poolConfig.isFairMode());
        this.networkTimeoutExecutor = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PoolThreadThreadFactory("networkTimeoutRestThread"));
        this.networkTimeoutExecutor.allowCoreThreadTimeOut(true);
        this.createInitConnections(this.poolConfig.getInitialSize());
        this.exitHook = new ConnectionPoolHook(this);
        Runtime.getRuntime().addShutdownHook(this.exitHook);
        this.registerJmx();
        Log.info("BeeCP({})has startup{mode:{},init size:{},max size:{},semaphore size:{},max wait:{}ms,driver:{}}", new Object[]{this.poolName, this.poolMode, this.conArray.length, config.getMaxActive(), this.semaphoreSize, this.poolConfig.getMaxWait(), this.poolConfig.getDriverClassName()});
        this.setDaemon(true);
        this.setName(this.poolName + "-workServant");
        this.setPriority(1);
        this.start();
        this.idleScanThread.setDaemon(true);
        this.idleScanThread.setName(this.poolName + "-idleCheck");
        this.idleScanThread.start();
        this.poolState.set(2);
    }

    private void checkProxyClasses() throws SQLException {
        try {
            String[] classNames;
            ClassLoader classLoader = this.getClass().getClassLoader();
            for (String className : classNames = new String[]{"cn.beecp.pool.Borrower", "cn.beecp.pool.PooledConnection", "cn.beecp.pool.ProxyConnection", "cn.beecp.pool.ProxyStatement", "cn.beecp.pool.ProxyPsStatement", "cn.beecp.pool.ProxyCsStatement", "cn.beecp.pool.ProxyDatabaseMetaData", "cn.beecp.pool.ProxyResultSet"}) {
                Class.forName(className, false, classLoader);
            }
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Jdbc proxy classes missed", e);
        }
    }

    private void createInitConnections(int initSize) throws SQLException {
        block4: {
            try {
                int size = initSize > 0 ? initSize : 1;
                for (int i = 0; i < size; ++i) {
                    this.createPooledConn(1);
                }
            }
            catch (Throwable e) {
                for (PooledConnection p : this.conArray) {
                    this.removePooledConn(p, "init");
                }
                if (initSize <= 0) break block4;
                throw e instanceof SQLException ? (SQLException)e : new SQLException(e);
            }
        }
    }

    private final synchronized PooledConnection createPooledConn(int state) throws SQLException {
        int l = this.conArray.length;
        if (l < this.poolMaxSize) {
            if (this.printRuntimeLog) {
                Log.info("BeeCP({}))begin to create a new pooled connection,state:{}", (Object)this.poolName, (Object)state);
            }
            Connection con = null;
            try {
                con = this.conFactory.create();
                if (this.isFirstValidConnection) {
                    this.testFirstConnection(con);
                }
                PooledConnection p = this.clonePooledConn.copy(con, state);
                if (this.printRuntimeLog) {
                    Log.info("BeeCP({}))has created a new pooled connection:{},state:{}", new Object[]{this.poolName, p, state});
                }
                PooledConnection[] arrayNew = new PooledConnection[l + 1];
                System.arraycopy(this.conArray, 0, arrayNew, 0, l);
                arrayNew[l] = p;
                this.conArray = arrayNew;
                return p;
            }
            catch (Throwable e) {
                if (con != null) {
                    PoolStaticCenter.oclose(con);
                }
                throw e instanceof SQLException ? (SQLException)e : new SQLException(e);
            }
        }
        return null;
    }

    private synchronized void removePooledConn(PooledConnection p, String removeType) {
        if (this.printRuntimeLog) {
            Log.info("BeeCP({}))begin to remove pooled connection:{},reason:{}", new Object[]{this.poolName, p, removeType});
        }
        p.onBeforeRemove();
        int l = this.conArray.length;
        PooledConnection[] arrayNew = new PooledConnection[l - 1];
        for (int i = 0; i < l; ++i) {
            if (this.conArray[i] != p) continue;
            System.arraycopy(this.conArray, 0, arrayNew, 0, i);
            int m = l - i - 1;
            if (m <= 0) break;
            System.arraycopy(this.conArray, i + 1, arrayNew, i, m);
            break;
        }
        if (this.printRuntimeLog) {
            Log.info("BeeCP({}))has removed pooled connection:{},reason:{}", new Object[]{this.poolName, p, removeType});
        }
        this.conArray = arrayNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFirstConnection(Connection rawCon) throws SQLException {
        boolean validTestFailed;
        block16: {
            boolean supportNetworkTimeout;
            int defaultNetworkTimeout;
            block15: {
                defaultNetworkTimeout = 0;
                supportNetworkTimeout = true;
                try {
                    defaultNetworkTimeout = rawCon.getNetworkTimeout();
                    if (defaultNetworkTimeout < 0) {
                        supportNetworkTimeout = false;
                        if (this.printRuntimeLog) {
                            Log.warn("BeeCP({})driver not support 'networkTimeout'", (Object)this.poolName);
                        }
                    } else {
                        rawCon.setNetworkTimeout(this.networkTimeoutExecutor, defaultNetworkTimeout);
                    }
                }
                catch (Throwable e) {
                    supportNetworkTimeout = false;
                    if (!this.printRuntimeLog) break block15;
                    Log.warn("BeeCP({})driver not support 'networkTimeout',cause:", (Object)this.poolName, (Object)e);
                }
            }
            int defaultTransactionIsolation = this.poolConfig.getDefaultTransactionIsolationCode();
            if (defaultTransactionIsolation == -999) {
                defaultTransactionIsolation = rawCon.getTransactionIsolation();
            }
            this.clonePooledConn = new PooledConnection(this, this.poolConfig.isDefaultAutoCommit(), this.poolConfig.isDefaultReadOnly(), this.poolConfig.getDefaultCatalog(), this.poolConfig.getDefaultSchema(), defaultTransactionIsolation, supportNetworkTimeout, defaultNetworkTimeout, this.networkTimeoutExecutor);
            this.isFirstValidConnection = false;
            try {
                if (rawCon.isValid(this.conValidTestTimeout)) {
                    this.conValidTest = this;
                    return;
                }
                validTestFailed = true;
                if (this.printRuntimeLog) {
                    Log.warn("BeeCP({})driver not support 'isValid'", (Object)this.poolName);
                }
            }
            catch (Throwable e) {
                validTestFailed = true;
                if (!this.printRuntimeLog) break block16;
                Log.warn("BeeCP({})driver not support 'isValid',cause:", (Object)this.poolName, (Object)e);
            }
        }
        if (validTestFailed) {
            Statement st = null;
            String conValidTestSql = this.poolConfig.getValidTestSql();
            boolean isDefaultAutoCommit = this.poolConfig.isDefaultAutoCommit();
            this.conValidTest = new PooledConnectionValidTestBySql(conValidTestSql, isDefaultAutoCommit);
            try {
                st = rawCon.createStatement();
                boolean supportQueryTimeout = this.testQueryTimeout(st, this.conValidTestTimeout);
                ((PooledConnectionValidTestBySql)this.conValidTest).setSupportQueryTimeout(supportQueryTimeout);
                PoolStaticCenter.validateTestSql(rawCon, st, conValidTestSql, isDefaultAutoCommit);
            }
            finally {
                if (st != null) {
                    PoolStaticCenter.oclose(st);
                }
            }
        }
    }

    private boolean testQueryTimeout(Statement st, int timeoutSeconds) {
        try {
            st.setQueryTimeout(timeoutSeconds);
            return true;
        }
        catch (Throwable e) {
            if (this.printRuntimeLog) {
                Log.warn("BeeCP({})driver not support 'queryTimeout',cause:", (Object)this.poolName, (Object)e);
            }
            return false;
        }
    }

    @Override
    public final Connection getConnection() throws SQLException {
        Borrower b;
        if (this.poolState.get() != 2) {
            throw PoolStaticCenter.PoolCloseException;
        }
        WeakReference<Borrower> r = this.threadLocal.get();
        Borrower borrower = b = r != null ? (Borrower)r.get() : null;
        if (b != null) {
            PooledConnection p = b.lastUsed;
            if (p != null && p.state == 1 && ConStUpd.compareAndSet(p, 1, 2)) {
                if (this.testOnBorrow(p)) {
                    return PoolStaticCenter.createProxyConnection(p, b);
                }
                b.lastUsed = null;
            }
        } else {
            b = new Borrower();
            this.threadLocal.set(new WeakReference<Borrower>(b));
        }
        long deadline = System.nanoTime();
        try {
            if (!this.semaphore.tryAcquire(this.maxWaitNs, TimeUnit.NANOSECONDS)) {
                throw PoolStaticCenter.RequestTimeoutException;
            }
        }
        catch (InterruptedException e) {
            throw PoolStaticCenter.RequestInterruptException;
        }
        try {
            int spinSize;
            PooledConnection p = this.searchOrCreate();
            if (p != null) {
                Connection connection = PoolStaticCenter.createProxyConnection(p, b);
                return connection;
            }
            boolean failed = false;
            SQLException cause = null;
            deadline += this.maxWaitNs;
            Thread bth = b.thread;
            b.state = PoolStaticCenter.BOWER_NORMAL;
            this.waitQueue.offer(b);
            int n = spinSize = this.waitQueue.peek() == b ? maxTimedSpins : 0;
            while (true) {
                Object s;
                if ((s = b.state) instanceof PooledConnection) {
                    p = (PooledConnection)s;
                    if (this.transferPolicy.tryCatch(p) && this.testOnBorrow(p)) {
                        this.waitQueue.remove(b);
                        Connection connection = PoolStaticCenter.createProxyConnection(p, b);
                        return connection;
                    }
                } else if (s instanceof Throwable) {
                    this.waitQueue.remove(b);
                    throw s instanceof SQLException ? (SQLException)s : new SQLException((Throwable)s);
                }
                if (failed) {
                    BorrowStUpd.compareAndSet(b, s, cause);
                    continue;
                }
                if (s instanceof PooledConnection) {
                    b.state = PoolStaticCenter.BOWER_NORMAL;
                    Thread.yield();
                    continue;
                }
                long t = deadline - System.nanoTime();
                if (t > 1000L) {
                    if (spinSize > 0) {
                        --spinSize;
                        continue;
                    }
                    if (!BorrowStUpd.compareAndSet(b, PoolStaticCenter.BOWER_NORMAL, PoolStaticCenter.BOWER_WAITING)) continue;
                    if (this.servantTryCount.get() > 0 && this.servantState.get() == 2 && this.servantState.compareAndSet(2, 1)) {
                        LockSupport.unpark(this);
                    }
                    LockSupport.parkNanos(t);
                    if (bth.isInterrupted()) {
                        failed = true;
                        cause = PoolStaticCenter.RequestInterruptException;
                    }
                    if (b.state != PoolStaticCenter.BOWER_WAITING) continue;
                    BorrowStUpd.compareAndSet(b, PoolStaticCenter.BOWER_WAITING, failed ? cause : PoolStaticCenter.BOWER_NORMAL);
                    continue;
                }
                if (t > 0L) continue;
                failed = true;
                cause = PoolStaticCenter.RequestTimeoutException;
            }
        }
        finally {
            this.semaphore.release();
        }
    }

    private final PooledConnection searchOrCreate() throws SQLException {
        for (PooledConnection p : this.conArray) {
            if (p.state != 1 || !ConStUpd.compareAndSet(p, 1, 2) || !this.testOnBorrow(p)) continue;
            return p;
        }
        if (this.conArray.length < this.poolMaxSize) {
            return this.createPooledConn(2);
        }
        return null;
    }

    private final void tryWakeupServantThread() {
        int c;
        do {
            if ((c = this.servantTryCount.get()) < this.poolMaxSize) continue;
            return;
        } while (!this.servantTryCount.compareAndSet(c, c + 1));
        if (!this.waitQueue.isEmpty() && this.servantState.get() == 2 && this.servantState.compareAndSet(2, 1)) {
            LockSupport.unpark(this);
        }
    }

    @Override
    public final void recycle(PooledConnection p) {
        Iterator<Borrower> iterator = this.waitQueue.iterator();
        this.transferPolicy.beforeTransfer(p);
        block0: while (iterator.hasNext()) {
            Object state;
            Borrower b = iterator.next();
            do {
                if (p.state != this.unCatchStateCode) {
                    return;
                }
                state = b.state;
                if (!(state instanceof PoolStaticCenter.BorrowerState)) continue block0;
            } while (!BorrowStUpd.compareAndSet(b, state, p));
            if (state == PoolStaticCenter.BOWER_WAITING) {
                LockSupport.unpark(b.thread);
            }
            return;
        }
        this.transferPolicy.onTransferFail(p);
        this.tryWakeupServantThread();
    }

    private void transferException(Throwable e) {
        for (Borrower b : this.waitQueue) {
            Object state;
            while ((state = b.state) instanceof PoolStaticCenter.BorrowerState) {
                if (!BorrowStUpd.compareAndSet(b, state, e)) continue;
                if (state == PoolStaticCenter.BOWER_WAITING) {
                    LockSupport.unpark(b.thread);
                }
                return;
            }
        }
    }

    final void abandonOnReturn(PooledConnection p) {
        this.removePooledConn(p, "bad");
        this.tryWakeupServantThread();
    }

    private final boolean testOnBorrow(PooledConnection p) {
        if (System.currentTimeMillis() - p.lastAccessTime > this.conValidAssumeTime && !this.conValidTest.isValid(p)) {
            this.removePooledConn(p, "bad");
            this.tryWakeupServantThread();
            return false;
        }
        return true;
    }

    private final boolean existBorrower() {
        return this.semaphoreSize > this.semaphore.availablePermits();
    }

    private void shutdownPoolThread() {
        int curState = this.servantState.get();
        this.servantState.set(3);
        if (curState == 2) {
            LockSupport.unpark(this);
        }
        curState = this.idleScanState.get();
        this.idleScanState.set(3);
        if (curState == 2) {
            LockSupport.unpark(this.idleScanThread);
        }
    }

    @Override
    public void run() {
        while (this.poolState.get() != 3) {
            while (this.servantState.get() == 1 && this.servantTryCount.get() > 0) {
                try {
                    this.servantTryCount.decrementAndGet();
                    PooledConnection p = this.searchOrCreate();
                    if (p == null) continue;
                    this.recycle(p);
                }
                catch (Throwable e) {
                    this.transferException(e);
                }
            }
            this.servantTryCount.set(0);
            if (this.servantState.get() == 3) break;
            if (!this.servantState.compareAndSet(1, 2)) continue;
            LockSupport.park();
        }
    }

    private void closeIdleTimeoutConnection() {
        if (this.poolState.get() == 2) {
            for (PooledConnection p : this.conArray) {
                int state = p.state;
                if (state == 1 && !this.existBorrower()) {
                    boolean isTimeoutInIdle;
                    boolean bl = isTimeoutInIdle = System.currentTimeMillis() - p.lastAccessTime >= this.idleTimeoutMs;
                    if (!isTimeoutInIdle || !ConStUpd.compareAndSet(p, state, 3)) continue;
                    this.removePooledConn(p, "idle");
                    this.tryWakeupServantThread();
                    continue;
                }
                if (state == 2) {
                    if (System.currentTimeMillis() - p.lastAccessTime < this.holdTimeoutMs) continue;
                    ProxyConnectionBase proxyConn = p.proxyCon;
                    if (proxyConn != null) {
                        PoolStaticCenter.oclose(proxyConn);
                        continue;
                    }
                    this.removePooledConn(p, "bad");
                    this.tryWakeupServantThread();
                    continue;
                }
                if (state != 3) continue;
                this.removePooledConn(p, "closed");
                this.tryWakeupServantThread();
            }
            ConnectionPoolMonitorVo vo = this.getMonitorVo();
            if (this.printRuntimeLog) {
                Log.info("BeeCP({})-{idle:{},using:{},semaphore-waiter:{},wait-transfer:{}}", new Object[]{this.poolName, vo.getIdleSize(), vo.getUsingSize(), vo.getSemaphoreWaiterSize(), vo.getTransferWaiterSize()});
            }
        }
    }

    @Override
    public void clearAllConnections() {
        this.clearAllConnections(false);
    }

    @Override
    public void clearAllConnections(boolean force) {
        if (this.poolState.compareAndSet(2, 4)) {
            Log.info("BeeCP({})begin to remove connections", (Object)this.poolName);
            this.removeAllConnections(force, "clear");
            this.poolState.set(2);
            Log.info("BeeCP({})all connections were removed and restored to accept new requests", (Object)this.poolName);
        }
    }

    private void removeAllConnections(boolean force, String source) {
        this.semaphore.interruptWaitingThreads();
        while (!this.waitQueue.isEmpty()) {
            this.transferException(PoolStaticCenter.PoolCloseException);
        }
        while (this.conArray.length > 0) {
            for (PooledConnection p : this.conArray) {
                if (ConStUpd.compareAndSet(p, 1, 3)) {
                    this.removePooledConn(p, source);
                    continue;
                }
                if (p.state == 3) {
                    this.removePooledConn(p, source);
                    continue;
                }
                if (p.state != 2) continue;
                ProxyConnectionBase proxyConn = p.proxyCon;
                if (proxyConn != null) {
                    if (!force && System.currentTimeMillis() - p.lastAccessTime < this.holdTimeoutMs) continue;
                    PoolStaticCenter.oclose(proxyConn);
                    continue;
                }
                this.removePooledConn(p, source);
            }
            if (this.conArray.length <= 0) continue;
            LockSupport.parkNanos(this.delayTimeForNextClearNs);
        }
    }

    @Override
    public boolean isClosed() {
        return this.poolState.get() == 3;
    }

    @Override
    public void close() throws SQLException {
        while (true) {
            int poolStateCode;
            if (((poolStateCode = this.poolState.get()) == 1 || poolStateCode == 2) && this.poolState.compareAndSet(poolStateCode, 3)) {
                Log.info("BeeCP({})begin to shutdown", (Object)this.poolName);
                this.shutdownPoolThread();
                this.unregisterJmx();
                this.removeAllConnections(this.poolConfig.isForceCloseUsingOnClear(), "destroy");
                this.networkTimeoutExecutor.getQueue().clear();
                this.networkTimeoutExecutor.shutdownNow();
                try {
                    Runtime.getRuntime().removeShutdownHook(this.exitHook);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Log.info("BeeCP({})has shutdown", (Object)this.poolName);
                break;
            }
            if (this.poolState.get() == 3) break;
            LockSupport.parkNanos(this.delayTimeForNextClearNs);
        }
    }

    @Override
    public ConnectionPoolMonitorVo getMonitorVo() {
        int totSize = this.getConnTotalSize();
        int idleSize = this.getConnIdleSize();
        this.monitorVo.setPoolName(this.poolName);
        this.monitorVo.setPoolMode(this.poolMode);
        this.monitorVo.setPoolState(this.poolState.get());
        this.monitorVo.setMaxActive(this.poolMaxSize);
        this.monitorVo.setIdleSize(idleSize);
        this.monitorVo.setUsingSize(totSize - idleSize);
        this.monitorVo.setSemaphoreWaiterSize(this.getSemaphoreWaitingSize());
        this.monitorVo.setTransferWaiterSize(this.getTransferWaitingSize());
        return this.monitorVo;
    }

    @Override
    public int getConnTotalSize() {
        return this.conArray.length;
    }

    @Override
    public int getConnIdleSize() {
        int idleSize = 0;
        PooledConnection[] array = this.conArray;
        int l = array.length;
        for (int i = 0; i < l; ++i) {
            if (array[i].state != 1) continue;
            ++idleSize;
        }
        return idleSize;
    }

    @Override
    public int getConnUsingSize() {
        int active = this.conArray.length - this.getConnIdleSize();
        return active > 0 ? active : 0;
    }

    @Override
    public int getSemaphoreWaitingSize() {
        return this.semaphore.getQueueLength();
    }

    @Override
    public int getSemaphoreAcquiredSize() {
        return this.poolConfig.getBorrowSemaphoreSize() - this.semaphore.availablePermits();
    }

    @Override
    public void setPrintRuntimeLog(boolean indicator) {
        this.printRuntimeLog = indicator;
    }

    @Override
    public int getTransferWaitingSize() {
        int size = 0;
        for (Borrower borrower : this.waitQueue) {
            if (!(borrower.state instanceof PoolStaticCenter.BorrowerState)) continue;
            ++size;
        }
        return size;
    }

    private void registerJmx() {
        if (this.poolConfig.isEnableJmx()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.registerJmxBean(mBeanServer, String.format("cn.beecp.pool.FastConnectionPool:type=BeeCP(%s)", this.poolName), this);
            this.registerJmxBean(mBeanServer, String.format("cn.beecp.BeeDataSourceConfig:type=BeeCP(%s)-config", this.poolName), this.poolConfig);
        }
    }

    private void registerJmxBean(MBeanServer mBeanServer, String regName, Object bean) {
        try {
            ObjectName jmxRegName = new ObjectName(regName);
            if (!mBeanServer.isRegistered(jmxRegName)) {
                mBeanServer.registerMBean(bean, jmxRegName);
            }
        }
        catch (Exception e) {
            Log.warn("BeeCP({})failed to register jmx-bean:{}", new Object[]{this.poolName, regName, e});
        }
    }

    private void unregisterJmx() {
        if (this.poolConfig.isEnableJmx()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.unregisterJmxBean(mBeanServer, String.format("cn.beecp.pool.FastConnectionPool:type=BeeCP(%s)", this.poolName));
            this.unregisterJmxBean(mBeanServer, String.format("cn.beecp.BeeDataSourceConfig:type=BeeCP(%s)-config", this.poolName));
        }
    }

    private void unregisterJmxBean(MBeanServer mBeanServer, String regName) {
        try {
            ObjectName jmxRegName = new ObjectName(regName);
            if (mBeanServer.isRegistered(jmxRegName)) {
                mBeanServer.unregisterMBean(jmxRegName);
            }
        }
        catch (Exception e) {
            Log.warn("BeeCP({})failed to unregister jmx-bean:{}", new Object[]{this.poolName, regName, e});
        }
    }

    @Override
    public final int getCheckStateCode() {
        return 1;
    }

    @Override
    public final void beforeTransfer(PooledConnection p) {
        p.state = 1;
    }

    @Override
    public final boolean tryCatch(PooledConnection p) {
        return ConStUpd.compareAndSet(p, 1, 2);
    }

    @Override
    public final void onTransferFail(PooledConnection p) {
    }

    @Override
    public final boolean isValid(PooledConnection p) {
        block3: {
            try {
                if (p.raw.isValid(this.conValidTestTimeout)) {
                    p.lastAccessTime = System.currentTimeMillis();
                    return true;
                }
            }
            catch (Throwable e) {
                if (!this.printRuntimeLog) break block3;
                Log.warn("BeeCP({})failed to test connection with 'isValid' method", (Object)this.poolName, (Object)e);
            }
        }
        return false;
    }

    private final class PooledConnectionValidTestBySql
    implements PooledConnectionValidTest {
        private final String testSql;
        private final boolean autoCommit;
        private boolean supportQueryTimeout = true;

        public PooledConnectionValidTestBySql(String testSql, boolean autoCommit) {
            this.testSql = testSql;
            this.autoCommit = autoCommit;
        }

        public void setSupportQueryTimeout(boolean supportQueryTimeout) {
            this.supportQueryTimeout = supportQueryTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean isValid(PooledConnection p) {
            Statement st = null;
            boolean changed = false;
            Connection con = p.raw;
            try {
                block19: {
                    st = con.createStatement();
                    if (this.supportQueryTimeout) {
                        try {
                            st.setQueryTimeout(FastConnectionPool.this.conValidTestTimeout);
                        }
                        catch (Throwable e) {
                            if (!FastConnectionPool.this.printRuntimeLog) break block19;
                            Log.warn("BeeCP({})failed to setQueryTimeout", (Object)FastConnectionPool.this.poolName, (Object)e);
                        }
                    }
                }
                if (this.autoCommit) {
                    con.setAutoCommit(false);
                    changed = true;
                }
                st.execute(this.testSql);
                p.lastAccessTime = System.currentTimeMillis();
                boolean e = true;
                return e;
            }
            catch (Throwable e) {
                if (FastConnectionPool.this.printRuntimeLog) {
                    Log.warn("BeeCP({})failed to test connection by sql", (Object)FastConnectionPool.this.poolName, (Object)e);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (st != null) {
                    PoolStaticCenter.oclose(st);
                }
                try {
                    con.rollback();
                    if (changed) {
                        con.setAutoCommit(this.autoCommit);
                    }
                }
                catch (Throwable e) {
                    if (FastConnectionPool.this.printRuntimeLog) {
                        Log.warn("BeeCP({})failed to rest connection after sql test", (Object)FastConnectionPool.this.poolName, (Object)e);
                    }
                    return false;
                }
            }
        }
    }

    private static final class FairTransferPolicy
    implements PooledConnectionTransferPolicy {
        private FairTransferPolicy() {
        }

        @Override
        public final int getCheckStateCode() {
            return 2;
        }

        @Override
        public final void beforeTransfer(PooledConnection p) {
        }

        @Override
        public final boolean tryCatch(PooledConnection p) {
            return p.state == 2;
        }

        @Override
        public final void onTransferFail(PooledConnection p) {
            p.state = 1;
        }
    }

    private static class ConnectionPoolHook
    extends Thread {
        private FastConnectionPool pool;

        public ConnectionPoolHook(FastConnectionPool pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            try {
                Log.info("BeeCP({})ConnectionPoolHook Running", (Object)this.pool.poolName);
                this.pool.close();
            }
            catch (Throwable e) {
                Log.error("BeeCP({})Error at closing connection pool,cause:", (Object)this.pool.poolName, (Object)e);
            }
        }
    }

    private static final class IdleTimeoutScanThread
    extends Thread {
        private FastConnectionPool pool;

        public IdleTimeoutScanThread(FastConnectionPool pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            long checkTimeIntervalNanos = TimeUnit.MILLISECONDS.toNanos(this.pool.poolConfig.getTimerCheckInterval());
            AtomicInteger idleScanThreadState = this.pool.idleScanState;
            while (idleScanThreadState.get() == 1) {
                LockSupport.parkNanos(checkTimeIntervalNanos);
                try {
                    this.pool.closeIdleTimeoutConnection();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static final class PoolSemaphore
    extends Semaphore {
        public PoolSemaphore(int permits, boolean fair) {
            super(permits, fair);
        }

        public void interruptWaitingThreads() {
            for (Thread thread : super.getQueuedThreads()) {
                Thread.State state = thread.getState();
                if (state != Thread.State.WAITING && state != Thread.State.TIMED_WAITING) continue;
                thread.interrupt();
            }
        }
    }

    private static final class PoolThreadThreadFactory
    implements ThreadFactory {
        private String thName;

        public PoolThreadThreadFactory(String thName) {
            this.thName = thName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread th = new Thread(r, this.thName);
            th.setDaemon(true);
            return th;
        }
    }
}

