/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.BeeDataSourceConfig;
import cn.beecp.BeeDataSourceConfigException;
import cn.beecp.pool.Borrower;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyConnection;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.ProxyResultSet;
import cn.beecp.pool.ProxyStatementBase;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.transaction.xa.XAException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolStaticCenter {
    public static final int CON_IDLE = 1;
    public static final int CON_USING = 2;
    public static final int CON_CLOSED = 3;
    public static final int POOL_UNINIT = 1;
    public static final int POOL_NORMAL = 2;
    public static final int POOL_CLOSED = 3;
    public static final int POOL_CLEARING = 4;
    public static final int THREAD_WORKING = 1;
    public static final int THREAD_WAITING = 2;
    public static final int THREAD_EXIT = 3;
    public static final String DESC_RM_INIT = "init";
    public static final String DESC_RM_BAD = "bad";
    public static final String DESC_RM_IDLE = "idle";
    public static final String DESC_RM_CLOSED = "closed";
    public static final String DESC_RM_CLEAR = "clear";
    public static final String DESC_RM_DESTROY = "destroy";
    public static final BorrowerState BOWER_NORMAL = new BorrowerState();
    public static final BorrowerState BOWER_WAITING = new BorrowerState();
    public static final String DS_Config_Prop_Separator_MiddleLine = "-";
    public static final String DS_Config_Prop_Separator_UnderLine = "_";
    public static final XAException XaConnectionClosedException = new XAException("No operations allowed after connection closed");
    public static final SQLTimeoutException RequestTimeoutException = new SQLTimeoutException("Request timeout");
    public static final SQLException RequestInterruptException = new SQLException("Request interrupted");
    public static final SQLException PoolCloseException = new SQLException("Pool has shut down or in clearing");
    public static final SQLException ConnectionClosedException = new SQLException("No operations allowed after connection closed");
    public static final SQLException StatementClosedException = new SQLException("No operations allowed after statement closed");
    public static final SQLException ResultSetClosedException = new SQLException("No operations allowed after resultSet closed");
    public static final SQLException AutoCommitChangeForbiddenException = new SQLException("Execute 'commit' or 'rollback' before this operation");
    public static final SQLException DriverNotSupportNetworkTimeoutException = new SQLException("Driver not support 'networkTimeout'");
    public static final Logger CommonLog = LoggerFactory.getLogger(PoolStaticCenter.class);
    public static final Connection CLOSED_CON = (Connection)Proxy.newProxyInstance(PoolStaticCenter.class.getClassLoader(), new Class[]{Connection.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("isClosed".equals(method.getName())) {
                return Boolean.TRUE;
            }
            throw ConnectionClosedException;
        }
    });
    public static final CallableStatement CLOSED_CSTM = (CallableStatement)Proxy.newProxyInstance(PoolStaticCenter.class.getClassLoader(), new Class[]{CallableStatement.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("isClosed".equals(method.getName())) {
                return Boolean.TRUE;
            }
            throw StatementClosedException;
        }
    });
    public static final ResultSet CLOSED_RSLT = (ResultSet)Proxy.newProxyInstance(PoolStaticCenter.class.getClassLoader(), new Class[]{ResultSet.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("isClosed".equals(method.getName())) {
                return Boolean.TRUE;
            }
            throw ResultSetClosedException;
        }
    });

    public static final void oclose(ResultSet r) {
        try {
            r.close();
        }
        catch (Throwable e) {
            CommonLog.debug("Warning:Error at closing resultSet:", e);
        }
    }

    public static final void oclose(Statement s) {
        try {
            s.close();
        }
        catch (Throwable e) {
            CommonLog.debug("Warning:Error at closing statement:", e);
        }
    }

    public static final void oclose(Connection c) {
        try {
            c.close();
        }
        catch (Throwable e) {
            CommonLog.debug("Warning:Error at closing connection:", e);
        }
    }

    public static final Connection createProxyConnection(PooledConnection pooledConnection, Borrower borrower) throws SQLException {
        borrower.lastUsed = pooledConnection;
        return new ProxyConnection(pooledConnection);
    }

    public static final ResultSet createProxyResultSet(ResultSet resultSet, ProxyStatementBase proxyStatementBase, PooledConnection pooledConnection) throws SQLException {
        return new ProxyResultSet(resultSet, proxyStatementBase, pooledConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final void validateTestSql(Connection rawCon, Statement st, String testSql, boolean isDefaultAutoCommit) throws SQLException {
        boolean changed = false;
        try {
            if (isDefaultAutoCommit) {
                rawCon.setAutoCommit(false);
                changed = true;
            }
            st.execute(testSql);
        }
        catch (Throwable throwable) {
            try {
                rawCon.rollback();
                if (!changed) throw throwable;
                rawCon.setAutoCommit(isDefaultAutoCommit);
                throw throwable;
            }
            catch (Throwable e) {
                throw e instanceof SQLException ? (SQLException)e : new SQLException(e);
            }
        }
        try {
            rawCon.rollback();
            if (!changed) return;
            rawCon.setAutoCommit(isDefaultAutoCommit);
            return;
        }
        catch (Throwable e) {
            throw e instanceof SQLException ? (SQLException)e : new SQLException(e);
        }
    }

    public static final String trimString(String value) {
        return value == null ? null : value.trim();
    }

    public static final boolean equals(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    public static final boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int l = str.length();
        for (int i = 0; i < l; ++i) {
            if (Character.isWhitespace((int)str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final String getConfigValue(Properties configProperties, String propertyName) {
        String value = PoolStaticCenter.readConfig(configProperties, propertyName);
        if (PoolStaticCenter.isBlank(value)) {
            value = PoolStaticCenter.readConfig(configProperties, PoolStaticCenter.propertyNameToFieldId(propertyName, DS_Config_Prop_Separator_MiddleLine));
        }
        if (PoolStaticCenter.isBlank(value)) {
            value = PoolStaticCenter.readConfig(configProperties, PoolStaticCenter.propertyNameToFieldId(propertyName, DS_Config_Prop_Separator_UnderLine));
        }
        return value;
    }

    public static final String readConfig(Properties configProperties, String propertyName) {
        String value = configProperties.getProperty(propertyName);
        if (!PoolStaticCenter.isBlank(value)) {
            CommonLog.info("beecp.{}={}", (Object)propertyName, (Object)value);
            return value.trim();
        }
        return null;
    }

    public static final Driver loadJdbcDriver(String driverClassName) throws BeeDataSourceConfigException {
        try {
            Class<?> driverClass = Class.forName(driverClassName, true, BeeDataSourceConfig.class.getClassLoader());
            return (Driver)driverClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new BeeDataSourceConfigException("Not found driver class:" + driverClassName);
        }
        catch (InstantiationException e) {
            throw new BeeDataSourceConfigException("Failed to instantiate driver class:" + driverClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new BeeDataSourceConfigException("Failed to instantiate driver class:" + driverClassName, e);
        }
    }

    public static final void setPropertiesValue(Object bean, Map<String, Object> setValueMap) throws Exception {
        if (bean == null) {
            throw new BeeDataSourceConfigException("Bean can't be null");
        }
        PoolStaticCenter.setPropertiesValue(bean, PoolStaticCenter.getSetMethodMap(bean.getClass()), setValueMap);
    }

    public static final void setPropertiesValue(Object bean, Map<String, Method> setMethodMap, Map<String, Object> setValueMap) {
        if (bean == null) {
            throw new BeeDataSourceConfigException("Bean can't be null");
        }
        if (setMethodMap == null) {
            throw new BeeDataSourceConfigException("Set method map can't be null");
        }
        if (setMethodMap.isEmpty()) {
            throw new BeeDataSourceConfigException("Set method map can't be empty");
        }
        if (setValueMap == null) {
            throw new BeeDataSourceConfigException("Properties value map can't be null");
        }
        if (setValueMap.isEmpty()) {
            throw new BeeDataSourceConfigException("Properties value map can't be empty");
        }
        for (Map.Entry<String, Object> entry : setValueMap.entrySet()) {
            Object value;
            String propertyName = entry.getKey();
            Object setValue = entry.getValue();
            Method setMethod = setMethodMap.get(propertyName);
            if (setMethod == null || setValue == null) continue;
            Class<?> type = setMethod.getParameterTypes()[0];
            try {
                value = PoolStaticCenter.convert(propertyName, setValue, type);
            }
            catch (BeeDataSourceConfigException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BeeDataSourceConfigException("Failed to convert config value to property(" + propertyName + ")type:" + type.getName(), e);
            }
            try {
                setMethod.invoke(bean, value);
            }
            catch (IllegalAccessException e) {
                throw new BeeDataSourceConfigException("Failed to inject config value to property:" + propertyName, e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause != null) {
                    throw new BeeDataSourceConfigException("Failed to inject config value to property:" + propertyName, cause);
                }
                throw new BeeDataSourceConfigException("Failed to inject config value to property:" + propertyName, e);
            }
        }
    }

    public static final Map<String, Method> getSetMethodMap(Class beanClass) {
        Method[] methods;
        LinkedHashMap<String, Method> methodMap = new LinkedHashMap<String, Method>(32);
        for (Method method : methods = beanClass.getMethods()) {
            String methodName = method.getName();
            if (method.getParameterTypes().length != 1 || !methodName.startsWith("set") || methodName.length() <= 3) continue;
            methodName = methodName.substring(3);
            methodName = methodName.substring(0, 1).toLowerCase(Locale.US) + methodName.substring(1);
            methodMap.put(methodName, method);
        }
        return methodMap;
    }

    public static final String propertyNameToFieldId(String property, String separator) {
        char[] chars = property.toCharArray();
        StringBuilder sb = new StringBuilder(chars.length);
        for (char c : chars) {
            if (Character.isUpperCase(c)) {
                sb.append(separator).append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static final Object convert(String propName, Object setValue, Class type) throws BeeDataSourceConfigException {
        if (type.isInstance(setValue)) {
            return setValue;
        }
        if (type == String.class) {
            return setValue.toString();
        }
        String text = setValue.toString();
        if ((text = text.trim()).length() == 0) {
            return null;
        }
        if (type == Character.TYPE || type == Character.class) {
            return Character.valueOf(text.toCharArray()[0]);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.parseBoolean(text);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return Byte.parseByte(text);
        }
        if (type == Short.TYPE || type == Short.class) {
            return Short.parseShort(text);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.parseInt(text);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.parseLong(text);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(Float.parseFloat(text));
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.parseDouble(text);
        }
        if (type == BigInteger.class) {
            return new BigInteger(text);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(text);
        }
        try {
            Object objInstance = Class.forName(text).newInstance();
            if (!type.isInstance(objInstance)) {
                throw new BeeDataSourceConfigException("Config value can't mach property(" + propName + ")type:" + type.getName());
            }
            return objInstance;
        }
        catch (ClassNotFoundException e) {
            throw new BeeDataSourceConfigException("Not found class:" + text);
        }
        catch (InstantiationException e) {
            throw new BeeDataSourceConfigException("Failed to instantiated class:" + text, e);
        }
        catch (IllegalAccessException e) {
            throw new BeeDataSourceConfigException("Failed to instantiated class:" + text, e);
        }
    }

    static final class ProxyConnectionCloseTask
    implements Runnable {
        private ProxyConnectionBase proxyCon;

        public ProxyConnectionCloseTask(ProxyConnectionBase proxyCon) {
            this.proxyCon = proxyCon;
        }

        @Override
        public void run() {
            try {
                this.proxyCon.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static final class BorrowerState {
        BorrowerState() {
        }
    }
}

