/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.FastConnectionPool;
import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.ProxyStatementBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ThreadPoolExecutor;

final class PooledConnection
implements Cloneable {
    private static final boolean[] FALSE = new boolean[6];
    public final boolean defAutoCommit;
    public final boolean defReadOnly;
    public final String defCatalog;
    public final String defSchema;
    public final int defTransactionIsolation;
    public final int defNetworkTimeout;
    private final FastConnectionPool pool;
    private final boolean defCatalogSetInd;
    private final boolean defSchemaSetInd;
    private final boolean supportNetworkTimeout;
    private final ThreadPoolExecutor networkTimeoutExecutor;
    public boolean curAutoCommit;
    public boolean commitDirtyInd;
    public ProxyConnectionBase proxyCon;
    public Connection raw;
    public volatile int state;
    public volatile long lastAccessTime;
    public int openStmSize;
    private int resetCnt;
    private boolean[] resetInd;
    private ProxyStatementBase[] openStatements;

    public PooledConnection(FastConnectionPool pool, boolean defAutoCommit, boolean defReadOnly, String defCatalog, String defSchema, int defTransactionIsolation, boolean supportNetworkTimeout, int defNetworkTimeout, ThreadPoolExecutor networkTimeoutExecutor) {
        this.pool = pool;
        this.defAutoCommit = defAutoCommit;
        this.defReadOnly = defReadOnly;
        this.defCatalog = defCatalog;
        this.defSchema = defSchema;
        this.defTransactionIsolation = defTransactionIsolation;
        this.defNetworkTimeout = defNetworkTimeout;
        this.supportNetworkTimeout = supportNetworkTimeout;
        this.networkTimeoutExecutor = networkTimeoutExecutor;
        this.defCatalogSetInd = !PoolStaticCenter.isBlank(defCatalog);
        this.defSchemaSetInd = !PoolStaticCenter.isBlank(defSchema);
        this.curAutoCommit = defAutoCommit;
    }

    public final PooledConnection copy(Connection raw, int state) throws CloneNotSupportedException, SQLException {
        raw.setAutoCommit(this.defAutoCommit);
        raw.setTransactionIsolation(this.defTransactionIsolation);
        raw.setReadOnly(this.defReadOnly);
        if (this.defCatalogSetInd) {
            raw.setCatalog(this.defCatalog);
        }
        if (this.defSchemaSetInd) {
            raw.setSchema(this.defSchema);
        }
        PooledConnection p = (PooledConnection)this.clone();
        p.raw = raw;
        p.state = state;
        p.resetInd = new boolean[6];
        p.openStatements = new ProxyStatementBase[16];
        p.lastAccessTime = System.currentTimeMillis();
        return p;
    }

    public boolean supportNetworkTimeout() {
        return this.supportNetworkTimeout;
    }

    public final void updateAccessTime() {
        this.commitDirtyInd = !this.curAutoCommit;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public final void onBeforeRemove() {
        try {
            this.state = 3;
            this.resetRawConn();
        }
        catch (Throwable e) {
            PoolStaticCenter.CommonLog.error("Connection close error", e);
        }
        finally {
            PoolStaticCenter.oclose(this.raw);
        }
    }

    public final void recycleSelf() throws SQLException {
        try {
            this.proxyCon = null;
            this.resetRawConn();
            this.pool.recycle(this);
        }
        catch (Throwable e) {
            this.pool.abandonOnReturn(this);
            throw e instanceof SQLException ? (SQLException)e : new SQLException(e);
        }
    }

    public final void setResetInd(int p, boolean c) {
        if (!this.resetInd[p] && c) {
            ++this.resetCnt;
        } else if (this.resetInd[p] && !c) {
            --this.resetCnt;
        }
        this.resetInd[p] = c;
    }

    private final void resetRawConn() throws SQLException {
        if (this.commitDirtyInd) {
            this.raw.rollback();
            this.commitDirtyInd = false;
        }
        if (this.resetCnt > 0) {
            if (this.resetInd[0]) {
                this.raw.setAutoCommit(this.defAutoCommit);
                this.curAutoCommit = this.defAutoCommit;
            }
            if (this.resetInd[1]) {
                this.raw.setTransactionIsolation(this.defTransactionIsolation);
            }
            if (this.resetInd[2]) {
                this.raw.setReadOnly(this.defReadOnly);
            }
            if (this.resetInd[3]) {
                this.raw.setCatalog(this.defCatalog);
            }
            if (this.resetInd[4]) {
                this.raw.setSchema(this.defSchema);
            }
            if (this.resetInd[5]) {
                this.raw.setNetworkTimeout(this.networkTimeoutExecutor, this.defNetworkTimeout);
            }
            this.resetCnt = 0;
            System.arraycopy(FALSE, 0, this.resetInd, 0, 6);
        }
        this.raw.clearWarnings();
    }

    public final void registerStatement(ProxyStatementBase s) {
        if (this.openStmSize == this.openStatements.length) {
            ProxyStatementBase[] array = new ProxyStatementBase[this.openStmSize << 1];
            System.arraycopy(this.openStatements, 0, array, 0, this.openStmSize);
            this.openStatements = array;
        }
        this.openStatements[this.openStmSize++] = s;
    }

    public final void unregisterStatement(ProxyStatementBase s) {
        for (int i = this.openStmSize - 1; i >= 0; --i) {
            if (s != this.openStatements[i]) continue;
            int m = this.openStmSize - i - 1;
            if (m > 0) {
                System.arraycopy(this.openStatements, i + 1, this.openStatements, i, m);
            }
            this.openStatements[--this.openStmSize] = null;
            return;
        }
    }

    public final void clearStatement() {
        for (int i = 0; i < this.openStmSize; ++i) {
            ProxyStatementBase s = this.openStatements[i];
            if (s == null) continue;
            this.openStatements[i] = null;
            s.registered = false;
            PoolStaticCenter.oclose(s);
        }
        this.openStmSize = 0;
    }
}

