/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.ProxyDatabaseMetaDataBase;
import cn.beecp.pool.ProxyResultSetBase;
import cn.beecp.pool.ProxyStatementBase;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedList;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;

final class ProxyClassGenerator {
    private String defaultFolder = "BeeCP/target/classes";

    ProxyClassGenerator() {
    }

    public static void main(String[] args) throws Exception {
        String classesFolder = "";
        if (args != null && args.length > 0) {
            classesFolder = args[0];
        }
        new ProxyClassGenerator().writeProxyFile(classesFolder);
    }

    public void writeProxyFile(String folder) throws Exception {
        CtClass[] ctClasses;
        if (PoolStaticCenter.isBlank(folder)) {
            folder = this.defaultFolder;
        }
        for (CtClass ctClass : ctClasses = this.createJdbcProxyClasses()) {
            ctClass.writeFile(folder);
        }
    }

    private CtClass[] createJdbcProxyClasses() throws Exception {
        try {
            CtMethod[] ctMethods;
            ClassPool classPool = ClassPool.getDefault();
            classPool.importPackage("java.sql");
            classPool.importPackage("cn.beecp.pool");
            classPool.appendClassPath((ClassPath)new LoaderClassPath(this.getClass().getClassLoader()));
            CtClass ctConnectionClass = classPool.get(Connection.class.getName());
            CtClass ctProxyConnectionBaseClass = classPool.get(ProxyConnectionBase.class.getName());
            String ctProxyConnectionClassName = "cn.beecp.pool.ProxyConnection";
            CtClass ctProxyConnectionClass = classPool.makeClass(ctProxyConnectionClassName, ctProxyConnectionBaseClass);
            ctProxyConnectionClass.setModifiers(17);
            CtClass[] conCreateParam = new CtClass[]{classPool.get("cn.beecp.pool.PooledConnection")};
            CtConstructor ctConstructor = new CtConstructor(conCreateParam, ctProxyConnectionClass);
            ctConstructor.setModifiers(1);
            ctConstructor.setBody("{super($$);}");
            ctProxyConnectionClass.addConstructor(ctConstructor);
            CtClass ctStatementClass = classPool.get(Statement.class.getName());
            CtClass ctProxyStatementBaseClass = classPool.get(ProxyStatementBase.class.getName());
            String ctProxyStatementClassName = "cn.beecp.pool.ProxyStatement";
            CtClass ctProxyStatementClass = classPool.makeClass(ctProxyStatementClassName, ctProxyStatementBaseClass);
            ctProxyStatementClass.setModifiers(1);
            CtClass[] statementCreateParam = new CtClass[]{classPool.get("java.sql.Statement"), classPool.get("cn.beecp.pool.ProxyConnectionBase"), classPool.get("cn.beecp.pool.PooledConnection")};
            ctConstructor = new CtConstructor(statementCreateParam, ctProxyStatementClass);
            ctConstructor.setModifiers(1);
            ctConstructor.setBody("{super($$);}");
            ctProxyStatementClass.addConstructor(ctConstructor);
            CtClass ctPreparedStatementClass = classPool.get(PreparedStatement.class.getName());
            String ctProxyPsStatementClassName = "cn.beecp.pool.ProxyPsStatement";
            CtClass ctProxyPsStatementClass = classPool.makeClass(ctProxyPsStatementClassName, ctProxyStatementClass);
            ctProxyPsStatementClass.setInterfaces(new CtClass[]{ctPreparedStatementClass});
            ctProxyPsStatementClass.setModifiers(1);
            CtClass[] statementPsCreateParam = new CtClass[]{classPool.get("java.sql.PreparedStatement"), classPool.get("cn.beecp.pool.ProxyConnectionBase"), classPool.get("cn.beecp.pool.PooledConnection")};
            ctConstructor = new CtConstructor(statementPsCreateParam, ctProxyPsStatementClass);
            ctConstructor.setModifiers(1);
            ctConstructor.setBody("{super($$);}");
            ctProxyPsStatementClass.addConstructor(ctConstructor);
            CtClass ctCallableStatementClass = classPool.get(CallableStatement.class.getName());
            String ctProxyCsStatementClassName = "cn.beecp.pool.ProxyCsStatement";
            CtClass ctProxyCsStatementClass = classPool.makeClass(ctProxyCsStatementClassName, ctProxyPsStatementClass);
            ctProxyCsStatementClass.setInterfaces(new CtClass[]{ctCallableStatementClass});
            ctProxyCsStatementClass.setModifiers(1);
            CtClass[] statementCsCreateParam = new CtClass[]{classPool.get("java.sql.CallableStatement"), classPool.get("cn.beecp.pool.ProxyConnectionBase"), classPool.get("cn.beecp.pool.PooledConnection")};
            ctConstructor = new CtConstructor(statementCsCreateParam, ctProxyCsStatementClass);
            ctConstructor.setModifiers(1);
            ctConstructor.setBody("{super($$);}");
            ctProxyCsStatementClass.addConstructor(ctConstructor);
            CtClass ctDatabaseMetaDataClass = classPool.get(DatabaseMetaData.class.getName());
            CtClass ctProxyDatabaseMetaDataBaseClass = classPool.get(ProxyDatabaseMetaDataBase.class.getName());
            String ctProxyDatabaseMetaDataClassName = "cn.beecp.pool.ProxyDatabaseMetaData";
            CtClass ctProxyDatabaseMetaDataClass = classPool.makeClass(ctProxyDatabaseMetaDataClassName, ctProxyDatabaseMetaDataBaseClass);
            ctProxyDatabaseMetaDataClass.setModifiers(17);
            CtClass[] databaseMetaData = new CtClass[]{classPool.get("java.sql.DatabaseMetaData"), classPool.get("cn.beecp.pool.PooledConnection")};
            ctConstructor = new CtConstructor(databaseMetaData, ctProxyDatabaseMetaDataClass);
            ctConstructor.setModifiers(1);
            ctConstructor.setBody("{super($$);}");
            ctProxyDatabaseMetaDataClass.addConstructor(ctConstructor);
            CtClass ctResultSetClass = classPool.get(ResultSet.class.getName());
            CtClass ctProxyResultSetBaseClass = classPool.get(ProxyResultSetBase.class.getName());
            String ctProxyResultSetClassName = "cn.beecp.pool.ProxyResultSet";
            CtClass ctProxyResultSetClass = classPool.makeClass(ctProxyResultSetClassName, ctProxyResultSetBaseClass);
            ctProxyResultSetClass.setModifiers(17);
            CtClass[] resultSetCreateParam1 = new CtClass[]{classPool.get("java.sql.ResultSet"), classPool.get("cn.beecp.pool.PooledConnection")};
            CtConstructor ctConstructor1 = new CtConstructor(resultSetCreateParam1, ctProxyResultSetClass);
            ctConstructor1.setModifiers(1);
            ctConstructor1.setBody("{super($$);}");
            ctProxyResultSetClass.addConstructor(ctConstructor1);
            CtClass[] resultSetCreateParam2 = new CtClass[]{classPool.get("java.sql.ResultSet"), classPool.get("cn.beecp.pool.ProxyStatementBase"), classPool.get("cn.beecp.pool.PooledConnection")};
            ctConstructor = new CtConstructor(resultSetCreateParam2, ctProxyResultSetClass);
            ctConstructor.setModifiers(1);
            ctConstructor.setBody("{super($$);}");
            ctProxyResultSetClass.addConstructor(ctConstructor);
            this.createProxyConnectionClass(classPool, ctProxyConnectionClass, ctConnectionClass, ctProxyConnectionBaseClass);
            this.createProxyStatementClass(classPool, ctProxyStatementClass, ctStatementClass, ctProxyStatementBaseClass);
            this.createProxyStatementClass(classPool, ctProxyPsStatementClass, ctPreparedStatementClass, ctProxyStatementClass);
            this.createProxyStatementClass(classPool, ctProxyCsStatementClass, ctCallableStatementClass, ctProxyPsStatementClass);
            this.createProxyDatabaseMetaDataClass(classPool, ctProxyDatabaseMetaDataClass, ctDatabaseMetaDataClass, ctProxyDatabaseMetaDataBaseClass);
            this.createProxyResultSetClass(classPool, ctProxyResultSetClass, ctResultSetClass, ctProxyResultSetBaseClass);
            CtClass ctProxyObjectFactoryClass = classPool.get(PoolStaticCenter.class.getName());
            CtMethod createProxyConnectionMethod = null;
            CtMethod createProxyResultSetMethod = null;
            for (CtMethod method : ctMethods = ctProxyObjectFactoryClass.getDeclaredMethods()) {
                if ("createProxyConnection".equals(method.getName())) {
                    createProxyConnectionMethod = method;
                    continue;
                }
                if (!"createProxyResultSet".equals(method.getName())) continue;
                createProxyResultSetMethod = method;
            }
            createProxyConnectionMethod.setBody("{$2.lastUsed=$1; return new ProxyConnection($1);}");
            createProxyResultSetMethod.setBody("{return new ProxyResultSet($$);}");
            return new CtClass[]{ctProxyConnectionClass, ctProxyStatementClass, ctProxyPsStatementClass, ctProxyCsStatementClass, ctProxyDatabaseMetaDataClass, ctProxyResultSetClass, ctProxyObjectFactoryClass};
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    private Class createProxyConnectionClass(ClassPool classPool, CtClass ctConnectionClassProxyClass, CtClass ctConnectionClass, CtClass ctConBaseClass) throws Exception {
        CtMethod[] ctSuperClassMethods = ctConBaseClass.getMethods();
        HashSet<String> notNeedAddProxyMethods = new HashSet<String>(16);
        int l = ctSuperClassMethods.length;
        for (int i = 0; i < l; ++i) {
            int modifiers = ctSuperClassMethods[i].getModifiers();
            if ((Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers)) && !Modifier.isFinal((int)modifiers) && !Modifier.isStatic((int)modifiers) && !Modifier.isNative((int)modifiers)) continue;
            notNeedAddProxyMethods.add(ctSuperClassMethods[i].getName() + ctSuperClassMethods[i].getSignature());
        }
        LinkedList linkedList = new LinkedList();
        this.resolveInterfaceMethods(ctConnectionClass, linkedList, notNeedAddProxyMethods);
        CtClass ctStatementClass = classPool.get(Statement.class.getName());
        CtClass ctPreparedStatementClass = classPool.get(PreparedStatement.class.getName());
        CtClass ctCallableStatementClass = classPool.get(CallableStatement.class.getName());
        CtClass ctDatabaseMetaDataIntf = classPool.get(DatabaseMetaData.class.getName());
        StringBuilder methodBuffer = new StringBuilder(50);
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethodm = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctConnectionClassProxyClass, null);
            newCtMethodm.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{");
            if (ctMethod.getReturnType() == ctStatementClass) {
                newCtMethodm.setModifiers(17);
                methodBuffer.append("return new ProxyStatement(raw." + methodName + "($$),this,p);");
            } else if (ctMethod.getReturnType() == ctPreparedStatementClass) {
                newCtMethodm.setModifiers(17);
                methodBuffer.append("return new ProxyPsStatement(raw." + methodName + "($$),this,p);");
            } else if (ctMethod.getReturnType() == ctCallableStatementClass) {
                newCtMethodm.setModifiers(17);
                methodBuffer.append("return new ProxyCsStatement(raw." + methodName + "($$),this,p);");
            } else if (ctMethod.getReturnType() == ctDatabaseMetaDataIntf) {
                methodBuffer.append("return new ProxyDatabaseMetaData(raw." + methodName + "($$),p);");
            } else if (!methodName.equals("close")) {
                if (ctMethod.getReturnType() == CtClass.voidType) {
                    methodBuffer.append("raw." + methodName + "($$);");
                } else {
                    methodBuffer.append("return raw." + methodName + "($$);");
                }
            }
            methodBuffer.append("}");
            newCtMethodm.setBody(methodBuffer.toString());
            ctConnectionClassProxyClass.addMethod(newCtMethodm);
        }
        return ctConnectionClassProxyClass.toClass();
    }

    private Class createProxyStatementClass(ClassPool classPool, CtClass statementProxyClass, CtClass ctStatementClass, CtClass ctStatementSuperClass) throws Exception {
        CtMethod[] ctSuperClassMethods = ctStatementSuperClass.getMethods();
        HashSet<String> superClassSignatureSet = new HashSet<String>(16);
        int l = ctSuperClassMethods.length;
        for (int i = 0; i < l; ++i) {
            int modifiers = ctSuperClassMethods[i].getModifiers();
            if ((Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers)) && !Modifier.isFinal((int)modifiers) && !Modifier.isStatic((int)modifiers) && !Modifier.isNative((int)modifiers)) continue;
            superClassSignatureSet.add(ctSuperClassMethods[i].getName() + ctSuperClassMethods[i].getSignature());
        }
        LinkedList linkedList = new LinkedList();
        this.resolveInterfaceMethods(ctStatementClass, linkedList, superClassSignatureSet);
        CtClass ctResultSetClass = classPool.get(ResultSet.class.getName());
        StringBuilder methodBuffer = new StringBuilder(50);
        String rawName = "raw.";
        if ("java.sql.PreparedStatement".equals(ctStatementClass.getName())) {
            rawName = "((PreparedStatement)raw).";
        } else if ("java.sql.CallableStatement".equals(ctStatementClass.getName())) {
            rawName = "((CallableStatement)raw).";
        }
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethodm = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)statementProxyClass, null);
            newCtMethodm.setModifiers(methodName.startsWith("execute") ? 17 : 1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{");
            if (ctMethod.getReturnType() == CtClass.voidType) {
                if (methodName.startsWith("execute")) {
                    methodBuffer.append("p.commitDirtyInd=!p.curAutoCommit;");
                }
                methodBuffer.append(rawName + methodName + "($$);");
                if (methodName.startsWith("execute")) {
                    methodBuffer.append("p.lastAccessTime=System.currentTimeMillis();");
                }
            } else if (methodName.startsWith("execute")) {
                methodBuffer.append("p.commitDirtyInd=!p.curAutoCommit;");
                methodBuffer.append(ctMethod.getReturnType().getName() + " r=" + rawName + methodName + "($$);");
                methodBuffer.append("p.lastAccessTime=System.currentTimeMillis();");
                if (ctMethod.getReturnType() == ctResultSetClass) {
                    methodBuffer.append("return new ProxyResultSet(r,this,p);");
                } else {
                    methodBuffer.append("return r;");
                }
            } else if (ctMethod.getReturnType() == ctResultSetClass) {
                methodBuffer.append("return new ProxyResultSet(raw." + methodName + "($$),this,p);");
            } else {
                methodBuffer.append("return " + rawName + methodName + "($$);");
            }
            methodBuffer.append("}");
            newCtMethodm.setBody(methodBuffer.toString());
            statementProxyClass.addMethod(newCtMethodm);
        }
        return statementProxyClass.toClass();
    }

    private Class createProxyDatabaseMetaDataClass(ClassPool classPool, CtClass ctProxyDatabaseMetaDataClass, CtClass ctDatabaseMetaDataIntf, CtClass ctDatabaseMetaDataSuperClass) throws Exception {
        CtMethod[] ctSuperClassMethods = ctDatabaseMetaDataSuperClass.getMethods();
        HashSet<String> superClassSignatureSet = new HashSet<String>(16);
        int l = ctSuperClassMethods.length;
        for (int i = 0; i < l; ++i) {
            int modifiers = ctSuperClassMethods[i].getModifiers();
            if ((Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers)) && !Modifier.isFinal((int)modifiers) && !Modifier.isStatic((int)modifiers) && !Modifier.isNative((int)modifiers)) continue;
            superClassSignatureSet.add(ctSuperClassMethods[i].getName() + ctSuperClassMethods[i].getSignature());
        }
        LinkedList linkedList = new LinkedList();
        this.resolveInterfaceMethods(ctDatabaseMetaDataIntf, linkedList, superClassSignatureSet);
        CtClass ctResultSetClass = classPool.get(ResultSet.class.getName());
        StringBuilder methodBuffer = new StringBuilder(40);
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethodm = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctProxyDatabaseMetaDataClass, null);
            newCtMethodm.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{").append("checkClosed();");
            if (ctMethod.getReturnType() == ctResultSetClass) {
                methodBuffer.append("return new ProxyResultSet(raw." + methodName + "($$),p);");
            } else if (ctMethod.getReturnType() == CtClass.voidType) {
                methodBuffer.append("raw." + methodName + "($$);");
            } else {
                methodBuffer.append("return raw." + methodName + "($$);");
            }
            methodBuffer.append("}");
            newCtMethodm.setBody(methodBuffer.toString());
            ctProxyDatabaseMetaDataClass.addMethod(newCtMethodm);
        }
        return ctProxyDatabaseMetaDataClass.toClass();
    }

    private Class createProxyResultSetClass(ClassPool classPool, CtClass ctResultSetClassProxyClass, CtClass ctResultSetClass, CtClass ctResultSetClassSuperClass) throws Exception {
        CtMethod[] ctSuperClassMethods = ctResultSetClassSuperClass.getMethods();
        HashSet<String> superClassSignatureSet = new HashSet<String>(16);
        int l = ctSuperClassMethods.length;
        for (int i = 0; i < l; ++i) {
            int modifiers = ctSuperClassMethods[i].getModifiers();
            if ((Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers)) && !Modifier.isFinal((int)modifiers) && !Modifier.isStatic((int)modifiers) && !Modifier.isNative((int)modifiers)) continue;
            superClassSignatureSet.add(ctSuperClassMethods[i].getName() + ctSuperClassMethods[i].getSignature());
        }
        LinkedList linkedList = new LinkedList();
        this.resolveInterfaceMethods(ctResultSetClass, linkedList, superClassSignatureSet);
        StringBuilder methodBuffer = new StringBuilder(25);
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethodm = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctResultSetClassProxyClass, null);
            newCtMethodm.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{");
            if (!methodName.equals("close")) {
                if (ctMethod.getReturnType() == CtClass.voidType) {
                    methodBuffer.append("raw." + methodName + "($$);");
                    if (methodName.startsWith("insertRow") || methodName.startsWith("updateRow") || methodName.startsWith("deleteRow")) {
                        methodBuffer.append(" p.updateAccessTime();");
                    }
                } else if (methodName.startsWith("insertRow") || methodName.startsWith("updateRow") || methodName.startsWith("deleteRow")) {
                    methodBuffer.append(ctMethod.getReturnType().getName() + " r=raw." + methodName + "($$);").append(" p.updateAccessTime();").append(" return r;");
                } else {
                    methodBuffer.append("return raw." + methodName + "($$);");
                }
            }
            methodBuffer.append("}");
            newCtMethodm.setBody(methodBuffer.toString());
            ctResultSetClassProxyClass.addMethod(newCtMethodm);
        }
        return ctResultSetClassProxyClass.toClass();
    }

    private void resolveInterfaceMethods(CtClass interfaceClass, LinkedList linkedList, HashSet exitSignatureSet) throws Exception {
        CtMethod[] ctMethods = interfaceClass.getDeclaredMethods();
        for (int i = 0; i < ctMethods.length; ++i) {
            int modifiers = ctMethods[i].getModifiers();
            String signature = ctMethods[i].getName() + ctMethods[i].getSignature();
            if (!Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers) || Modifier.isStatic((int)modifiers) || Modifier.isFinal((int)modifiers) || exitSignatureSet.contains(signature)) continue;
            linkedList.add(ctMethods[i]);
            exitSignatureSet.add(signature);
        }
        CtClass[] superInterfaces = interfaceClass.getInterfaces();
        for (int i = 0; i < superInterfaces.length; ++i) {
            this.resolveInterfaceMethods(superInterfaces[i], linkedList, exitSignatureSet);
        }
    }
}

