/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyStatementBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executor;

public abstract class ProxyConnectionBase
implements Connection {
    private static final int PS_AUTO = 0;
    private static final int PS_TRANS = 1;
    private static final int PS_READONLY = 2;
    private static final int PS_CATALOG = 3;
    private static final int PS_SCHEMA = 4;
    private static final int PS_NETWORK = 5;
    protected final PooledConnection p;
    protected Connection raw;
    private boolean isClosed;

    public ProxyConnectionBase(PooledConnection p) {
        this.p = p;
        this.raw = p.raw;
        p.proxyCon = this;
    }

    public final boolean getClosedInd() {
        return this.isClosed;
    }

    public final void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw PoolStaticCenter.ConnectionClosedException;
        }
    }

    public Connection getRaw() throws SQLException {
        this.checkClosed();
        return this.raw;
    }

    final synchronized void registerStatement(ProxyStatementBase s) {
        this.p.registerStatement(s);
    }

    final synchronized void unregisterStatement(ProxyStatementBase s) {
        this.p.unregisterStatement(s);
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        ProxyConnectionBase proxyConnectionBase = this;
        synchronized (proxyConnectionBase) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.raw = PoolStaticCenter.CLOSED_CON;
            if (this.p.openStmSize > 0) {
                this.p.clearStatement();
            }
        }
        this.p.recycleSelf();
    }

    @Override
    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.p.commitDirtyInd) {
            throw PoolStaticCenter.AutoCommitChangeForbiddenException;
        }
        this.raw.setAutoCommit(autoCommit);
        this.p.curAutoCommit = autoCommit;
        this.p.setResetInd(0, autoCommit != this.p.defAutoCommit);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.raw.setTransactionIsolation(level);
        this.p.setResetInd(1, level != this.p.defTransactionIsolation);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.raw.setReadOnly(readOnly);
        this.p.setResetInd(2, readOnly != this.p.defReadOnly);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.raw.setCatalog(catalog);
        this.p.setResetInd(3, !PoolStaticCenter.equals(catalog, this.p.defCatalog));
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.raw.setSchema(schema);
        this.p.setResetInd(4, !PoolStaticCenter.equals(schema, this.p.defSchema));
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException("executor can't be null");
        }
        executor.execute(new PoolStaticCenter.ProxyConnectionCloseTask(this));
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (!this.p.supportNetworkTimeout()) {
            throw PoolStaticCenter.DriverNotSupportNetworkTimeoutException;
        }
        this.raw.setNetworkTimeout(executor, milliseconds);
        this.p.setResetInd(5, milliseconds != this.p.defNetworkTimeout);
    }

    @Override
    public void commit() throws SQLException {
        this.raw.commit();
        this.p.lastAccessTime = System.currentTimeMillis();
        this.p.commitDirtyInd = false;
    }

    @Override
    public void rollback() throws SQLException {
        this.raw.rollback();
        this.p.lastAccessTime = System.currentTimeMillis();
        this.p.commitDirtyInd = false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("Wrapped object is not an instance of " + iface);
    }
}

