/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyStatementBase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

abstract class ProxyResultSetBase
implements ResultSet {
    protected final PooledConnection p;
    protected ResultSet raw;
    boolean isClosed;
    private ProxyStatementBase owner;

    public ProxyResultSetBase(ResultSet raw, PooledConnection p) {
        this.raw = raw;
        this.p = p;
    }

    public ProxyResultSetBase(ResultSet raw, ProxyStatementBase o, PooledConnection p) {
        o.setOpenResultSet(this);
        this.raw = raw;
        this.owner = o;
        this.p = p;
    }

    boolean containsRaw(ResultSet raw) {
        return this.raw == raw;
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isClosed) {
            throw PoolStaticCenter.ResultSetClosedException;
        }
        return this.owner;
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public final void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        try {
            this.isClosed = true;
            this.raw.close();
        }
        finally {
            this.raw = PoolStaticCenter.CLOSED_RSLT;
            if (this.owner != null) {
                this.owner.removeOpenResultSet(this);
            }
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("Wrapped object is not an instance of " + iface);
    }
}

