/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.ProxyResultSetBase;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

abstract class ProxyStatementBase
implements Statement {
    protected final PooledConnection p;
    private final ProxyConnectionBase owner;
    protected Statement raw;
    boolean registered = true;
    private boolean isClosed;
    private ProxyResultSetBase curRe;
    private ArrayList<ProxyResultSetBase> results;
    private int resultOpenCode = 1;

    public ProxyStatementBase(Statement raw, ProxyConnectionBase o, PooledConnection p) {
        o.registerStatement(this);
        this.raw = raw;
        this.owner = o;
        this.p = p;
    }

    final void removeOpenResultSet(ProxyResultSetBase r) {
        if (r == this.curRe) {
            this.curRe = null;
        } else if (this.results != null) {
            this.results.remove(r);
        }
    }

    final void setOpenResultSet(ProxyResultSetBase r) {
        switch (this.resultOpenCode) {
            case 1: {
                if (this.curRe == null || this.curRe.isClosed) break;
                PoolStaticCenter.oclose(this.curRe);
                break;
            }
            case 2: {
                if (this.curRe == null || this.curRe.isClosed) break;
                if (this.results == null) {
                    this.results = new ArrayList(1);
                }
                this.results.add(this.curRe);
                break;
            }
            case 3: {
                if (this.curRe != null && !this.curRe.isClosed) {
                    PoolStaticCenter.oclose(this.curRe);
                }
                if (this.results == null) break;
                int l = this.results.size();
                for (int i = 0; i < l; ++i) {
                    ProxyResultSetBase openRe = this.results.get(i);
                    if (openRe.isClosed) continue;
                    PoolStaticCenter.oclose(openRe);
                }
                this.results.clear();
                break;
            }
        }
        this.curRe = r;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed) {
            throw PoolStaticCenter.ConnectionClosedException;
        }
        return this.owner;
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public final void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.curRe != null) {
            PoolStaticCenter.oclose(this.curRe);
        }
        if (this.results != null) {
            int l = this.results.size();
            for (int i = 0; i < l; ++i) {
                PoolStaticCenter.oclose(this.results.get(i));
            }
            this.results.clear();
        }
        try {
            this.raw.close();
        }
        finally {
            this.raw = PoolStaticCenter.CLOSED_CSTM;
            if (this.registered) {
                this.owner.unregisterStatement(this);
            }
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.resultOpenCode = current;
        return this.raw.getMoreResults(current);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet re = this.raw.getResultSet();
        if (re == null) {
            return null;
        }
        if (this.curRe != null && this.curRe.containsRaw(re)) {
            return this.curRe;
        }
        if (this.results != null) {
            for (ProxyResultSetBase resultSetBase : this.results) {
                if (!resultSetBase.containsRaw(re)) continue;
                return resultSetBase;
            }
        }
        return PoolStaticCenter.createProxyResultSet(re, this, this.p);
    }

    @Override
    public void setPoolable(boolean var1) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("Wrapped object is not an instance of " + iface);
    }
}

