/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.BeeDataSourceConfig;
import cn.beecp.pool.ConnectionPool;
import cn.beecp.pool.ConnectionPoolJmxBean;
import cn.beecp.pool.ConnectionPoolMonitorVo;
import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.PooledConnection;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class RawConnectionPool
implements ConnectionPool,
ConnectionPoolJmxBean {
    private static final AtomicInteger poolNameIndex = new AtomicInteger(1);
    private static final ConnectionPoolMonitorVo monitorVo = new ConnectionPoolMonitorVo();
    private String poolName = "";
    private String poolMode = "";
    private long defaultMaxWait;
    private Semaphore borrowSemaphore;
    private BeeDataSourceConfig poolConfig;
    private AtomicInteger poolState = new AtomicInteger(1);

    @Override
    public void init(BeeDataSourceConfig config) {
        this.poolConfig = config;
        this.defaultMaxWait = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getMaxWait());
        this.borrowSemaphore = new Semaphore(this.poolConfig.getBorrowSemaphoreSize(), this.poolConfig.isFairMode());
        this.poolName = !PoolStaticCenter.isBlank(config.getPoolName()) ? config.getPoolName() : "RawPool-" + poolNameIndex.getAndIncrement();
        this.poolMode = this.poolConfig.isFairMode() ? "fair" : "compete";
        this.registerJMX();
        PoolStaticCenter.CommonLog.info("BeeCP({})has been startup{init size:{},max size:{},concurrent size:{},mode:{},max wait:{}ms},driver:{}}", new Object[]{this.poolName, 0, 0, this.poolConfig.getBorrowSemaphoreSize(), this.poolMode, 0, this.poolConfig.getDriverClassName()});
        this.poolState.set(2);
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            if (this.poolState.get() != 2) {
                throw PoolStaticCenter.PoolCloseException;
            }
            if (this.borrowSemaphore.tryAcquire(this.defaultMaxWait, TimeUnit.NANOSECONDS)) {
                Connection connection = this.poolConfig.getConnectionFactory().create();
                return connection;
            }
            try {
                throw PoolStaticCenter.RequestTimeoutException;
            }
            catch (InterruptedException e) {
                throw PoolStaticCenter.RequestInterruptException;
            }
        }
        finally {
            this.borrowSemaphore.release();
        }
    }

    @Override
    public void recycle(PooledConnection p) {
    }

    @Override
    public void close() throws SQLException {
        if (this.poolState.get() == 3) {
            throw PoolStaticCenter.PoolCloseException;
        }
        do {
            if (!this.poolState.compareAndSet(2, 3)) continue;
            this.unregisterJMX();
            break;
        } while (this.poolState.get() != 3);
    }

    @Override
    public boolean isClosed() {
        return this.poolState.get() == 3;
    }

    @Override
    public void clearAllConnections() {
    }

    @Override
    public void clearAllConnections(boolean force) {
    }

    @Override
    public int getConnTotalSize() {
        return 0;
    }

    @Override
    public int getConnIdleSize() {
        return 0;
    }

    @Override
    public int getConnUsingSize() {
        return 0;
    }

    @Override
    public int getSemaphoreAcquiredSize() {
        return this.poolConfig.getBorrowSemaphoreSize() - this.borrowSemaphore.availablePermits();
    }

    @Override
    public int getSemaphoreWaitingSize() {
        return this.borrowSemaphore.getQueueLength();
    }

    @Override
    public int getTransferWaitingSize() {
        return 0;
    }

    @Override
    public void setPrintRuntimeLog(boolean enabledDebug) {
    }

    @Override
    public ConnectionPoolMonitorVo getMonitorVo() {
        int totSize = this.getConnTotalSize();
        int idleSize = this.getConnIdleSize();
        monitorVo.setPoolName(this.poolName);
        monitorVo.setPoolMode(this.poolMode);
        monitorVo.setPoolState(2);
        monitorVo.setMaxActive(this.poolConfig.getBorrowSemaphoreSize());
        monitorVo.setIdleSize(idleSize);
        monitorVo.setUsingSize(totSize - idleSize);
        monitorVo.setSemaphoreWaiterSize(this.getSemaphoreWaitingSize());
        monitorVo.setTransferWaiterSize(this.getTransferWaitingSize());
        return monitorVo;
    }

    private void registerJMX() {
        if (this.poolConfig.isEnableJmx()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName poolRegName = new ObjectName("cn.beecp.pool.RawConnectionPool:type=BeeCP(" + this.poolName + ")");
                if (!mBeanServer.isRegistered(poolRegName)) {
                    mBeanServer.registerMBean(this, poolRegName);
                    PoolStaticCenter.CommonLog.info("Registered BeeCP({})as jmx-bean", (Object)this.poolName);
                } else {
                    PoolStaticCenter.CommonLog.error("Jmx-name BeeCP({})has been exist in jmx server", (Object)this.poolName);
                }
            }
            catch (Exception e) {
                PoolStaticCenter.CommonLog.warn("Failed to register pool jmx-bean", (Throwable)e);
            }
            try {
                ObjectName configRegName = new ObjectName("cn.beecp.BeeDataSourceConfig:type=BeeCP(" + this.poolName + ")-config");
                if (!mBeanServer.isRegistered(configRegName)) {
                    mBeanServer.registerMBean(this.poolConfig, configRegName);
                    PoolStaticCenter.CommonLog.info("Registered BeeCP({})config as jmx-bean", (Object)this.poolName);
                } else {
                    PoolStaticCenter.CommonLog.error("Pool BeeCP({})config has been exist in jmx server", (Object)this.poolName);
                }
            }
            catch (Exception e) {
                PoolStaticCenter.CommonLog.warn("Failed to register pool jmx-bean", (Throwable)e);
            }
        }
    }

    private void unregisterJMX() {
        if (this.poolConfig.isEnableJmx()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName poolRegName = new ObjectName("cn.beecp.pool.RawConnectionPool:type=BeeCP(" + this.poolName + ")");
                if (mBeanServer.isRegistered(poolRegName)) {
                    mBeanServer.unregisterMBean(poolRegName);
                }
            }
            catch (Exception e) {
                PoolStaticCenter.CommonLog.warn("Failed to unregister pool jmx-bean", (Throwable)e);
            }
            try {
                ObjectName configRegName = new ObjectName("cn.beecp.BeeDataSourceConfig:type=BeeCP(" + this.poolName + ")-config");
                if (mBeanServer.isRegistered(configRegName)) {
                    mBeanServer.unregisterMBean(configRegName);
                }
            }
            catch (Exception e) {
                PoolStaticCenter.CommonLog.warn("Failed to unregister pool jmx-bean", (Throwable)e);
            }
        }
    }
}

