/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.xa;

import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.xa.ProxyXaResource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class ProxyXaConnection
implements XAConnection {
    private XAConnection raw;
    private ProxyXaResource proxyXaResource;
    private ProxyConnectionBase proxyBaseConn;

    public ProxyXaConnection(XAConnection raw, ProxyConnectionBase proxyCon) {
        this.raw = raw;
        this.proxyBaseConn = proxyCon;
    }

    void checkClosedForXa() throws XAException {
        if (this.proxyBaseConn.getClosedInd()) {
            throw PoolStaticCenter.XaConnectionClosedException;
        }
    }

    @Override
    public void close() throws SQLException {
        this.proxyBaseConn.close();
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.proxyBaseConn.checkClosed();
        return this.proxyBaseConn;
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        this.proxyBaseConn.checkClosed();
        if (this.proxyXaResource == null) {
            this.proxyXaResource = new ProxyXaResource(this.raw.getXAResource(), this);
        }
        return this.proxyXaResource;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
    }
}

