/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.xa.impl;

import cn.beecp.BeeDataSourceConfigException;
import cn.beecp.xa.RawXaConnectionFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;

public class Mysql5XaConnectionFactory
implements RawXaConnectionFactory {
    private boolean logXaCommands;
    private Constructor xaConnectionConstructor;

    public Mysql5XaConnectionFactory() {
        try {
            Class<?> dsClass = Class.forName("com.mysql.jdbc.jdbc2.optional.MysqlXADataSource");
            Class<?> conClass = Class.forName("com.mysql.jdbc.Connection");
            Class<?> xaConClass = Class.forName("com.mysql.jdbc.jdbc2.optional.JDBC4MysqlXAConnection");
            Object ds = dsClass.newInstance();
            Method logIndMethod = dsClass.getMethod("getLogXaCommands", new Class[0]);
            this.logXaCommands = (Boolean)logIndMethod.invoke(ds, new Object[0]);
            this.xaConnectionConstructor = xaConClass.getConstructor(conClass, Boolean.TYPE);
        }
        catch (Throwable e) {
            throw new BeeDataSourceConfigException(e);
        }
    }

    @Override
    public XAConnection create(Connection rawCon) throws SQLException {
        try {
            return (XAConnection)this.xaConnectionConstructor.newInstance(rawCon, this.logXaCommands);
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
    }
}

