/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.FastConnectionPool;
import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.ProxyStatementBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ThreadPoolExecutor;
import javax.transaction.xa.XAResource;

final class PooledConnection
implements Cloneable {
    private static final boolean[] FALSE = new boolean[6];
    final boolean defaultAutoCommit;
    final int defaultTransactionIsolation;
    final boolean defaultReadOnly;
    final String defaultCatalog;
    final String defaultSchema;
    final int defaultNetworkTimeout;
    private final boolean defaultCatalogIsNotBlank;
    private final boolean defaultSchemaIsNotBlank;
    private final boolean supportNetworkTimeoutInd;
    private final ThreadPoolExecutor networkTimeoutExecutor;
    private final FastConnectionPool pool;
    Connection rawConn;
    XAResource rawXaRes;
    volatile int state;
    volatile long lastAccessTime;
    int openStmSize;
    boolean curAutoCommit;
    boolean commitDirtyInd;
    ProxyConnectionBase proxyInUsing;
    private int resetCnt;
    private boolean[] resetFlags;
    private ProxyStatementBase[] openStatements;

    PooledConnection(boolean defaultAutoCommit, int defaultTransactionIsolation, boolean defaultReadOnly, String defaultCatalog, String defaultSchema, int defaultNetworkTimeout, boolean supportNetworkTimeoutInd, ThreadPoolExecutor networkTimeoutExecutor, FastConnectionPool pool) {
        this.defaultAutoCommit = defaultAutoCommit;
        this.defaultTransactionIsolation = defaultTransactionIsolation;
        this.defaultReadOnly = defaultReadOnly;
        this.defaultCatalog = defaultCatalog;
        this.defaultSchema = defaultSchema;
        this.defaultNetworkTimeout = defaultNetworkTimeout;
        this.defaultCatalogIsNotBlank = !PoolStaticCenter.isBlank(defaultCatalog);
        this.defaultSchemaIsNotBlank = !PoolStaticCenter.isBlank(defaultSchema);
        this.supportNetworkTimeoutInd = supportNetworkTimeoutInd;
        this.networkTimeoutExecutor = networkTimeoutExecutor;
        this.pool = pool;
        this.curAutoCommit = defaultAutoCommit;
    }

    final PooledConnection setDefaultAndCopy(Connection rawConn, int state, XAResource rawXaRes) throws SQLException, CloneNotSupportedException {
        if (this.defaultAutoCommit != rawConn.getAutoCommit()) {
            rawConn.setAutoCommit(this.defaultAutoCommit);
        }
        if (this.defaultTransactionIsolation != rawConn.getTransactionIsolation()) {
            rawConn.setTransactionIsolation(this.defaultTransactionIsolation);
        }
        if (this.defaultReadOnly != rawConn.isReadOnly()) {
            rawConn.setReadOnly(this.defaultReadOnly);
        }
        if (this.defaultCatalogIsNotBlank && !this.defaultCatalog.equals(rawConn.getCatalog())) {
            rawConn.setCatalog(this.defaultCatalog);
        }
        if (this.defaultSchemaIsNotBlank && !this.defaultSchema.equals(rawConn.getSchema())) {
            rawConn.setSchema(this.defaultSchema);
        }
        PooledConnection p = (PooledConnection)this.clone();
        p.state = state;
        p.rawConn = rawConn;
        p.rawXaRes = rawXaRes;
        p.resetFlags = (boolean[])FALSE.clone();
        p.openStatements = new ProxyStatementBase[10];
        p.lastAccessTime = System.currentTimeMillis();
        return p;
    }

    final boolean supportNetworkTimeoutSet() {
        return this.supportNetworkTimeoutInd;
    }

    final void updateAccessTime() {
        this.commitDirtyInd = !this.curAutoCommit;
        this.lastAccessTime = System.currentTimeMillis();
    }

    final void setResetInd(int i, boolean changed) {
        if (this.resetFlags[i] != changed) {
            this.resetFlags[i] = changed;
            this.resetCnt += changed ? 1 : -1;
        }
    }

    final void removeSelf() {
        this.pool.abandonOnReturn(this, "abort");
    }

    final void onBeforeRemove() {
        try {
            this.state = 2;
            this.resetRawConn();
        }
        catch (Throwable e) {
            PoolStaticCenter.CommonLog.error("Connection close error", e);
        }
        finally {
            PoolStaticCenter.oclose(this.rawConn);
            this.rawXaRes = null;
        }
    }

    final void recycleSelf() throws SQLException {
        try {
            this.proxyInUsing = null;
            this.resetRawConn();
            this.pool.recycle(this);
        }
        catch (Throwable e) {
            this.pool.abandonOnReturn(this, "bad");
            throw e instanceof SQLException ? (SQLException)e : new SQLException(e);
        }
    }

    private void resetRawConn() throws SQLException {
        if (this.commitDirtyInd) {
            this.rawConn.rollback();
            this.commitDirtyInd = false;
        }
        if (this.resetCnt > 0) {
            if (this.resetFlags[0]) {
                this.rawConn.setAutoCommit(this.defaultAutoCommit);
                this.curAutoCommit = this.defaultAutoCommit;
            }
            if (this.resetFlags[1]) {
                this.rawConn.setTransactionIsolation(this.defaultTransactionIsolation);
            }
            if (this.resetFlags[2]) {
                this.rawConn.setReadOnly(this.defaultReadOnly);
            }
            if (this.defaultCatalogIsNotBlank && this.resetFlags[3]) {
                this.rawConn.setCatalog(this.defaultCatalog);
            }
            if (this.defaultSchemaIsNotBlank && this.resetFlags[4]) {
                this.rawConn.setSchema(this.defaultSchema);
            }
            if (this.resetFlags[5]) {
                this.rawConn.setNetworkTimeout(this.networkTimeoutExecutor, this.defaultNetworkTimeout);
            }
            this.resetCnt = 0;
            System.arraycopy(FALSE, 0, this.resetFlags, 0, 6);
        }
        this.rawConn.clearWarnings();
    }

    final void registerStatement(ProxyStatementBase s) {
        if (this.openStmSize == this.openStatements.length) {
            ProxyStatementBase[] array = new ProxyStatementBase[this.openStmSize << 1];
            System.arraycopy(this.openStatements, 0, array, 0, this.openStmSize);
            this.openStatements = array;
        }
        this.openStatements[this.openStmSize++] = s;
    }

    final void unregisterStatement(ProxyStatementBase s) {
        for (int i = this.openStmSize - 1; i >= 0; --i) {
            if (s != this.openStatements[i]) continue;
            int m = this.openStmSize - i - 1;
            if (m > 0) {
                System.arraycopy(this.openStatements, i + 1, this.openStatements, i, m);
            }
            this.openStatements[--this.openStmSize] = null;
            return;
        }
    }

    final void clearStatement() {
        for (int i = 0; i < this.openStmSize; ++i) {
            ProxyStatementBase s = this.openStatements[i];
            if (s == null) continue;
            s.registered = false;
            this.openStatements[i] = null;
            PoolStaticCenter.oclose(s);
        }
        this.openStmSize = 0;
    }
}

