/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.jta;

import cn.beecp.BeeConnectionPoolMonitorVo;
import cn.beecp.BeeDataSource;
import cn.beecp.jta.BeeJtaSynchronization;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeeJtaDataSource
extends TimerTask
implements DataSource {
    private BeeDataSource ds;
    private TransactionManager tm;
    private Timer transactionTimer = new Timer(true);
    private ConcurrentHashMap<Transaction, Connection> transactionMap = new ConcurrentHashMap(10);

    public BeeJtaDataSource() {
        this(null, null);
    }

    public BeeJtaDataSource(BeeDataSource ds, TransactionManager tm) {
        this.ds = ds;
        this.tm = tm;
        this.transactionTimer.schedule((TimerTask)this, 0L, 6000L);
    }

    public void setDataSource(BeeDataSource ds) {
        this.ds = ds;
    }

    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn;
        Transaction transaction;
        this.checkDataSource();
        if (this.tm == null) {
            throw new SQLException("transactionManager not set");
        }
        try {
            transaction = this.tm.getTransaction();
            int statusCode = transaction.getStatus();
            if (0 != statusCode) {
                throw new SQLException("Current transaction status code is not expect value:" + statusCode);
            }
            conn = this.transactionMap.get(transaction);
            if (conn != null) {
                return conn;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
        XAConnection xaConn = null;
        try {
            xaConn = this.ds.getXAConnection();
            conn = xaConn.getConnection();
            if (transaction.enlistResource(xaConn.getXAResource())) {
                this.transactionMap.put(transaction, conn);
                BeeJtaSynchronization synchronization = new BeeJtaSynchronization(transaction, this.transactionMap);
                transaction.registerSynchronization((Synchronization)synchronization);
                return conn;
            }
            throw new SQLException("Failed to enlist resource in transaction");
        }
        catch (Throwable e) {
            if (xaConn != null) {
                xaConn.close();
            }
            throw e instanceof SQLException ? (SQLException)e : new SQLException(e);
        }
    }

    @Override
    public void run() {
        Iterator<Map.Entry<Transaction, Connection>> iterator = this.transactionMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Transaction, Connection> entry = iterator.next();
            Transaction transaction = entry.getKey();
            try {
                int statusCode = transaction.getStatus();
                if (statusCode != 3 && statusCode != 9) continue;
                iterator.remove();
                entry.getValue().close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void checkDataSource() throws SQLException {
        if (this.ds == null || this.ds.isClosed()) {
            throw new SQLException("dataSource not set or closed");
        }
    }

    public void clear() throws SQLException {
        this.clear(false);
    }

    public void clear(boolean force) throws SQLException {
        this.checkDataSource();
        this.ds.clear(force);
    }

    public boolean isClosed() throws SQLException {
        this.checkDataSource();
        return this.ds.isClosed();
    }

    public void close() throws SQLException {
        this.checkDataSource();
        this.ds.close();
        this.transactionTimer.cancel();
    }

    public void setPrintRuntimeLog(boolean printRuntimeLog) throws SQLException {
        this.checkDataSource();
        this.ds.setPrintRuntimeLog(printRuntimeLog);
    }

    public BeeConnectionPoolMonitorVo getPoolMonitorVo() throws SQLException {
        this.checkDataSource();
        return this.ds.getPoolMonitorVo();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz != null && clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz != null && clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new SQLException("Wrapped object was not an instance of " + clazz);
    }
}

