/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.ProxyDatabaseMetaDataBase;
import cn.beecp.pool.ProxyResultSetBase;
import cn.beecp.pool.ProxyStatementBase;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedList;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;

final class ProxyClassGenerator {
    private static final String DefaultFolder = "BeeCP/target/classes";

    ProxyClassGenerator() {
    }

    public static void main(String[] args) throws Exception {
        String classesFolder = "";
        if (args != null && args.length > 0) {
            classesFolder = args[0];
        }
        if (PoolStaticCenter.isBlank(classesFolder)) {
            classesFolder = DefaultFolder;
        }
        ProxyClassGenerator.writeProxyFile(classesFolder);
    }

    private static void resolveInterfaceMethods(CtClass interfaceClass, LinkedList linkedList, HashSet exitSignatureSet) throws Exception {
        for (CtMethod ctMethod : interfaceClass.getDeclaredMethods()) {
            int modifiers = ctMethod.getModifiers();
            String signature = ctMethod.getName() + ctMethod.getSignature();
            if (!Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers) || Modifier.isStatic((int)modifiers) || Modifier.isFinal((int)modifiers) || exitSignatureSet.contains(signature)) continue;
            linkedList.add(ctMethod);
            exitSignatureSet.add(signature);
        }
        for (CtMethod ctMethod : interfaceClass.getInterfaces()) {
            ProxyClassGenerator.resolveInterfaceMethods((CtClass)ctMethod, linkedList, exitSignatureSet);
        }
    }

    private static void writeProxyFile(String folder) throws Exception {
        CtClass[] ctClasses;
        for (CtClass ctClass : ctClasses = ProxyClassGenerator.createProxyClasses()) {
            ctClass.writeFile(folder);
        }
    }

    private static CtClass[] createProxyClasses() throws Exception {
        ClassPool classPool = ClassPool.getDefault();
        classPool.importPackage("java.sql");
        classPool.importPackage("cn.beecp.pool");
        classPool.appendClassPath((ClassPath)new LoaderClassPath(ProxyClassGenerator.class.getClassLoader()));
        CtClass ctConnectionClass = classPool.get(Connection.class.getName());
        CtClass ctProxyConnectionBaseClass = classPool.get(ProxyConnectionBase.class.getName());
        CtClass ctProxyConnectionClass = classPool.makeClass("cn.beecp.pool.ProxyConnection", ctProxyConnectionBaseClass);
        ctProxyConnectionClass.setModifiers(17);
        CtConstructor ctConstructor = new CtConstructor(new CtClass[]{classPool.get("cn.beecp.pool.PooledConnection")}, ctProxyConnectionClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyConnectionClass.addConstructor(ctConstructor);
        CtClass ctStatementClass = classPool.get(Statement.class.getName());
        CtClass ctProxyStatementBaseClass = classPool.get(ProxyStatementBase.class.getName());
        CtClass ctProxyStatementClass = classPool.makeClass("cn.beecp.pool.ProxyStatement", ctProxyStatementBaseClass);
        ctProxyStatementClass.setModifiers(1);
        CtClass[] statementCreateParamTypes = new CtClass[]{classPool.get("java.sql.Statement"), classPool.get("cn.beecp.pool.ProxyConnectionBase"), classPool.get("cn.beecp.pool.PooledConnection")};
        ctConstructor = new CtConstructor(statementCreateParamTypes, ctProxyStatementClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyStatementClass.addConstructor(ctConstructor);
        CtClass ctPreparedStatementClass = classPool.get(PreparedStatement.class.getName());
        CtClass ctProxyPsStatementClass = classPool.makeClass("cn.beecp.pool.ProxyPsStatement", ctProxyStatementClass);
        ctProxyPsStatementClass.setInterfaces(new CtClass[]{ctPreparedStatementClass});
        ctProxyPsStatementClass.setModifiers(1);
        CtClass[] statementPsCreateParamTypes = new CtClass[]{classPool.get("java.sql.PreparedStatement"), classPool.get("cn.beecp.pool.ProxyConnectionBase"), classPool.get("cn.beecp.pool.PooledConnection")};
        ctConstructor = new CtConstructor(statementPsCreateParamTypes, ctProxyPsStatementClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyPsStatementClass.addConstructor(ctConstructor);
        CtClass ctCallableStatementClass = classPool.get(CallableStatement.class.getName());
        CtClass ctProxyCsStatementClass = classPool.makeClass("cn.beecp.pool.ProxyCsStatement", ctProxyPsStatementClass);
        ctProxyCsStatementClass.setInterfaces(new CtClass[]{ctCallableStatementClass});
        ctProxyCsStatementClass.setModifiers(1);
        CtClass[] statementCsCreateParamTypes = new CtClass[]{classPool.get("java.sql.CallableStatement"), classPool.get("cn.beecp.pool.ProxyConnectionBase"), classPool.get("cn.beecp.pool.PooledConnection")};
        ctConstructor = new CtConstructor(statementCsCreateParamTypes, ctProxyCsStatementClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyCsStatementClass.addConstructor(ctConstructor);
        CtClass ctDatabaseMetaDataClass = classPool.get(DatabaseMetaData.class.getName());
        CtClass ctProxyDatabaseMetaDataBaseClass = classPool.get(ProxyDatabaseMetaDataBase.class.getName());
        CtClass ctProxyDatabaseMetaDataClass = classPool.makeClass("cn.beecp.pool.ProxyDatabaseMetaData", ctProxyDatabaseMetaDataBaseClass);
        ctProxyDatabaseMetaDataClass.setModifiers(17);
        CtClass[] databaseMetaDataTypes = new CtClass[]{classPool.get("java.sql.DatabaseMetaData"), classPool.get("cn.beecp.pool.PooledConnection")};
        ctConstructor = new CtConstructor(databaseMetaDataTypes, ctProxyDatabaseMetaDataClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyDatabaseMetaDataClass.addConstructor(ctConstructor);
        CtClass ctResultSetClass = classPool.get(ResultSet.class.getName());
        CtClass ctProxyResultSetBaseClass = classPool.get(ProxyResultSetBase.class.getName());
        CtClass ctProxyResultSetClass = classPool.makeClass("cn.beecp.pool.ProxyResultSet", ctProxyResultSetBaseClass);
        ctProxyResultSetClass.setModifiers(17);
        CtClass[] resultSetCreateParamTypes1 = new CtClass[]{classPool.get("java.sql.ResultSet"), classPool.get("cn.beecp.pool.PooledConnection")};
        CtConstructor ctConstructor1 = new CtConstructor(resultSetCreateParamTypes1, ctProxyResultSetClass);
        ctConstructor1.setBody("{super($$);}");
        ctProxyResultSetClass.addConstructor(ctConstructor1);
        CtClass[] resultSetCreateParamTypes2 = new CtClass[]{classPool.get("java.sql.ResultSet"), classPool.get("cn.beecp.pool.ProxyStatementBase"), classPool.get("cn.beecp.pool.PooledConnection")};
        ctConstructor = new CtConstructor(resultSetCreateParamTypes2, ctProxyResultSetClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyResultSetClass.addConstructor(ctConstructor);
        ProxyClassGenerator.createProxyConnectionClass(classPool, ctProxyConnectionClass, ctConnectionClass, ctProxyConnectionBaseClass);
        ProxyClassGenerator.createProxyStatementClass(classPool, ctProxyStatementClass, ctStatementClass, ctProxyStatementBaseClass);
        ProxyClassGenerator.createProxyStatementClass(classPool, ctProxyPsStatementClass, ctPreparedStatementClass, ctProxyStatementClass);
        ProxyClassGenerator.createProxyStatementClass(classPool, ctProxyCsStatementClass, ctCallableStatementClass, ctProxyPsStatementClass);
        ProxyClassGenerator.createProxyDatabaseMetaDataClass(classPool, ctProxyDatabaseMetaDataClass, ctDatabaseMetaDataClass, ctProxyDatabaseMetaDataBaseClass);
        ProxyClassGenerator.createProxyResultSetClass(ctProxyResultSetClass, ctResultSetClass, ctProxyResultSetBaseClass);
        CtClass ctProxyObjectFactoryClass = classPool.get(PoolStaticCenter.class.getName());
        for (CtMethod method : ctProxyObjectFactoryClass.getDeclaredMethods()) {
            if ("createProxyConnection".equals(method.getName())) {
                method.setBody("{return new ProxyConnection($$);}");
                continue;
            }
            if (!"createProxyResultSet".equals(method.getName())) continue;
            method.setBody("{return new ProxyResultSet($$);}");
        }
        return new CtClass[]{ctProxyConnectionClass, ctProxyStatementClass, ctProxyPsStatementClass, ctProxyCsStatementClass, ctProxyDatabaseMetaDataClass, ctProxyResultSetClass, ctProxyObjectFactoryClass};
    }

    private static HashSet findMethodsNotNeedProxy(CtClass baseClass) {
        HashSet<String> notNeedAddProxyMethods = new HashSet<String>(16);
        for (CtMethod ctSuperClassMethod : baseClass.getMethods()) {
            int modifiers = ctSuperClassMethod.getModifiers();
            if ((Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers)) && !Modifier.isFinal((int)modifiers) && !Modifier.isStatic((int)modifiers) && !Modifier.isNative((int)modifiers)) continue;
            notNeedAddProxyMethods.add(ctSuperClassMethod.getName() + ctSuperClassMethod.getSignature());
        }
        return notNeedAddProxyMethods;
    }

    private static void createProxyConnectionClass(ClassPool classPool, CtClass ctConnectionClassProxyClass, CtClass ctConnectionClass, CtClass ctConBaseClass) throws Exception {
        LinkedList linkedList = new LinkedList();
        HashSet notNeedAddProxyMethods = ProxyClassGenerator.findMethodsNotNeedProxy(ctConBaseClass);
        ProxyClassGenerator.resolveInterfaceMethods(ctConnectionClass, linkedList, notNeedAddProxyMethods);
        CtClass ctStatementClass = classPool.get(Statement.class.getName());
        CtClass ctPreparedStatementClass = classPool.get(PreparedStatement.class.getName());
        CtClass ctCallableStatementClass = classPool.get(CallableStatement.class.getName());
        CtClass ctDatabaseMetaDataIntf = classPool.get(DatabaseMetaData.class.getName());
        StringBuilder methodBuffer = new StringBuilder(50);
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctConnectionClassProxyClass, null);
            newCtMethod.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{");
            if (ctMethod.getReturnType() == ctStatementClass) {
                newCtMethod.setModifiers(17);
                methodBuffer.append("return new ProxyStatement(raw." + methodName + "($$),this,p);");
            } else if (ctMethod.getReturnType() == ctPreparedStatementClass) {
                newCtMethod.setModifiers(17);
                methodBuffer.append("return new ProxyPsStatement(raw." + methodName + "($$),this,p);");
            } else if (ctMethod.getReturnType() == ctCallableStatementClass) {
                newCtMethod.setModifiers(17);
                methodBuffer.append("return new ProxyCsStatement(raw." + methodName + "($$),this,p);");
            } else if (ctMethod.getReturnType() == ctDatabaseMetaDataIntf) {
                methodBuffer.append("return new ProxyDatabaseMetaData(raw." + methodName + "($$),p);");
            } else {
                if (methodName.equals("close")) continue;
                if (ctMethod.getReturnType() == CtClass.voidType) {
                    methodBuffer.append("raw." + methodName + "($$);");
                } else {
                    methodBuffer.append("return raw." + methodName + "($$);");
                }
            }
            methodBuffer.append("}");
            newCtMethod.setBody(methodBuffer.toString());
            ctConnectionClassProxyClass.addMethod(newCtMethod);
        }
    }

    private static void createProxyStatementClass(ClassPool classPool, CtClass statementProxyClass, CtClass ctStatementClass, CtClass ctStatementSuperClass) throws Exception {
        LinkedList linkedList = new LinkedList();
        HashSet notNeedAddProxyMethods = ProxyClassGenerator.findMethodsNotNeedProxy(ctStatementSuperClass);
        ProxyClassGenerator.resolveInterfaceMethods(ctStatementClass, linkedList, notNeedAddProxyMethods);
        CtClass ctResultSetClass = classPool.get(ResultSet.class.getName());
        StringBuilder methodBuffer = new StringBuilder(50);
        String rawName = "raw.";
        if ("java.sql.PreparedStatement".equals(ctStatementClass.getName())) {
            rawName = "((PreparedStatement)raw).";
        } else if ("java.sql.CallableStatement".equals(ctStatementClass.getName())) {
            rawName = "((CallableStatement)raw).";
        }
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)statementProxyClass, null);
            newCtMethod.setModifiers(methodName.startsWith("execute") ? 17 : 1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{");
            boolean existsSQLException = ProxyClassGenerator.exitsSQLException(ctMethod.getExceptionTypes());
            if (existsSQLException) {
                methodBuffer.append("  try{");
            }
            if (ctMethod.getReturnType() == CtClass.voidType) {
                if (methodName.startsWith("execute")) {
                    methodBuffer.append("p.commitDirtyInd=!p.curAutoCommit;");
                }
                methodBuffer.append(rawName + methodName + "($$);");
                if (methodName.startsWith("execute")) {
                    methodBuffer.append("p.lastAccessTime=System.currentTimeMillis();");
                }
            } else if (methodName.startsWith("execute")) {
                methodBuffer.append("p.commitDirtyInd=!p.curAutoCommit;");
                methodBuffer.append(ctMethod.getReturnType().getName() + " r=" + rawName + methodName + "($$);");
                methodBuffer.append("p.lastAccessTime=System.currentTimeMillis();");
                if (ctMethod.getReturnType() == ctResultSetClass) {
                    methodBuffer.append("return new ProxyResultSet(r,this,p);");
                } else {
                    methodBuffer.append("return r;");
                }
            } else if (ctMethod.getReturnType() == ctResultSetClass) {
                methodBuffer.append("return new ProxyResultSet(raw." + methodName + "($$),this,p);");
            } else {
                methodBuffer.append("return " + rawName + methodName + "($$);");
            }
            if (existsSQLException) {
                methodBuffer.append("  }catch(SQLException e){ p.checkSQLException(e);throw e;}");
            }
            methodBuffer.append("}");
            newCtMethod.setBody(methodBuffer.toString());
            statementProxyClass.addMethod(newCtMethod);
        }
    }

    private static void createProxyDatabaseMetaDataClass(ClassPool classPool, CtClass ctProxyDatabaseMetaDataClass, CtClass ctDatabaseMetaDataIntf, CtClass ctDatabaseMetaDataSuperClass) throws Exception {
        LinkedList linkedList = new LinkedList();
        HashSet notNeedAddProxyMethods = ProxyClassGenerator.findMethodsNotNeedProxy(ctDatabaseMetaDataSuperClass);
        ProxyClassGenerator.resolveInterfaceMethods(ctDatabaseMetaDataIntf, linkedList, notNeedAddProxyMethods);
        CtClass ctResultSetClass = classPool.get(ResultSet.class.getName());
        StringBuilder methodBuffer = new StringBuilder(40);
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctProxyDatabaseMetaDataClass, null);
            newCtMethod.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{").append("  checkClosed();");
            boolean existsSQLException = ProxyClassGenerator.exitsSQLException(ctMethod.getExceptionTypes());
            if (existsSQLException) {
                methodBuffer.append("  try{");
            }
            if (ctMethod.getReturnType() == ctResultSetClass) {
                methodBuffer.append("return new ProxyResultSet(raw." + methodName + "($$),p);");
            } else if (ctMethod.getReturnType() == CtClass.voidType) {
                methodBuffer.append("raw." + methodName + "($$);");
            } else {
                methodBuffer.append("return raw." + methodName + "($$);");
            }
            if (existsSQLException) {
                methodBuffer.append("  }catch(SQLException e){ p.checkSQLException(e);throw e;}");
            }
            methodBuffer.append("}");
            newCtMethod.setBody(methodBuffer.toString());
            ctProxyDatabaseMetaDataClass.addMethod(newCtMethod);
        }
    }

    private static void createProxyResultSetClass(CtClass ctResultSetClassProxyClass, CtClass ctResultSetClass, CtClass ctResultSetClassSuperClass) throws Exception {
        LinkedList linkedList = new LinkedList();
        HashSet notNeedAddProxyMethods = ProxyClassGenerator.findMethodsNotNeedProxy(ctResultSetClassSuperClass);
        ProxyClassGenerator.resolveInterfaceMethods(ctResultSetClass, linkedList, notNeedAddProxyMethods);
        StringBuilder methodBuffer = new StringBuilder(25);
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethodm = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctResultSetClassProxyClass, null);
            newCtMethodm.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{");
            if (methodName.equals("close")) continue;
            boolean existsSQLException = ProxyClassGenerator.exitsSQLException(ctMethod.getExceptionTypes());
            if (existsSQLException) {
                methodBuffer.append("  try{");
            }
            if (methodName.startsWith("insert") || methodName.startsWith("update") || methodName.startsWith("delete")) {
                if (ctMethod.getReturnType() == CtClass.voidType) {
                    methodBuffer.append("raw." + methodName + "($$);").append(" p.updateAccessTime();");
                } else {
                    methodBuffer.append(ctMethod.getReturnType().getName() + " r=raw." + methodName + "($$);").append(" p.updateAccessTime();").append(" return r;");
                }
            } else if (ctMethod.getReturnType() == CtClass.voidType) {
                methodBuffer.append("raw." + methodName + "($$);");
            } else {
                methodBuffer.append("return raw." + methodName + "($$);");
            }
            if (existsSQLException) {
                methodBuffer.append("  }catch(SQLException e){ p.checkSQLException(e);throw e;}");
            }
            methodBuffer.append("}");
            newCtMethodm.setBody(methodBuffer.toString());
            ctResultSetClassProxyClass.addMethod(newCtMethodm);
        }
    }

    private static boolean exitsSQLException(CtClass[] exceptionTypes) throws Exception {
        if (exceptionTypes == null || exceptionTypes.length == 0) {
            return false;
        }
        for (CtClass exceptionClass : exceptionTypes) {
            if (!"java.sql.SQLException".equals(exceptionClass.getName())) continue;
            return true;
        }
        return false;
    }
}

