/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyBaseWrapper;
import cn.beecp.pool.ProxyStatementBase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

abstract class ProxyResultSetBase
extends ProxyBaseWrapper
implements ResultSet {
    protected ResultSet raw;
    private ProxyStatementBase owner;

    public ProxyResultSetBase(ResultSet raw, PooledConnection p) {
        super(p);
        this.raw = raw;
    }

    public ProxyResultSetBase(ResultSet raw, ProxyStatementBase o, PooledConnection p) {
        super(p);
        o.setOpenResultSet(this);
        this.raw = raw;
        this.owner = o;
    }

    boolean containsRaw(ResultSet raw) {
        return this.raw == raw;
    }

    public Statement getStatement() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("No operations allowed after resultSet closed");
        }
        return this.owner;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public final void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        try {
            this.isClosed = true;
            this.raw.close();
        }
        finally {
            this.raw = PoolStaticCenter.CLOSED_RSLT;
            if (this.owner != null) {
                this.owner.removeOpenResultSet(this);
            }
        }
    }
}

