/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.BeeConnectionPool;
import cn.beecp.BeeConnectionPoolJmxBean;
import cn.beecp.BeeConnectionPoolMonitorVo;
import cn.beecp.BeeDataSourceConfig;
import cn.beecp.RawConnectionFactory;
import cn.beecp.RawXaConnectionFactory;
import cn.beecp.pool.FastConnectionPoolMonitorVo;
import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.exception.ConnectionGetForbiddenException;
import cn.beecp.pool.exception.PoolCreateFailedException;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.XAConnection;

public final class RawConnectionPool
implements BeeConnectionPool,
BeeConnectionPoolJmxBean {
    private static final AtomicInteger poolNameIndex = new AtomicInteger(1);
    private static final FastConnectionPoolMonitorVo monitorVo = new FastConnectionPoolMonitorVo();
    private String poolName = "";
    private String poolMode = "";
    private long defaultMaxWait;
    private Semaphore borrowSemaphore;
    private BeeDataSourceConfig poolConfig;
    private boolean isRawXaConnFactory;
    private RawConnectionFactory rawConnFactory;
    private RawXaConnectionFactory rawXaConnFactory;
    private AtomicInteger poolState = new AtomicInteger(0);

    public void init(BeeDataSourceConfig config) throws SQLException {
        this.poolConfig = config;
        this.defaultMaxWait = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getMaxWait());
        this.borrowSemaphore = new Semaphore(this.poolConfig.getBorrowSemaphoreSize(), this.poolConfig.isFairMode());
        this.poolName = !PoolStaticCenter.isBlank(config.getPoolName()) ? config.getPoolName() : "RawPool-" + poolNameIndex.getAndIncrement();
        this.poolMode = this.poolConfig.isFairMode() ? "fair" : "compete";
        Object rawFactory = this.poolConfig.getConnectionFactory();
        if (rawFactory instanceof RawXaConnectionFactory) {
            this.isRawXaConnFactory = true;
            this.rawXaConnFactory = (RawXaConnectionFactory)rawFactory;
        } else if (rawFactory instanceof RawConnectionFactory) {
            this.rawConnFactory = (RawConnectionFactory)rawFactory;
        } else {
            throw new PoolCreateFailedException("Invalid connection factory");
        }
        this.registerJMX();
        PoolStaticCenter.CommonLog.info("BeeCP({})has been startup{init size:{},max size:{}, size:{},mode:{},max wait:{}ms},driver:{}}", new Object[]{this.poolName, 0, 0, this.poolConfig.getBorrowSemaphoreSize(), this.poolMode, 0, this.poolConfig.getDriverClassName()});
        this.poolState.set(2);
    }

    public Connection getConnection() throws SQLException {
        try {
            if (this.poolState.get() != 2) {
                throw new ConnectionGetForbiddenException("Access forbidden,connection pool was closed or in clearing");
            }
            if (this.borrowSemaphore.tryAcquire(this.defaultMaxWait, TimeUnit.NANOSECONDS)) {
                if (this.isRawXaConnFactory) {
                    Connection connection = this.rawXaConnFactory.create().getConnection();
                    return connection;
                }
                Connection connection = this.rawConnFactory.create();
                return connection;
            }
            try {
                throw new SQLException("Request timeout");
            }
            catch (InterruptedException e) {
                throw new SQLException("Request interrupted");
            }
        }
        finally {
            this.borrowSemaphore.release();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XAConnection getXAConnection() throws SQLException {
        try {
            if (this.poolState.get() != 2) {
                throw new ConnectionGetForbiddenException("Access forbidden,connection pool was closed or in clearing");
            }
            if (!this.borrowSemaphore.tryAcquire(this.defaultMaxWait, TimeUnit.NANOSECONDS)) throw new SQLException("Request timeout");
            if (this.isRawXaConnFactory) {
                XAConnection xAConnection = this.rawXaConnFactory.create();
                return xAConnection;
            }
            try {
                throw new SQLException("Not support");
            }
            catch (InterruptedException e) {
                throw new SQLException("Request interrupted");
            }
        }
        finally {
            this.borrowSemaphore.release();
        }
    }

    public void recycle(PooledConnection p) {
    }

    public void close() {
        if (this.poolState.get() == 3) {
            return;
        }
        do {
            if (!this.poolState.compareAndSet(2, 3)) continue;
            this.unregisterJMX();
            break;
        } while (this.poolState.get() != 3);
    }

    public boolean isClosed() {
        return this.poolState.get() == 3;
    }

    public void clear(boolean force) {
    }

    public void clear(boolean force, BeeDataSourceConfig config) {
    }

    public int getTotalSize() {
        return 0;
    }

    public int getIdleSize() {
        return 0;
    }

    public int getUsingSize() {
        return 0;
    }

    public int getSemaphoreAcquiredSize() {
        return this.poolConfig.getBorrowSemaphoreSize() - this.borrowSemaphore.availablePermits();
    }

    public int getSemaphoreWaitingSize() {
        return this.borrowSemaphore.getQueueLength();
    }

    public int getTransferWaitingSize() {
        return 0;
    }

    public void setPrintRuntimeLog(boolean enabledDebug) {
    }

    public BeeConnectionPoolMonitorVo getPoolMonitorVo() {
        int totSize = this.getTotalSize();
        int idleSize = this.getIdleSize();
        monitorVo.setPoolName(this.poolName);
        monitorVo.setPoolMode(this.poolMode);
        monitorVo.setPoolState(this.poolState.get());
        monitorVo.setPoolMaxSize(this.poolConfig.getMaxActive());
        monitorVo.setIdleSize(idleSize);
        monitorVo.setUsingSize(totSize - idleSize);
        monitorVo.setSemaphoreWaitingSize(this.getSemaphoreWaitingSize());
        monitorVo.setTransferWaitingSize(this.getTransferWaitingSize());
        return monitorVo;
    }

    private void registerJMX() {
        if (this.poolConfig.isEnableJmx()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName poolRegName = new ObjectName("cn.beecp.pool.RawConnectionPool:type=BeeCP(" + this.poolName + ")");
                if (!mBeanServer.isRegistered(poolRegName)) {
                    mBeanServer.registerMBean(this, poolRegName);
                    PoolStaticCenter.CommonLog.info("Registered BeeCP({})as jmx-bean", (Object)this.poolName);
                } else {
                    PoolStaticCenter.CommonLog.error("Jmx-name BeeCP({})has been exist in jmx server", (Object)this.poolName);
                }
            }
            catch (Exception e) {
                PoolStaticCenter.CommonLog.warn("Failed to register pool jmx-bean", (Throwable)e);
            }
            try {
                ObjectName configRegName = new ObjectName("cn.beecp.BeeDataSourceConfig:type=BeeCP(" + this.poolName + ")-config");
                if (!mBeanServer.isRegistered(configRegName)) {
                    mBeanServer.registerMBean(this.poolConfig, configRegName);
                    PoolStaticCenter.CommonLog.info("Registered BeeCP({})config as jmx-bean", (Object)this.poolName);
                } else {
                    PoolStaticCenter.CommonLog.error("Pool BeeCP({})config has been exist in jmx server", (Object)this.poolName);
                }
            }
            catch (Exception e) {
                PoolStaticCenter.CommonLog.warn("Failed to register pool jmx-bean", (Throwable)e);
            }
        }
    }

    private void unregisterJMX() {
        if (this.poolConfig.isEnableJmx()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName poolRegName = new ObjectName("cn.beecp.pool.RawConnectionPool:type=BeeCP(" + this.poolName + ")");
                if (mBeanServer.isRegistered(poolRegName)) {
                    mBeanServer.unregisterMBean(poolRegName);
                }
            }
            catch (Exception e) {
                PoolStaticCenter.CommonLog.warn("Failed to unregister pool jmx-bean", (Throwable)e);
            }
            try {
                ObjectName configRegName = new ObjectName("cn.beecp.BeeDataSourceConfig:type=BeeCP(" + this.poolName + ")-config");
                if (mBeanServer.isRegistered(configRegName)) {
                    mBeanServer.unregisterMBean(configRegName);
                }
            }
            catch (Exception e) {
                PoolStaticCenter.CommonLog.warn("Failed to unregister pool jmx-bean", (Throwable)e);
            }
        }
    }
}

