/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.stone.beecp.BeeConnectionPool;
import org.stone.beecp.BeeConnectionPoolMonitorVo;
import org.stone.beecp.BeeDataSourceConfig;
import org.stone.beecp.BeeDataSourceConfigException;
import org.stone.beecp.pool.ConnectionPoolStatics;
import org.stone.beecp.pool.exception.ConnectionGetInterruptedException;
import org.stone.beecp.pool.exception.ConnectionGetTimeoutException;
import org.stone.beecp.pool.exception.PoolCreateFailedException;
import org.stone.beecp.pool.exception.PoolNotCreatedException;
import org.stone.tools.BeanUtil;

public class BeeDataSource
extends BeeDataSourceConfig
implements DataSource,
XADataSource {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private long maxWaitNanos = TimeUnit.SECONDS.toNanos(8L);
    private BeeConnectionPool pool;
    private CommonDataSource subDs;
    private boolean ready;
    private SQLException cause;

    public BeeDataSource() {
    }

    public BeeDataSource(String driver, String url, String user, String password) {
        super(driver, url, user, password);
    }

    public BeeDataSource(BeeDataSourceConfig config) {
        try {
            config.copyTo(this);
            BeeDataSource.createPool(this);
            this.maxWaitNanos = TimeUnit.MILLISECONDS.toNanos(config.getMaxWait());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void createPool(BeeDataSource ds) throws SQLException {
        try {
            Class<?> poolClass = Class.forName(ds.getPoolImplementClassName());
            BeeConnectionPool pool = (BeeConnectionPool)BeanUtil.createClassInstance(poolClass, BeeConnectionPool.class, "pool");
            pool.init(ds);
            ds.pool = pool;
            Object connectionFactory = ds.getConnectionFactory();
            ds.subDs = connectionFactory instanceof CommonDataSource ? (CommonDataSource)connectionFactory : ConnectionPoolStatics.Dummy_CommonDataSource;
            ds.ready = true;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PoolCreateFailedException("Failed to create a pool with class:" + ds.getPoolImplementClassName(), e);
        }
    }

    @Override
    public final Connection getConnection() throws SQLException {
        if (this.ready) {
            return this.pool.getConnection();
        }
        return this.createPoolByLock().getConnection();
    }

    @Override
    public final XAConnection getXAConnection() throws SQLException {
        if (this.ready) {
            return this.pool.getXAConnection();
        }
        return this.createPoolByLock().getXAConnection();
    }

    /*
     * Unable to fully structure code
     */
    private BeeConnectionPool createPoolByLock() throws SQLException {
        if (!this.lock.isWriteLocked() && this.lock.writeLock().tryLock()) {
            try {
                if (this.ready) ** GOTO lbl20
                this.cause = null;
                BeeDataSource.createPool(this);
            }
            catch (SQLException e) {
                this.cause = e;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        } else {
            try {
                if (!this.readLock.tryLock(this.maxWaitNanos, TimeUnit.NANOSECONDS)) {
                    throw new ConnectionGetTimeoutException("Timeout on waiting for pool ready");
                }
            }
            catch (InterruptedException e) {
                throw new ConnectionGetInterruptedException("An interruption occurred while waiting for pool ready");
            }
            this.readLock.unlock();
        }
lbl20:
        // 4 sources

        if (this.cause != null) {
            throw this.cause;
        }
        return this.pool;
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        BeanUtil.CommonLog.warn("getConnection (user,password) ignores authentication - returning default connection");
        return this.getConnection();
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        BeanUtil.CommonLog.warn("getXAConnection (user,password) ignores authentication - returning default XAConnection");
        return this.getXAConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.subDs != null ? this.subDs.getLogWriter() : null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        if (this.subDs != null) {
            this.subDs.setLogWriter(out);
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.subDs != null ? this.subDs.getParentLogger() : null;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.subDs != null ? this.subDs.getLoginTimeout() : 0;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        if (this.subDs != null) {
            this.subDs.setLoginTimeout(seconds);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz != null && clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz != null && clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new SQLException("The wrapper object was not an instance of " + clazz);
    }

    public boolean isClosed() {
        return this.pool == null || this.pool.isClosed();
    }

    public void close() {
        if (this.pool != null) {
            this.pool.close();
        }
    }

    @Override
    public void setMaxWait(long maxWait) {
        if (maxWait > 0L) {
            super.setMaxWait(maxWait);
            this.maxWaitNanos = TimeUnit.MILLISECONDS.toNanos(maxWait);
        }
    }

    @Override
    public void setPrintRuntimeLog(boolean printRuntimeLog) {
        if (this.pool != null) {
            this.pool.setPrintRuntimeLog(printRuntimeLog);
        }
    }

    public BeeConnectionPoolMonitorVo getPoolMonitorVo() throws SQLException {
        this.checkPool();
        return this.pool.getPoolMonitorVo();
    }

    public int getConnectionCreatingCount() throws SQLException {
        this.checkPool();
        return this.pool.getConnectionCreatingCount();
    }

    public int getConnectionCreatingTimeoutCount() throws SQLException {
        this.checkPool();
        return this.pool.getConnectionCreatingTimeoutCount();
    }

    public Thread[] interruptConnectionCreating(boolean interruptTimeout) throws SQLException {
        this.checkPool();
        return this.pool.interruptConnectionCreating(interruptTimeout);
    }

    public void clear(boolean forceCloseUsing) throws SQLException {
        this.checkPool();
        this.pool.clear(forceCloseUsing);
    }

    public void clear(boolean forceCloseUsing, BeeDataSourceConfig config) throws SQLException {
        this.checkPool();
        if (config == null) {
            throw new BeeDataSourceConfigException("Pool configuration object can't be null");
        }
        this.pool.clear(forceCloseUsing, config);
        config.copyTo(this);
        this.maxWaitNanos = TimeUnit.MILLISECONDS.toNanos(config.getMaxWait());
    }

    private void checkPool() throws SQLException {
        if (this.pool == null) {
            throw new PoolNotCreatedException("Pool not be created");
        }
    }
}

