/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.stone.beecp.BeeConnectionFactory;
import org.stone.beecp.BeeConnectionPredicate;
import org.stone.beecp.BeeDataSourceConfigException;
import org.stone.beecp.BeeDataSourceConfigMBean;
import org.stone.beecp.BeeJdbcLinkInfoDecoder;
import org.stone.beecp.BeeTransactionIsolationLevels;
import org.stone.beecp.BeeXaConnectionFactory;
import org.stone.beecp.pool.ConnectionFactoryByDriver;
import org.stone.beecp.pool.ConnectionFactoryByDriverDs;
import org.stone.beecp.pool.ConnectionPoolStatics;
import org.stone.beecp.pool.FastConnectionPool;
import org.stone.beecp.pool.XaConnectionFactoryByDriverDs;
import org.stone.tools.BeanUtil;
import org.stone.tools.CommonUtil;
import org.stone.tools.exception.BeanException;

public class BeeDataSourceConfig
implements BeeDataSourceConfigMBean {
    private static final AtomicInteger PoolNameIndex = new AtomicInteger(1);
    private static final List<String> DefaultExclusionList = Arrays.asList("username", "password", "jdbcUrl", "user", "url");
    private final Map<String, Object> connectProperties = new HashMap<String, Object>();
    private String username;
    private String password;
    private String jdbcUrl;
    private String driverClassName;
    private String poolName;
    private boolean fairMode;
    private int initialSize;
    private boolean asyncCreateInitConnection;
    private int maxActive = Math.min(Math.max(10, CommonUtil.NCPU), 50);
    private int borrowSemaphoreSize = Math.min(this.maxActive / 2, CommonUtil.NCPU);
    private long maxWait = TimeUnit.SECONDS.toMillis(8L);
    private long idleTimeout = TimeUnit.MINUTES.toMillis(3L);
    private long holdTimeout;
    private String aliveTestSql = "SELECT 1";
    private int aliveTestTimeout = 3;
    private long aliveAssumeTime = 500L;
    private long timerCheckInterval = TimeUnit.MINUTES.toMillis(3L);
    private boolean forceCloseUsingOnClear;
    private long delayTimeForNextClear = 3000L;
    private List<Integer> sqlExceptionCodeList;
    private List<String> sqlExceptionStateList;
    private String defaultCatalog;
    private String defaultSchema;
    private Boolean defaultReadOnly;
    private Boolean defaultAutoCommit;
    private Integer defaultTransactionIsolationCode;
    private String defaultTransactionIsolationName;
    private boolean enableThreadLocal = true;
    private boolean enableDefaultOnCatalog = true;
    private boolean enableDefaultOnSchema = true;
    private boolean enableDefaultOnReadOnly = true;
    private boolean enableDefaultOnAutoCommit = true;
    private boolean enableDefaultOnTransactionIsolation = true;
    private boolean forceDirtyOnSchemaAfterSet;
    private boolean forceDirtyOnCatalogAfterSet;
    private Object connectionFactory;
    private Class connectionFactoryClass;
    private String connectionFactoryClassName;
    private BeeConnectionPredicate evictPredicate;
    private Class<? extends BeeConnectionPredicate> evictPredicateClass;
    private String evictPredicateClassName;
    private BeeJdbcLinkInfoDecoder jdbcLinkInfoDecoder;
    private Class<? extends BeeJdbcLinkInfoDecoder> jdbcLinkInfoDecoderClass;
    private String jdbcLinkInfoDecoderClassName;
    private boolean enableJmx;
    private boolean printRuntimeLog;
    private boolean printConfigInfo;
    private List<String> configPrintExclusionList = new ArrayList<String>(DefaultExclusionList);
    private String poolImplementClassName = FastConnectionPool.class.getName();

    public BeeDataSourceConfig() {
    }

    public BeeDataSourceConfig(File propertiesFile) {
        this.loadFromPropertiesFile(propertiesFile);
    }

    public BeeDataSourceConfig(String propertiesFileName) {
        this.loadFromPropertiesFile(propertiesFileName);
    }

    public BeeDataSourceConfig(Properties configProperties) {
        this.loadFromProperties(configProperties);
    }

    public BeeDataSourceConfig(String driver, String url, String user, String password) {
        this.jdbcUrl = CommonUtil.trimString(url);
        this.username = CommonUtil.trimString(user);
        this.password = CommonUtil.trimString(password);
        this.driverClassName = CommonUtil.trimString(driver);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = CommonUtil.trimString(username);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = CommonUtil.trimString(password);
    }

    @Override
    public String getUrl() {
        return this.jdbcUrl;
    }

    public void setUrl(String jdbcUrl) {
        this.jdbcUrl = CommonUtil.trimString(jdbcUrl);
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = CommonUtil.trimString(jdbcUrl);
    }

    @Override
    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = CommonUtil.trimString(driverClassName);
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = CommonUtil.trimString(poolName);
    }

    @Override
    public boolean isFairMode() {
        return this.fairMode;
    }

    public void setFairMode(boolean fairMode) {
        this.fairMode = fairMode;
    }

    @Override
    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        if (initialSize >= 0) {
            this.initialSize = initialSize;
        }
    }

    public boolean isAsyncCreateInitConnection() {
        return this.asyncCreateInitConnection;
    }

    public void setAsyncCreateInitConnection(boolean asyncCreateInitConnection) {
        this.asyncCreateInitConnection = asyncCreateInitConnection;
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        if (maxActive > 0) {
            this.maxActive = maxActive;
            this.borrowSemaphoreSize = maxActive > 1 ? Math.min(maxActive / 2, CommonUtil.NCPU) : 1;
        }
    }

    @Override
    public int getBorrowSemaphoreSize() {
        return this.borrowSemaphoreSize;
    }

    public void setBorrowSemaphoreSize(int borrowSemaphoreSize) {
        if (borrowSemaphoreSize > 0) {
            this.borrowSemaphoreSize = borrowSemaphoreSize;
        }
    }

    @Override
    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        if (maxWait > 0L) {
            this.maxWait = maxWait;
        }
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        if (idleTimeout > 0L) {
            this.idleTimeout = idleTimeout;
        }
    }

    @Override
    public long getHoldTimeout() {
        return this.holdTimeout;
    }

    public void setHoldTimeout(long holdTimeout) {
        if (holdTimeout >= 0L) {
            this.holdTimeout = holdTimeout;
        }
    }

    @Override
    public String getAliveTestSql() {
        return this.aliveTestSql;
    }

    public void setAliveTestSql(String aliveTestSql) {
        if (CommonUtil.isNotBlank(aliveTestSql)) {
            this.aliveTestSql = CommonUtil.trimString(aliveTestSql);
        }
    }

    @Override
    public int getAliveTestTimeout() {
        return this.aliveTestTimeout;
    }

    public void setAliveTestTimeout(int aliveTestTimeout) {
        if (aliveTestTimeout >= 0) {
            this.aliveTestTimeout = aliveTestTimeout;
        }
    }

    @Override
    public long getAliveAssumeTime() {
        return this.aliveAssumeTime;
    }

    public void setAliveAssumeTime(long aliveAssumeTime) {
        if (aliveAssumeTime >= 0L) {
            this.aliveAssumeTime = aliveAssumeTime;
        }
    }

    @Override
    public long getTimerCheckInterval() {
        return this.timerCheckInterval;
    }

    public void setTimerCheckInterval(long timerCheckInterval) {
        if (timerCheckInterval > 0L) {
            this.timerCheckInterval = timerCheckInterval;
        }
    }

    @Override
    public boolean isForceCloseUsingOnClear() {
        return this.forceCloseUsingOnClear;
    }

    public void setForceCloseUsingOnClear(boolean forceCloseUsingOnClear) {
        this.forceCloseUsingOnClear = forceCloseUsingOnClear;
    }

    @Override
    public long getDelayTimeForNextClear() {
        return this.delayTimeForNextClear;
    }

    public void setDelayTimeForNextClear(long delayTimeForNextClear) {
        if (delayTimeForNextClear >= 0L) {
            this.delayTimeForNextClear = delayTimeForNextClear;
        }
    }

    public List<Integer> getSqlExceptionCodeList() {
        return this.sqlExceptionCodeList;
    }

    public void addSqlExceptionCode(int code) {
        if (this.sqlExceptionCodeList == null) {
            this.sqlExceptionCodeList = new ArrayList<Integer>(1);
        }
        if (!this.sqlExceptionCodeList.contains(code)) {
            this.sqlExceptionCodeList.add(code);
        }
    }

    public void removeSqlExceptionCode(int code) {
        if (this.sqlExceptionCodeList != null) {
            this.sqlExceptionCodeList.remove((Object)code);
        }
    }

    public List<String> getSqlExceptionStateList() {
        return this.sqlExceptionStateList;
    }

    public void addSqlExceptionState(String state) {
        if (this.sqlExceptionStateList == null) {
            this.sqlExceptionStateList = new ArrayList<String>(1);
        }
        if (!this.sqlExceptionStateList.contains(state)) {
            this.sqlExceptionStateList.add(state);
        }
    }

    public void removeSqlExceptionState(String state) {
        if (this.sqlExceptionStateList != null) {
            this.sqlExceptionStateList.remove(state);
        }
    }

    @Override
    public String getPoolImplementClassName() {
        return this.poolImplementClassName;
    }

    public void setPoolImplementClassName(String poolImplementClassName) {
        if (CommonUtil.isNotBlank(poolImplementClassName)) {
            this.poolImplementClassName = CommonUtil.trimString(poolImplementClassName);
        }
    }

    @Override
    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public boolean isPrintRuntimeLog() {
        return this.printRuntimeLog;
    }

    public void setPrintRuntimeLog(boolean printRuntimeLog) {
        this.printRuntimeLog = printRuntimeLog;
    }

    public boolean isPrintConfigInfo() {
        return this.printConfigInfo;
    }

    public void setPrintConfigInfo(boolean printConfigInfo) {
        this.printConfigInfo = printConfigInfo;
    }

    public void clearAllConfigPrintExclusion() {
        this.configPrintExclusionList.clear();
    }

    public void addConfigPrintExclusion(String fieldName) {
        if (!this.configPrintExclusionList.contains(fieldName)) {
            this.configPrintExclusionList.add(fieldName);
        }
    }

    public boolean removeConfigPrintExclusion(String fieldName) {
        return this.configPrintExclusionList.remove(fieldName);
    }

    public boolean existConfigPrintExclusion(String fieldName) {
        return this.configPrintExclusionList.contains(fieldName);
    }

    public boolean isEnableThreadLocal() {
        return this.enableThreadLocal;
    }

    public void setEnableThreadLocal(boolean enableThreadLocal) {
        this.enableThreadLocal = enableThreadLocal;
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = CommonUtil.trimString(defaultCatalog);
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = CommonUtil.trimString(defaultSchema);
    }

    @Override
    public Boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    @Override
    public Boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    @Override
    public Integer getDefaultTransactionIsolationCode() {
        return this.defaultTransactionIsolationCode;
    }

    public void setDefaultTransactionIsolationCode(Integer transactionIsolationCode) {
        this.defaultTransactionIsolationCode = transactionIsolationCode;
    }

    @Override
    public String getDefaultTransactionIsolationName() {
        return this.defaultTransactionIsolationName;
    }

    public void setDefaultTransactionIsolationName(String transactionIsolationName) {
        String transactionIsolationNameTemp = CommonUtil.trimString(transactionIsolationName);
        this.defaultTransactionIsolationCode = BeeTransactionIsolationLevels.getTransactionIsolationCode(transactionIsolationNameTemp);
        if (this.defaultTransactionIsolationCode == null) {
            throw new BeeDataSourceConfigException("Invalid transaction isolation name:" + transactionIsolationNameTemp + ", value is one of[" + "0,2,1,4,8" + "]");
        }
        this.defaultTransactionIsolationName = transactionIsolationNameTemp;
    }

    public boolean isEnableDefaultOnCatalog() {
        return this.enableDefaultOnCatalog;
    }

    public void setEnableDefaultOnCatalog(boolean enableDefaultOnCatalog) {
        this.enableDefaultOnCatalog = enableDefaultOnCatalog;
    }

    public boolean isEnableDefaultOnSchema() {
        return this.enableDefaultOnSchema;
    }

    public void setEnableDefaultOnSchema(boolean enableDefaultOnSchema) {
        this.enableDefaultOnSchema = enableDefaultOnSchema;
    }

    public boolean isEnableDefaultOnReadOnly() {
        return this.enableDefaultOnReadOnly;
    }

    public void setEnableDefaultOnReadOnly(boolean enableDefaultOnReadOnly) {
        this.enableDefaultOnReadOnly = enableDefaultOnReadOnly;
    }

    public boolean isEnableDefaultOnAutoCommit() {
        return this.enableDefaultOnAutoCommit;
    }

    public void setEnableDefaultOnAutoCommit(boolean enableDefaultOnAutoCommit) {
        this.enableDefaultOnAutoCommit = enableDefaultOnAutoCommit;
    }

    public boolean isEnableDefaultOnTransactionIsolation() {
        return this.enableDefaultOnTransactionIsolation;
    }

    public void setEnableDefaultOnTransactionIsolation(boolean enableDefaultOnTransactionIsolation) {
        this.enableDefaultOnTransactionIsolation = enableDefaultOnTransactionIsolation;
    }

    public boolean isForceDirtyOnSchemaAfterSet() {
        return this.forceDirtyOnSchemaAfterSet;
    }

    public void setForceDirtyOnSchemaAfterSet(boolean forceDirtyOnSchemaAfterSet) {
        this.forceDirtyOnSchemaAfterSet = forceDirtyOnSchemaAfterSet;
    }

    public boolean isForceDirtyOnCatalogAfterSet() {
        return this.forceDirtyOnCatalogAfterSet;
    }

    public void setForceDirtyOnCatalogAfterSet(boolean forceDirtyOnCatalogAfterSet) {
        this.forceDirtyOnCatalogAfterSet = forceDirtyOnCatalogAfterSet;
    }

    public Object getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(BeeConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public void setXaConnectionFactory(BeeXaConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public Class getConnectionFactoryClass() {
        return this.connectionFactoryClass;
    }

    public void setConnectionFactoryClass(Class connectionFactoryClass) {
        this.connectionFactoryClass = connectionFactoryClass;
    }

    @Override
    public String getConnectionFactoryClassName() {
        return this.connectionFactoryClassName;
    }

    public void setConnectionFactoryClassName(String connectionFactoryClassName) {
        this.connectionFactoryClassName = CommonUtil.trimString(connectionFactoryClassName);
    }

    public Class<? extends BeeConnectionPredicate> getEvictPredicateClass() {
        return this.evictPredicateClass;
    }

    public void setEvictPredicateClass(Class<? extends BeeConnectionPredicate> evictPredicateClass) {
        this.evictPredicateClass = evictPredicateClass;
    }

    public String getEvictPredicateClassName() {
        return this.evictPredicateClassName;
    }

    public void setEvictPredicateClassName(String evictPredicateClassName) {
        this.evictPredicateClassName = evictPredicateClassName;
    }

    public BeeConnectionPredicate getEvictPredicate() {
        return this.evictPredicate;
    }

    public void setEvictPredicate(BeeConnectionPredicate evictPredicate) {
        this.evictPredicate = evictPredicate;
    }

    public Class<? extends BeeJdbcLinkInfoDecoder> getJdbcLinkInfoDecoderClass() {
        return this.jdbcLinkInfoDecoderClass;
    }

    public void setJdbcLinkInfoDecoderClass(Class<? extends BeeJdbcLinkInfoDecoder> jdbcLinkInfoDecoderClass) {
        this.jdbcLinkInfoDecoderClass = jdbcLinkInfoDecoderClass;
    }

    public String getJdbcLinkInfoDecoderClassName() {
        return this.jdbcLinkInfoDecoderClassName;
    }

    public void setJdbcLinkInfoDecoderClassName(String jdbcLinkInfoDecoderClassName) {
        this.jdbcLinkInfoDecoderClassName = jdbcLinkInfoDecoderClassName;
    }

    public BeeJdbcLinkInfoDecoder getJdbcLinkInfoDecoder() {
        return this.jdbcLinkInfoDecoder;
    }

    public void setJdbcLinkInfoDecoder(BeeJdbcLinkInfoDecoder jdbcLinkInfoDecoder) {
        this.jdbcLinkInfoDecoder = jdbcLinkInfoDecoder;
    }

    public Object getConnectProperty(String key) {
        return this.connectProperties.get(key);
    }

    public Object removeConnectProperty(String key) {
        return this.connectProperties.remove(key);
    }

    public void addConnectProperty(String key, Object value) {
        if (CommonUtil.isNotBlank(key) && value != null) {
            this.connectProperties.put(key, value);
        }
    }

    public void addConnectProperty(String connectPropertyText) {
        if (CommonUtil.isNotBlank(connectPropertyText)) {
            for (String attribute : connectPropertyText.split("&")) {
                String[] pair = attribute.split("=");
                if (pair.length == 2) {
                    this.addConnectProperty(pair[0].trim(), pair[1].trim());
                    continue;
                }
                pair = attribute.split(":");
                if (pair.length != 2) continue;
                this.addConnectProperty(pair[0].trim(), pair[1].trim());
            }
        }
    }

    public void loadFromPropertiesFile(String filename) {
        if (CommonUtil.isBlank(filename)) {
            throw new IllegalArgumentException("Configuration file name can't be null or empty");
        }
        String fileLowerCaseName = filename.toLowerCase(Locale.US);
        if (!fileLowerCaseName.endsWith(".properties")) {
            throw new IllegalArgumentException("Configuration file name file must be end with '.properties'");
        }
        if (fileLowerCaseName.startsWith("cp:")) {
            String cpFileName = fileLowerCaseName.substring("cp:".length());
            Properties fileProperties = CommonUtil.loadPropertiesFromClassPathFile(cpFileName);
            this.loadFromProperties(fileProperties);
        } else if (fileLowerCaseName.startsWith("classpath:")) {
            String cpFileName = fileLowerCaseName.substring("classpath:".length());
            Properties fileProperties = CommonUtil.loadPropertiesFromClassPathFile(cpFileName);
            this.loadFromProperties(fileProperties);
        } else {
            File file = new File(filename);
            if (!file.exists()) {
                throw new IllegalArgumentException("Not found configuration file:" + filename);
            }
            if (!file.isFile()) {
                throw new IllegalArgumentException("Target object is a valid configuration file:" + filename);
            }
            this.loadFromPropertiesFile(file);
        }
    }

    public void loadFromPropertiesFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Configuration properties file can't be null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Configuration properties file not found:" + file);
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Target object is not a valid file");
        }
        if (!file.getAbsolutePath().toLowerCase(Locale.US).endsWith(".properties")) {
            throw new IllegalArgumentException("Target file is not a properties file");
        }
        InputStream stream = null;
        try {
            stream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            Properties configProperties = new Properties();
            configProperties.load(stream);
            this.loadFromProperties(configProperties);
        }
        catch (BeeDataSourceConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BeeDataSourceConfigException("Failed to load configuration properties file:" + file, e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable e) {
                    BeanUtil.CommonLog.warn("Failed to close inputStream of configuration properties file:{}", (Object)file, (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromProperties(Properties configProperties) {
        HashMap<String, String> setValueMap;
        if (configProperties == null || configProperties.isEmpty()) {
            throw new IllegalArgumentException("Configuration properties can't be null or empty");
        }
        Properties properties = configProperties;
        synchronized (properties) {
            Set<Map.Entry<Object, Object>> entrySet = configProperties.entrySet();
            setValueMap = new HashMap<String, String>(entrySet.size());
            for (Map.Entry<Object, Object> entry : entrySet) {
                setValueMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        String connectPropertiesText = (String)setValueMap.remove("connectProperties");
        String connectPropertiesSize = (String)setValueMap.remove("connectProperties.size");
        String sqlExceptionCode = (String)setValueMap.remove("sqlExceptionCodeList");
        String sqlExceptionState = (String)setValueMap.remove("sqlExceptionStateList");
        String exclusionListText = (String)setValueMap.remove("configPrintExclusionList");
        try {
            BeanUtil.setPropertiesValue(this, setValueMap);
        }
        catch (BeanException e) {
            throw new BeeDataSourceConfigException(e.getMessage(), e);
        }
        this.addConnectProperty(connectPropertiesText);
        if (CommonUtil.isNotBlank(connectPropertiesSize)) {
            int size = Integer.parseInt(connectPropertiesSize.trim());
            for (int i = 1; i <= size; ++i) {
                this.addConnectProperty(BeanUtil.getPropertyValue(setValueMap, "connectProperties." + i));
            }
        }
        if (CommonUtil.isNotBlank(sqlExceptionCode)) {
            for (String code : sqlExceptionCode.trim().split(",")) {
                try {
                    this.addSqlExceptionCode(Integer.parseInt(code));
                }
                catch (NumberFormatException e) {
                    throw new BeeDataSourceConfigException(code + " is not a valid SQLException error code");
                }
            }
        }
        if (CommonUtil.isNotBlank(sqlExceptionState)) {
            for (String state : sqlExceptionState.trim().split(",")) {
                this.addSqlExceptionState(state);
            }
        }
        if (CommonUtil.isNotBlank(exclusionListText)) {
            this.clearAllConfigPrintExclusion();
            for (String exclusion : exclusionListText.trim().split(",")) {
                this.addConfigPrintExclusion(exclusion);
            }
        }
    }

    public BeeDataSourceConfig check() throws SQLException {
        if (this.initialSize > this.maxActive) {
            throw new BeeDataSourceConfigException("initialSize must not be greater than maxActive");
        }
        if (!this.aliveTestSql.toUpperCase(Locale.US).startsWith("SELECT ")) {
            throw new BeeDataSourceConfigException("Alive test sql must be start with 'select '");
        }
        Object connectionFactory = this.createConnectionFactory();
        BeeConnectionPredicate predicate = this.createConnectionEvictPredicate();
        BeeDataSourceConfig checkedConfig = new BeeDataSourceConfig();
        this.copyTo(checkedConfig);
        if ((this.connectionFactory != null || this.connectionFactoryClass != null || CommonUtil.isNotBlank(this.connectionFactoryClassName)) && (CommonUtil.isNotBlank(this.username) || CommonUtil.isNotBlank(this.password) || CommonUtil.isNotBlank(this.jdbcUrl) || CommonUtil.isNotBlank(this.driverClassName))) {
            BeanUtil.CommonLog.info("BeeCP({})configured jdbc link info abandoned according that a connection factory has been existed", (Object)"...");
            checkedConfig.username = null;
            checkedConfig.password = null;
            checkedConfig.jdbcUrl = null;
            checkedConfig.driverClassName = null;
        }
        this.connectionFactory = connectionFactory;
        checkedConfig.connectionFactory = connectionFactory;
        checkedConfig.evictPredicate = predicate;
        if (CommonUtil.isBlank(checkedConfig.poolName)) {
            checkedConfig.poolName = "FastPool-" + PoolNameIndex.getAndIncrement();
        }
        if (checkedConfig.printConfigInfo) {
            this.printConfiguration(checkedConfig);
        }
        return checkedConfig;
    }

    void copyTo(BeeDataSourceConfig config) {
        String fieldName = null;
        try {
            block14: for (Field field : BeeDataSourceConfig.class.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                switch (fieldName = field.getName()) {
                    case "configPrintExclusionList": {
                        config.configPrintExclusionList = new ArrayList<String>(this.configPrintExclusionList);
                        continue block14;
                    }
                    case "connectProperties": {
                        for (Map.Entry<String, Object> entry : this.connectProperties.entrySet()) {
                            config.addConnectProperty(entry.getKey(), entry.getValue());
                        }
                        continue block14;
                    }
                    case "sqlExceptionCodeList": {
                        if (this.sqlExceptionCodeList == null || this.sqlExceptionCodeList.isEmpty()) continue block14;
                        config.sqlExceptionCodeList = new ArrayList<Integer>(this.sqlExceptionCodeList);
                        continue block14;
                    }
                    case "sqlExceptionStateList": {
                        if (this.sqlExceptionStateList == null || this.sqlExceptionStateList.isEmpty()) continue block14;
                        config.sqlExceptionStateList = new ArrayList<String>(this.sqlExceptionStateList);
                        continue block14;
                    }
                    default: {
                        field.set(config, field.get(this));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BeeDataSourceConfigException("Failed to copy field[" + fieldName + "]", e);
        }
    }

    private BeeJdbcLinkInfoDecoder createJdbcLinkInfoDecoder() {
        if (this.jdbcLinkInfoDecoder != null) {
            return this.jdbcLinkInfoDecoder;
        }
        if (this.jdbcLinkInfoDecoderClass != null || CommonUtil.isNotBlank(this.jdbcLinkInfoDecoderClassName)) {
            Class<BeeJdbcLinkInfoDecoder> decoderClass = null;
            try {
                decoderClass = this.jdbcLinkInfoDecoderClass != null ? this.jdbcLinkInfoDecoderClass : Class.forName(this.jdbcLinkInfoDecoderClassName);
                return (BeeJdbcLinkInfoDecoder)BeanUtil.createClassInstance(decoderClass, BeeJdbcLinkInfoDecoder.class, "jdbc link info decoder");
            }
            catch (ClassNotFoundException e) {
                throw new BeeDataSourceConfigException("Failed to create jdbc link info decoder with class[" + this.jdbcLinkInfoDecoderClassName + "]", e);
            }
            catch (BeeDataSourceConfigException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new BeeDataSourceConfigException("Failed to create sql exception predication with class[" + decoderClass + "]", e);
            }
        }
        return null;
    }

    private Object createConnectionFactory() throws SQLException {
        if (this.connectionFactory != null) {
            return this.connectionFactory;
        }
        Properties jdbcLinkInfoProperties = this.getJdbcLinkInfoProperties();
        BeeJdbcLinkInfoDecoder jdbcLinkInfoDecoder = this.createJdbcLinkInfoDecoder();
        if (this.connectionFactoryClass == null && CommonUtil.isBlank(this.connectionFactoryClassName)) {
            Driver driver;
            String url = jdbcLinkInfoProperties.getProperty("url");
            if (CommonUtil.isBlank(url)) {
                throw new BeeDataSourceConfigException("jdbcUrl can't be null");
            }
            if (jdbcLinkInfoDecoder != null) {
                url = jdbcLinkInfoDecoder.decodeUrl(url);
            }
            if (CommonUtil.isNotBlank(this.driverClassName)) {
                driver = ConnectionPoolStatics.loadDriver(this.driverClassName);
                if (!driver.acceptsURL(url)) {
                    throw new BeeDataSourceConfigException("jdbcUrl(" + url + ")can not match configured driver[" + this.driverClassName + "]");
                }
            } else {
                driver = DriverManager.getDriver(url);
            }
            String username = jdbcLinkInfoProperties.getProperty("user");
            String password = jdbcLinkInfoProperties.getProperty("password");
            if (jdbcLinkInfoDecoder != null) {
                if (CommonUtil.isNotBlank(username)) {
                    username = jdbcLinkInfoDecoder.decodeUsername(username);
                }
                if (CommonUtil.isNotBlank(password)) {
                    password = jdbcLinkInfoDecoder.decodePassword(password);
                }
            }
            Properties localConnectProperties = new Properties();
            localConnectProperties.putAll(this.connectProperties);
            if (CommonUtil.isNotBlank(username)) {
                localConnectProperties.setProperty("user", username);
                if (CommonUtil.isNotBlank(password)) {
                    localConnectProperties.setProperty("password", password);
                }
            }
            return new ConnectionFactoryByDriver(url, driver, localConnectProperties);
        }
        Class<?> conFactClass = null;
        try {
            conFactClass = this.connectionFactoryClass != null ? this.connectionFactoryClass : Class.forName(this.connectionFactoryClassName);
            Class[] parentClasses = new Class[]{BeeConnectionFactory.class, BeeXaConnectionFactory.class, DataSource.class, XADataSource.class};
            Object factory = BeanUtil.createClassInstance(conFactClass, parentClasses, "connection factory");
            HashMap<String, Object> localConnectProperties = new HashMap<String, Object>(this.connectProperties);
            String url = jdbcLinkInfoProperties.getProperty("url");
            String username = jdbcLinkInfoProperties.getProperty("user");
            String password = jdbcLinkInfoProperties.getProperty("password");
            if (jdbcLinkInfoDecoder != null) {
                if (CommonUtil.isNotBlank(url)) {
                    url = jdbcLinkInfoDecoder.decodeUrl(url);
                }
                if (CommonUtil.isNotBlank(username)) {
                    username = jdbcLinkInfoDecoder.decodeUsername(username);
                }
                if (CommonUtil.isNotBlank(password)) {
                    password = jdbcLinkInfoDecoder.decodePassword(password);
                }
            }
            if (CommonUtil.isNotBlank(url)) {
                localConnectProperties.put("url", url);
                localConnectProperties.put("URL", url);
                localConnectProperties.put("jdbcUrl", url);
            }
            if (CommonUtil.isNotBlank(username)) {
                localConnectProperties.put("user", username);
                if (CommonUtil.isNotBlank(password)) {
                    localConnectProperties.put("password", password);
                }
            }
            BeanUtil.setPropertiesValue(factory, localConnectProperties);
            if (factory instanceof BeeConnectionFactory || factory instanceof BeeXaConnectionFactory) {
                return factory;
            }
            if (factory instanceof XADataSource) {
                return new XaConnectionFactoryByDriverDs((XADataSource)factory, username, password);
            }
            return new ConnectionFactoryByDriverDs((DataSource)factory, username, password);
        }
        catch (ClassNotFoundException e) {
            throw new BeeDataSourceConfigException("Not found connection factory class[" + conFactClass + "]", e);
        }
        catch (BeeDataSourceConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BeeDataSourceConfigException("Failed to create connection factory with class[" + conFactClass + "]", e);
        }
    }

    private Properties getJdbcLinkInfoProperties() {
        String url = this.jdbcUrl;
        String username = this.username;
        String password = this.password;
        if (CommonUtil.isBlank(url)) {
            url = (String)this.connectProperties.get("url");
            if (CommonUtil.isBlank(url)) {
                url = (String)this.connectProperties.get("URL");
            }
            if (CommonUtil.isBlank(url)) {
                url = (String)this.connectProperties.get("jdbcUrl");
            }
            if (CommonUtil.isNotBlank(url)) {
                username = (String)this.connectProperties.get("user");
                password = (String)this.connectProperties.get("password");
            } else {
                url = System.getProperty("beecp.url");
                if (CommonUtil.isBlank(url)) {
                    url = System.getProperty("beecp.URL");
                }
                if (CommonUtil.isBlank(url)) {
                    url = System.getProperty("beecp.jdbcUrl");
                }
                if (CommonUtil.isNotBlank(url)) {
                    username = System.getProperty("beecp.user");
                    password = System.getProperty("beecp.password");
                }
            }
        }
        Properties jdbcLinkInfoProperties = new Properties();
        if (CommonUtil.isNotBlank(url)) {
            jdbcLinkInfoProperties.put("url", url);
        }
        if (CommonUtil.isNotBlank(username)) {
            jdbcLinkInfoProperties.put("user", username);
        }
        if (CommonUtil.isNotBlank(password)) {
            jdbcLinkInfoProperties.put("password", password);
        }
        return jdbcLinkInfoProperties;
    }

    private BeeConnectionPredicate createConnectionEvictPredicate() throws BeeDataSourceConfigException {
        if (this.evictPredicate != null) {
            return this.evictPredicate;
        }
        if (this.evictPredicateClass != null || CommonUtil.isNotBlank(this.evictPredicateClassName)) {
            Class<BeeConnectionPredicate> predicationClass = null;
            try {
                predicationClass = this.evictPredicateClass != null ? this.evictPredicateClass : Class.forName(this.evictPredicateClassName);
                return (BeeConnectionPredicate)BeanUtil.createClassInstance(predicationClass, BeeConnectionPredicate.class, "sql exception predicate");
            }
            catch (ClassNotFoundException e) {
                throw new BeeDataSourceConfigException("Not found sql exception predicate class[" + this.evictPredicateClassName + "]", e);
            }
            catch (BeeDataSourceConfigException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new BeeDataSourceConfigException("Failed to create sql exception predicate with class[" + predicationClass + "]", e);
            }
        }
        return null;
    }

    private void printConfiguration(BeeDataSourceConfig config) {
        String poolName = config.poolName;
        List<String> exclusionList = config.configPrintExclusionList;
        BeanUtil.CommonLog.info("................................................BeeCP({})configuration[start]................................................", (Object)poolName);
        try {
            for (Field field : BeeDataSourceConfig.class.getDeclaredFields()) {
                String fieldName = field.getName();
                if (Modifier.isStatic(field.getModifiers())) continue;
                if (exclusionList.contains(fieldName)) {
                    if ("connectProperties".equals(fieldName)) {
                        for (Map.Entry<String, Object> entry : config.connectProperties.entrySet()) {
                            BeanUtil.CommonLog.debug("BeeCP({}).connectProperties.{}={}", new Object[]{poolName, entry.getKey(), entry.getValue()});
                        }
                        continue;
                    }
                    BeanUtil.CommonLog.debug("BeeCP({}).{}={}", new Object[]{poolName, fieldName, field.get(config)});
                    continue;
                }
                if ("connectProperties".equals(fieldName)) {
                    for (Map.Entry<String, Object> entry : config.connectProperties.entrySet()) {
                        if (exclusionList.contains(entry.getKey())) continue;
                        BeanUtil.CommonLog.info("BeeCP({}).connectProperties.{}={}", new Object[]{poolName, entry.getKey(), entry.getValue()});
                    }
                    continue;
                }
                BeanUtil.CommonLog.info("BeeCP({}).{}={}", new Object[]{poolName, fieldName, field.get(config)});
            }
        }
        catch (Throwable e) {
            BeanUtil.CommonLog.warn("BeeCP({})failed to print configuration", (Object)poolName, (Object)e);
        }
        BeanUtil.CommonLog.info("................................................BeeCP({})configuration[end]................................................", (Object)poolName);
    }
}

