/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import org.stone.beecp.BeeConnectionFactory;
import org.stone.tools.CommonUtil;

public final class ConnectionFactoryByDriverDs
implements BeeConnectionFactory,
CommonDataSource {
    private final String username;
    private final String password;
    private final boolean useUsername;
    private final DataSource driverDataSource;

    public ConnectionFactoryByDriverDs(DataSource driverDataSource, String username, String password) {
        this.driverDataSource = driverDataSource;
        this.username = username;
        this.password = password;
        this.useUsername = CommonUtil.isNotBlank(username);
    }

    @Override
    public Connection create() throws SQLException {
        return this.useUsername ? this.driverDataSource.getConnection(this.username, this.password) : this.driverDataSource.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.driverDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.driverDataSource.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.driverDataSource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.driverDataSource.setLoginTimeout(seconds);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.driverDataSource.getParentLogger();
    }
}

