/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;
import javax.sql.XAConnection;
import org.stone.beecp.BeeDataSourceConfigException;
import org.stone.beecp.pool.PooledConnection;
import org.stone.beecp.pool.ProxyConnection;
import org.stone.beecp.pool.ProxyConnectionBase;
import org.stone.beecp.pool.ProxyResultSet;
import org.stone.beecp.pool.ProxyStatementBase;
import org.stone.beecp.pool.exception.TestSqlExecFailedException;
import org.stone.tools.BeanUtil;

public final class ConnectionPoolStatics {
    public static final String CONFIG_TM_JNDI = "transactionManagerName";
    public static final String CONFIG_CONNECT_PROP = "connectProperties";
    public static final String CONFIG_CONNECT_PROP_SIZE = "connectProperties.size";
    public static final String CONFIG_CONNECT_PROP_KEY_PREFIX = "connectProperties.";
    public static final String CONFIG_SQL_EXCEPTION_CODE = "sqlExceptionCodeList";
    public static final String CONFIG_SQL_EXCEPTION_STATE = "sqlExceptionStateList";
    public static final String CONFIG_CONFIG_PRINT_EXCLUSION_LIST = "configPrintExclusionList";
    public static final CommonDataSource Dummy_CommonDataSource = new CommonDataSource(){

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new SQLFeatureNotSupportedException("Not supported");
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new SQLFeatureNotSupportedException("Not supported");
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            throw new SQLFeatureNotSupportedException("Not supported");
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            throw new SQLFeatureNotSupportedException("Not supported");
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException("Not supported");
        }
    };
    static final int POOL_NEW = 0;
    static final int POOL_STARTING = 1;
    static final int POOL_READY = 2;
    static final int POOL_CLOSING = 3;
    static final int POOL_CLOSED = 4;
    static final int POOL_CLEARING = 5;
    static final int CON_CLOSED = 0;
    static final int CON_IDLE = 1;
    static final int CON_CREATING = 2;
    static final int CON_USING = 3;
    static final int THREAD_WORKING = 0;
    static final int THREAD_WAITING = 1;
    static final int THREAD_EXIT = 2;
    static final int PS_AUTO = 0;
    static final int PS_TRANS = 1;
    static final int PS_READONLY = 2;
    static final int PS_CATALOG = 3;
    static final int PS_SCHEMA = 4;
    static final int PS_NETWORK = 5;
    static final String DESC_RM_INIT = "init";
    static final String DESC_RM_BAD = "bad";
    static final String DESC_RM_ABORT = "abort";
    static final String DESC_RM_IDLE = "idle";
    static final String DESC_RM_CLOSED = "closed";
    static final String DESC_RM_CLEAR = "clear";
    static final String DESC_RM_DESTROY = "destroy";
    static final Connection CLOSED_CON = (Connection)Proxy.newProxyInstance(ConnectionPoolStatics.class.getClassLoader(), new Class[]{Connection.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("toString".equals(method.getName())) {
                return "Connection has been closed";
            }
            throw new SQLException("No operations allowed after connection closed");
        }
    });
    static final CallableStatement CLOSED_CSTM = (CallableStatement)Proxy.newProxyInstance(ConnectionPoolStatics.class.getClassLoader(), new Class[]{CallableStatement.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("toString".equals(method.getName())) {
                return "Statement has been closed";
            }
            throw new SQLException("No operations allowed after statement closed");
        }
    });
    static final ResultSet CLOSED_RSLT = (ResultSet)Proxy.newProxyInstance(ConnectionPoolStatics.class.getClassLoader(), new Class[]{ResultSet.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("toString".equals(method.getName())) {
                return "ResultSet has been closed";
            }
            throw new SQLException("No operations allowed after resultSet closed");
        }
    });

    public static void oclose(ResultSet r) {
        try {
            r.close();
        }
        catch (Throwable e) {
            BeanUtil.CommonLog.debug("Warning:Error at closing resultSet", e);
        }
    }

    public static void oclose(Statement s) {
        try {
            s.close();
        }
        catch (Throwable e) {
            BeanUtil.CommonLog.debug("Warning:Error at closing statement", e);
        }
    }

    public static void oclose(Connection c) {
        try {
            c.close();
        }
        catch (Throwable e) {
            BeanUtil.CommonLog.debug("Warning:Error at closing connection", e);
        }
    }

    public static void oclose(XAConnection c) {
        try {
            c.close();
        }
        catch (Throwable e) {
            BeanUtil.CommonLog.debug("Warning:Error at closing connection", e);
        }
    }

    static ProxyConnectionBase createProxyConnection(PooledConnection pooledConnection) throws SQLException {
        return new ProxyConnection(pooledConnection);
    }

    static ResultSet createProxyResultSet(ResultSet resultSet, ProxyStatementBase proxyStatementBase, PooledConnection pooledConnection) throws SQLException {
        return new ProxyResultSet(resultSet, proxyStatementBase, pooledConnection);
    }

    public static Driver loadDriver(String driverClassName) throws BeeDataSourceConfigException {
        try {
            return (Driver)Class.forName(driverClassName).newInstance();
        }
        catch (Throwable e) {
            throw new BeeDataSourceConfigException("Failed to create jdbc driver by class:" + driverClassName, e);
        }
    }

    static void checkJdbcProxyClass() throws ClassNotFoundException {
        String[] classNames = new String[]{"org.stone.beecp.pool.Borrower", "org.stone.beecp.pool.PooledConnection", "org.stone.beecp.pool.ProxyConnection", "org.stone.beecp.pool.ProxyStatement", "org.stone.beecp.pool.ProxyPsStatement", "org.stone.beecp.pool.ProxyCsStatement", "org.stone.beecp.pool.ProxyDatabaseMetaData", "org.stone.beecp.pool.ProxyResultSet"};
        ClassLoader loader = ConnectionPoolStatics.class.getClassLoader();
        for (String className : classNames) {
            Class.forName(className, true, loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean validateTestSql(String poolName, Connection rawCon, String testSql, int validTestTimeout, boolean isDefaultAutoCommit) throws SQLException {
        boolean changed = false;
        Statement st = null;
        try {
            if (isDefaultAutoCommit) {
                try {
                    rawCon.setAutoCommit(false);
                    changed = true;
                }
                catch (Throwable e) {
                    throw new SQLException("Failed to setAutoCommit(false)", e);
                }
            }
            st = rawCon.createStatement();
            boolean supportQueryTimeout = true;
            try {
                st.setQueryTimeout(validTestTimeout);
            }
            catch (Throwable e) {
                supportQueryTimeout = false;
                BeanUtil.CommonLog.warn("BeeCP({})driver not support 'queryTimeout'", (Object)poolName, (Object)e);
            }
            try {
                st.execute(testSql);
            }
            catch (Throwable e) {
                throw new TestSqlExecFailedException("Invalid test sql:" + testSql, e);
            }
            finally {
                rawCon.rollback();
            }
            boolean bl = supportQueryTimeout;
            return bl;
        }
        finally {
            if (st != null) {
                ConnectionPoolStatics.oclose(st);
            }
            if (changed) {
                rawCon.setAutoCommit(true);
            }
        }
    }
}

