/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stone.beecp.BeeConnectionFactory;
import org.stone.beecp.BeeConnectionPool;
import org.stone.beecp.BeeConnectionPoolMonitorVo;
import org.stone.beecp.BeeDataSourceConfig;
import org.stone.beecp.BeeDataSourceConfigException;
import org.stone.beecp.BeeXaConnectionFactory;
import org.stone.beecp.pool.Borrower;
import org.stone.beecp.pool.ConnectionCreatingInfo;
import org.stone.beecp.pool.ConnectionPoolStatics;
import org.stone.beecp.pool.FastConnectionPoolMBean;
import org.stone.beecp.pool.FastConnectionPoolMonitorVo;
import org.stone.beecp.pool.PooledConnection;
import org.stone.beecp.pool.PooledConnectionAliveTest;
import org.stone.beecp.pool.PooledConnectionTransferPolicy;
import org.stone.beecp.pool.ProxyConnectionBase;
import org.stone.beecp.pool.XaProxyConnection;
import org.stone.beecp.pool.XaProxyResource;
import org.stone.beecp.pool.XaResourceLocalImpl;
import org.stone.beecp.pool.exception.ConnectionCreateException;
import org.stone.beecp.pool.exception.ConnectionGetException;
import org.stone.beecp.pool.exception.ConnectionGetForbiddenException;
import org.stone.beecp.pool.exception.ConnectionGetInterruptedException;
import org.stone.beecp.pool.exception.ConnectionGetTimeoutException;
import org.stone.beecp.pool.exception.PoolInClearingException;
import org.stone.beecp.pool.exception.PoolInitializeFailedException;
import org.stone.tools.CommonUtil;
import org.stone.tools.atomic.IntegerFieldUpdaterImpl;
import org.stone.tools.atomic.ReferenceFieldUpdaterImpl;
import org.stone.tools.extension.InterruptionReentrantReadWriteLock;
import org.stone.tools.extension.InterruptionSemaphore;

public final class FastConnectionPool
extends Thread
implements BeeConnectionPool,
FastConnectionPoolMBean,
PooledConnectionAliveTest,
PooledConnectionTransferPolicy {
    static final Logger Log = LoggerFactory.getLogger(FastConnectionPool.class);
    private static final AtomicIntegerFieldUpdater<PooledConnection> ConStUpd = IntegerFieldUpdaterImpl.newUpdater(PooledConnection.class, "state");
    private static final AtomicReferenceFieldUpdater<Borrower, Object> BorrowStUpd = ReferenceFieldUpdaterImpl.newUpdater(Borrower.class, Object.class, "state");
    private static final AtomicIntegerFieldUpdater<FastConnectionPool> PoolStateUpd = IntegerFieldUpdaterImpl.newUpdater(FastConnectionPool.class, "poolState");
    private static final AtomicIntegerFieldUpdater<FastConnectionPool> ServantStateUpd = IntegerFieldUpdaterImpl.newUpdater(FastConnectionPool.class, "servantState");
    private static final AtomicIntegerFieldUpdater<FastConnectionPool> ServantTryCountUpd = IntegerFieldUpdaterImpl.newUpdater(FastConnectionPool.class, "servantTryCount");
    String poolName;
    volatile int poolState;
    volatile int idleScanState;
    volatile int servantState;
    volatile int servantTryCount;
    BeeDataSourceConfig poolConfig;
    PooledConnection[] connectionArray;
    ConcurrentLinkedQueue<Borrower> waitQueue;
    private String poolMode;
    private String poolHostIP;
    private long poolThreadId;
    private String poolThreadName;
    private boolean isFairMode;
    private boolean isCompeteMode;
    private int semaphoreSize;
    private InterruptionSemaphore semaphore;
    private long maxWaitNs;
    private long idleTimeoutMs;
    private long holdTimeoutMs;
    private boolean supportHoldTimeout;
    private long aliveAssumeTimeMs;
    private int aliveTestTimeout;
    private long delayTimeForNextClearNs;
    private int stateCodeOnRelease;
    private int connectionArrayLen;
    private boolean connectionArrayInitialized;
    private InterruptionReentrantReadWriteLock connectionArrayInitLock;
    private PooledConnectionTransferPolicy transferPolicy;
    private boolean isRawXaConnFactory;
    private BeeConnectionFactory rawConnFactory;
    private BeeXaConnectionFactory rawXaConnFactory;
    private PooledConnectionAliveTest conValidTest;
    private ThreadPoolExecutor networkTimeoutExecutor;
    private IdleTimeoutScanThread idleScanThread;
    private boolean enableThreadLocal;
    private ThreadLocal<WeakReference<Borrower>> threadLocal;
    private FastConnectionPoolMonitorVo monitorVo;
    private ConnectionPoolHook exitHook;
    private boolean printRuntimeLog;

    @Override
    public void init(BeeDataSourceConfig config) throws SQLException {
        if (config == null) {
            throw new PoolInitializeFailedException("Pool initialization configuration can't be null");
        }
        if (PoolStateUpd.compareAndSet(this, 0, 1)) {
            try {
                ConnectionPoolStatics.checkJdbcProxyClass();
                this.poolConfig = config.check();
                this.startup(1);
                this.poolState = 2;
            }
            catch (Throwable e) {
                Log.info("BeeCP({})initialized failed", (Object)this.poolName, (Object)e);
                this.poolState = 0;
                throw e instanceof SQLException ? (SQLException)e : new PoolInitializeFailedException(e);
            }
        } else {
            throw new PoolInitializeFailedException("Pool has already initialized or in initializing");
        }
    }

    private void startup(int poolWorkState) throws SQLException {
        String poolInitInfo;
        String driverClassNameOrFactoryName;
        this.poolName = this.poolConfig.getPoolName();
        Log.info("BeeCP({})starting up....", (Object)this.poolName);
        Object rawFactory = this.poolConfig.getConnectionFactory();
        if (rawFactory instanceof BeeXaConnectionFactory) {
            this.isRawXaConnFactory = true;
            this.rawXaConnFactory = (BeeXaConnectionFactory)rawFactory;
        } else {
            this.rawConnFactory = (BeeConnectionFactory)rawFactory;
        }
        this.connectionArrayInitialized = false;
        this.connectionArrayLen = this.poolConfig.getMaxActive();
        this.connectionArray = new PooledConnection[this.connectionArrayLen];
        this.connectionArrayInitLock = new InterruptionReentrantReadWriteLock();
        for (int i = 0; i < this.connectionArrayLen; ++i) {
            this.connectionArray[i] = new PooledConnection(this, i);
        }
        this.printRuntimeLog = this.poolConfig.isPrintRuntimeLog();
        this.maxWaitNs = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getMaxWait());
        int initialSize = this.poolConfig.getInitialSize();
        if (initialSize > 0 && !this.poolConfig.isAsyncCreateInitConnection()) {
            this.createInitConnections(this.poolConfig.getInitialSize(), true);
        }
        if (this.poolConfig.isFairMode()) {
            this.poolMode = "fair";
            this.isFairMode = true;
            this.transferPolicy = new FairTransferPolicy();
        } else {
            this.poolMode = "compete";
            this.isCompeteMode = true;
            this.transferPolicy = this;
        }
        this.stateCodeOnRelease = this.transferPolicy.getStateCodeOnRelease();
        this.idleTimeoutMs = this.poolConfig.getIdleTimeout();
        this.holdTimeoutMs = this.poolConfig.getHoldTimeout();
        this.supportHoldTimeout = this.holdTimeoutMs > 0L;
        this.aliveAssumeTimeMs = this.poolConfig.getAliveAssumeTime();
        this.aliveTestTimeout = this.poolConfig.getAliveTestTimeout();
        this.delayTimeForNextClearNs = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getDelayTimeForNextClear());
        this.semaphoreSize = this.poolConfig.getBorrowSemaphoreSize();
        this.enableThreadLocal = this.poolConfig.isEnableThreadLocal();
        this.semaphore = new InterruptionSemaphore(this.semaphoreSize, this.isFairMode);
        if (this.threadLocal != null) {
            this.threadLocal = null;
        }
        if (this.enableThreadLocal) {
            this.threadLocal = new BorrowerThreadLocal();
        }
        if (1 == poolWorkState) {
            this.waitQueue = new ConcurrentLinkedQueue();
            this.servantTryCount = 0;
            this.servantState = 0;
            this.idleScanState = 0;
            this.idleScanThread = new IdleTimeoutScanThread(this);
            this.monitorVo = this.createPoolMonitorVo();
            this.exitHook = new ConnectionPoolHook(this);
            Runtime.getRuntime().addShutdownHook(this.exitHook);
            this.registerJmx();
            this.setDaemon(true);
            this.setName("BeeCP(" + this.poolName + ")-asyncAdd");
            this.start();
            this.idleScanThread.setDaemon(true);
            this.idleScanThread.setName("BeeCP(" + this.poolName + ")-idleScanner");
            this.idleScanThread.start();
        }
        if (initialSize > 0 && this.poolConfig.isAsyncCreateInitConnection()) {
            new PoolInitAsyncCreateThread(this).start();
        }
        if (CommonUtil.isNotBlank(this.poolConfig.getDriverClassName())) {
            driverClassNameOrFactoryName = this.poolConfig.getDriverClassName();
            poolInitInfo = "BeeCP({})has startup{mode:{},init size:{},max size:{},semaphore size:{},max wait:{}ms,driver:{}}";
        } else {
            driverClassNameOrFactoryName = rawFactory.getClass().getName();
            poolInitInfo = "BeeCP({})has startup{mode:{},init size:{},max size:{},semaphore size:{},max wait:{}ms,factory:{}}";
        }
        Log.info(poolInitInfo, new Object[]{this.poolName, this.poolMode, initialSize, this.connectionArrayLen, this.semaphoreSize, this.poolConfig.getMaxWait(), driverClassNameOrFactoryName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createInitConnections(int initSize, boolean syn) throws SQLException {
        boolean isWriteLocked;
        ReentrantReadWriteLock.WriteLock writeLock = this.connectionArrayInitLock.writeLock();
        boolean bl = isWriteLocked = !syn && !this.connectionArrayInitialized && !this.connectionArrayInitLock.isWriteLocked() && writeLock.tryLock();
        if (syn || isWriteLocked) {
            int index;
            try {
                for (index = 0; index < initSize; ++index) {
                    PooledConnection p = this.connectionArray[index];
                    p.state = 2;
                    this.fillRawConnection(p, 1);
                }
            }
            catch (SQLException e) {
                if (syn) {
                    for (int i = 0; i < index; ++i) {
                        this.connectionArray[i].onRemove("init");
                    }
                    throw e;
                }
                Log.warn("Failed to create initial connections by async mode", (Throwable)e);
            }
            finally {
                if (isWriteLocked) {
                    writeLock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PooledConnection searchOrCreate() throws SQLException {
        if (!this.connectionArrayInitialized) {
            ReentrantReadWriteLock.ReadLock readLock = this.connectionArrayInitLock.readLock();
            ReentrantReadWriteLock.WriteLock writeLock = this.connectionArrayInitLock.writeLock();
            try {
                if (!this.connectionArrayInitLock.isWriteLocked() && writeLock.tryLock()) {
                    try {
                        PooledConnection p = this.connectionArray[0];
                        p.state = 2;
                        PooledConnection pooledConnection = this.fillRawConnection(p, 3);
                        return pooledConnection;
                    }
                    finally {
                        writeLock.unlock();
                    }
                }
                if (!readLock.tryLock(this.maxWaitNs, TimeUnit.NANOSECONDS)) throw new ConnectionGetTimeoutException("Waited timeout on pool lock");
                readLock.unlock();
                if (!this.connectionArrayInitialized) {
                    throw new ConnectionGetException("Waited failed on pool lock for initialization ready on first connection by another");
                }
            }
            catch (InterruptedException e) {
                throw new ConnectionGetInterruptedException("An interruption occurred while waiting on pool lock");
            }
        }
        PooledConnection[] pooledConnectionArray = this.connectionArray;
        int n = pooledConnectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PooledConnection p = pooledConnectionArray[n2];
            int state = p.state;
            if (state == 1) {
                if (ConStUpd.compareAndSet(p, 1, 3)) {
                    if (this.testOnBorrow(p)) {
                        return p;
                    }
                } else if (p.state == 0 && ConStUpd.compareAndSet(p, 0, 2)) {
                    return this.fillRawConnection(p, 3);
                }
            } else if (state == 0 && ConStUpd.compareAndSet(p, 0, 2)) {
                return this.fillRawConnection(p, 3);
            }
            ++n2;
        }
        return null;
    }

    private PooledConnection fillRawConnection(PooledConnection p, int state) throws SQLException {
        if (this.printRuntimeLog) {
            Log.info("BeeCP({}))begin to create a raw connection", (Object)this.poolName);
        }
        Connection rawConn = null;
        XAConnection rawXaConn = null;
        XAResource rawXaRes = null;
        p.creatingInfo = new ConnectionCreatingInfo();
        try {
            if (this.isRawXaConnFactory) {
                rawXaConn = this.rawXaConnFactory.create();
                if (rawXaConn == null) {
                    if (Thread.interrupted()) {
                        throw new ConnectionGetInterruptedException("An interruption occurred when created an XA connection");
                    }
                    throw new ConnectionCreateException("A unknown error occurred when created an XA connection");
                }
                rawConn = rawXaConn.getConnection();
                rawXaRes = rawXaConn.getXAResource();
            } else {
                rawConn = this.rawConnFactory.create();
                if (rawConn == null) {
                    if (Thread.interrupted()) {
                        throw new ConnectionGetInterruptedException("An interruption occurred when created a connection");
                    }
                    throw new ConnectionCreateException("A unknown error occurred when created a connection");
                }
            }
            if (this.connectionArrayInitialized) {
                p.setRawConnection(state, rawConn, rawXaRes);
            } else {
                this.initPooledConnectionArray(rawConn);
                p.setRawConnection2(state, rawConn, rawXaRes);
                this.connectionArrayInitialized = true;
            }
            if (this.printRuntimeLog) {
                Log.info("BeeCP({}))created a new connection:{} to fill pooled connection:{}", new Object[]{this.poolName, rawConn, p});
            }
            return p;
        }
        catch (Throwable e) {
            p.creatingInfo = null;
            p.state = 0;
            if (rawConn != null) {
                ConnectionPoolStatics.oclose(rawConn);
            } else if (rawXaConn != null) {
                ConnectionPoolStatics.oclose(rawXaConn);
            }
            throw e instanceof SQLException ? (SQLException)e : new ConnectionCreateException(e);
        }
    }

    private void initPooledConnectionArray(Connection firstConn) throws SQLException {
        boolean supportNetworkTimeoutInd;
        int defaultNetworkTimeout;
        boolean isEnableDefaultOnSchema;
        String defaultSchema;
        boolean isEnableDefaultOnCatalog;
        String defaultCatalog;
        boolean isEnableDefaultOnReadOnly;
        Boolean defaultReadOnly;
        boolean isEnableDefaultOnTransactionIsolation;
        Integer defaultTransactionIsolation;
        boolean isEnableDefaultOnAutoCommit;
        Boolean defaultAutoCommit;
        block69: {
            boolean supportIsValid;
            block68: {
                block67: {
                    block65: {
                        block63: {
                            block61: {
                                block59: {
                                    defaultAutoCommit = this.poolConfig.isDefaultAutoCommit();
                                    isEnableDefaultOnAutoCommit = this.poolConfig.isEnableDefaultOnAutoCommit();
                                    if (isEnableDefaultOnAutoCommit) {
                                        block58: {
                                            if (defaultAutoCommit == null) {
                                                try {
                                                    defaultAutoCommit = firstConn.getAutoCommit();
                                                }
                                                catch (Throwable e) {
                                                    if (!this.printRuntimeLog) break block58;
                                                    Log.warn("BeeCP({})failed to get value of auto-commit property from first connection object", (Object)this.poolName, (Object)e);
                                                }
                                            }
                                        }
                                        if (defaultAutoCommit == null) {
                                            defaultAutoCommit = Boolean.TRUE;
                                            if (this.printRuntimeLog) {
                                                Log.warn("BeeCP({})assign {} as default value of auto-commit property for connections", (Object)this.poolName, (Object)true);
                                            }
                                        }
                                        try {
                                            firstConn.setAutoCommit(defaultAutoCommit);
                                        }
                                        catch (Throwable e) {
                                            isEnableDefaultOnAutoCommit = false;
                                            if (this.printRuntimeLog) {
                                                Log.warn("BeeCP({})failed to set default value({}) of auto-commit property on first connection object", new Object[]{this.poolName, defaultAutoCommit, e});
                                            }
                                            break block59;
                                        }
                                    }
                                    if (defaultAutoCommit == null) {
                                        defaultAutoCommit = Boolean.TRUE;
                                    }
                                }
                                defaultTransactionIsolation = this.poolConfig.getDefaultTransactionIsolationCode();
                                isEnableDefaultOnTransactionIsolation = this.poolConfig.isEnableDefaultOnTransactionIsolation();
                                if (isEnableDefaultOnTransactionIsolation) {
                                    block60: {
                                        if (defaultTransactionIsolation == null) {
                                            try {
                                                defaultTransactionIsolation = firstConn.getTransactionIsolation();
                                            }
                                            catch (Throwable e) {
                                                if (!this.printRuntimeLog) break block60;
                                                Log.warn("BeeCP({})failed to get value of transaction-isolation property from first connection object", (Object)this.poolName, (Object)e);
                                            }
                                        }
                                    }
                                    if (defaultTransactionIsolation == null) {
                                        defaultTransactionIsolation = 2;
                                        if (this.printRuntimeLog) {
                                            Log.warn("BeeCP({})assign {} as default value of transaction-isolation property for connections", (Object)this.poolName, (Object)defaultTransactionIsolation);
                                        }
                                    }
                                    try {
                                        firstConn.setTransactionIsolation(defaultTransactionIsolation);
                                    }
                                    catch (Throwable e) {
                                        isEnableDefaultOnTransactionIsolation = false;
                                        if (this.printRuntimeLog) {
                                            Log.warn("BeeCP({})failed to set default value({}) of transaction-isolation property on first connection object", new Object[]{this.poolName, defaultTransactionIsolation, e});
                                        }
                                        break block61;
                                    }
                                }
                                if (defaultTransactionIsolation == null) {
                                    defaultTransactionIsolation = 2;
                                }
                            }
                            defaultReadOnly = this.poolConfig.isDefaultReadOnly();
                            isEnableDefaultOnReadOnly = this.poolConfig.isEnableDefaultOnReadOnly();
                            if (this.poolConfig.isEnableDefaultOnReadOnly()) {
                                block62: {
                                    if (defaultReadOnly == null) {
                                        try {
                                            defaultReadOnly = firstConn.isReadOnly();
                                        }
                                        catch (Throwable e) {
                                            if (!this.printRuntimeLog) break block62;
                                            Log.warn("BeeCP({})failed to get value of read-only property from first connection object", (Object)this.poolName);
                                        }
                                    }
                                }
                                if (defaultReadOnly == null) {
                                    defaultReadOnly = Boolean.FALSE;
                                    if (this.printRuntimeLog) {
                                        Log.warn("BeeCP({})assign {} as default value of read-only property for connections", (Object)this.poolName, (Object)false);
                                    }
                                }
                                try {
                                    firstConn.setReadOnly(defaultReadOnly);
                                }
                                catch (Throwable e) {
                                    isEnableDefaultOnReadOnly = false;
                                    if (this.printRuntimeLog) {
                                        Log.warn("BeeCP({})failed to set default value({}) of read-only property on first connection object", new Object[]{this.poolName, defaultTransactionIsolation, e});
                                    }
                                    break block63;
                                }
                            }
                            if (defaultReadOnly == null) {
                                defaultReadOnly = Boolean.FALSE;
                            }
                        }
                        defaultCatalog = this.poolConfig.getDefaultCatalog();
                        isEnableDefaultOnCatalog = this.poolConfig.isEnableDefaultOnCatalog();
                        if (isEnableDefaultOnCatalog) {
                            block64: {
                                if (CommonUtil.isBlank(defaultCatalog)) {
                                    try {
                                        defaultCatalog = firstConn.getCatalog();
                                    }
                                    catch (Throwable e) {
                                        if (!this.printRuntimeLog) break block64;
                                        Log.warn("BeeCP({})failed to get value of catalog property from first connection object", (Object)this.poolName, (Object)e);
                                    }
                                }
                            }
                            if (CommonUtil.isNotBlank(defaultCatalog)) {
                                try {
                                    firstConn.setCatalog(defaultCatalog);
                                }
                                catch (Throwable e) {
                                    isEnableDefaultOnCatalog = false;
                                    if (!this.printRuntimeLog) break block65;
                                    Log.warn("BeeCP({})failed to set default value({}) of catalog property on first connection object", new Object[]{this.poolName, defaultCatalog, e});
                                }
                            }
                        }
                    }
                    defaultSchema = this.poolConfig.getDefaultSchema();
                    isEnableDefaultOnSchema = this.poolConfig.isEnableDefaultOnSchema();
                    if (isEnableDefaultOnSchema) {
                        block66: {
                            if (CommonUtil.isBlank(defaultSchema)) {
                                try {
                                    defaultSchema = firstConn.getSchema();
                                }
                                catch (Throwable e) {
                                    if (!this.printRuntimeLog) break block66;
                                    Log.warn("BeeCP({})failed to get value of schema property from first connection object", (Object)this.poolName, (Object)e);
                                }
                            }
                        }
                        if (CommonUtil.isNotBlank(defaultSchema)) {
                            try {
                                firstConn.setSchema(defaultSchema);
                            }
                            catch (Throwable e) {
                                isEnableDefaultOnSchema = false;
                                if (!this.printRuntimeLog) break block67;
                                Log.warn("BeeCP({})failed to set default value({}) of schema property on first connection object", new Object[]{this.poolName, defaultSchema, e});
                            }
                        }
                    }
                }
                supportIsValid = true;
                try {
                    if (firstConn.isValid(this.aliveTestTimeout)) {
                        this.conValidTest = this;
                    } else {
                        supportIsValid = false;
                        if (this.printRuntimeLog) {
                            Log.warn("BeeCP({})get false from call of isValid method on first connection object", (Object)this.poolName);
                        }
                    }
                }
                catch (Throwable e) {
                    supportIsValid = false;
                    if (!this.printRuntimeLog) break block68;
                    Log.warn("BeeCP({})isValid method tested failed on first connection object", (Object)this.poolName, (Object)e);
                }
            }
            if (!supportIsValid) {
                String conTestSql = this.poolConfig.getAliveTestSql();
                boolean supportQueryTimeout = ConnectionPoolStatics.validateTestSql(this.poolName, firstConn, conTestSql, this.aliveTestTimeout, defaultAutoCommit);
                this.conValidTest = new PooledConnectionAliveTestBySql(this.poolName, conTestSql, this.aliveTestTimeout, defaultAutoCommit, supportQueryTimeout, this.printRuntimeLog);
            }
            defaultNetworkTimeout = 0;
            supportNetworkTimeoutInd = true;
            try {
                defaultNetworkTimeout = firstConn.getNetworkTimeout();
                if (defaultNetworkTimeout < 0) {
                    supportNetworkTimeoutInd = false;
                    if (this.printRuntimeLog) {
                        Log.warn("BeeCP({})networkTimeout property not supported by connections due to a negative number returned from first connection object", (Object)this.poolName);
                    }
                } else {
                    if (this.networkTimeoutExecutor == null) {
                        int poolMaxSize = this.poolConfig.getMaxActive();
                        this.networkTimeoutExecutor = new ThreadPoolExecutor(poolMaxSize, poolMaxSize, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(poolMaxSize), new PoolThreadThreadFactory("BeeCP(" + this.poolName + ")"));
                        this.networkTimeoutExecutor.allowCoreThreadTimeOut(true);
                    }
                    firstConn.setNetworkTimeout(this.networkTimeoutExecutor, defaultNetworkTimeout);
                }
            }
            catch (Throwable e) {
                supportNetworkTimeoutInd = false;
                if (this.printRuntimeLog) {
                    Log.warn("BeeCP({})networkTimeout property tested failed on first connection object", (Object)this.poolName, (Object)e);
                }
                if (this.networkTimeoutExecutor == null) break block69;
                this.networkTimeoutExecutor.shutdown();
                this.networkTimeoutExecutor = null;
            }
        }
        boolean defaultCatalogIsNotBlank = !CommonUtil.isBlank(defaultCatalog);
        boolean defaultSchemaIsNotBlank = !CommonUtil.isBlank(defaultSchema);
        for (int i = 0; i < this.connectionArrayLen; ++i) {
            this.connectionArray[i].init(isEnableDefaultOnAutoCommit, defaultAutoCommit, isEnableDefaultOnTransactionIsolation, defaultTransactionIsolation, isEnableDefaultOnReadOnly, defaultReadOnly, isEnableDefaultOnCatalog, defaultCatalogIsNotBlank, defaultCatalog, this.poolConfig.isForceDirtyOnCatalogAfterSet(), isEnableDefaultOnSchema, defaultSchemaIsNotBlank, defaultSchema, this.poolConfig.isForceDirtyOnSchemaAfterSet(), supportNetworkTimeoutInd, defaultNetworkTimeout, this.networkTimeoutExecutor, this.poolConfig.getSqlExceptionCodeList(), this.poolConfig.getSqlExceptionStateList(), this.poolConfig.getEvictPredicate());
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return ConnectionPoolStatics.createProxyConnection(this.getPooledConnection());
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        PooledConnection p = this.getPooledConnection();
        ProxyConnectionBase proxyConn = ConnectionPoolStatics.createProxyConnection(p);
        XAResource proxyResource = this.isRawXaConnFactory ? new XaProxyResource(p.rawXaRes, proxyConn) : new XaResourceLocalImpl(proxyConn, p.defaultAutoCommit);
        return new XaProxyConnection(proxyConn, proxyResource);
    }

    private PooledConnection getPooledConnection() throws SQLException {
        Object s;
        boolean hasCached;
        PooledConnection p;
        if (this.poolState != 2) {
            throw new ConnectionGetForbiddenException("Pool was closed or in cleaning");
        }
        Borrower b = null;
        if (this.enableThreadLocal && (b = (Borrower)this.threadLocal.get().get()) != null && (p = b.lastUsed) != null && p.state == 1 && ConStUpd.compareAndSet(p, 1, 3)) {
            if (this.testOnBorrow(p)) {
                b.lastUsed = p;
                return b.lastUsed;
            }
            b.lastUsed = null;
        }
        long deadline = System.nanoTime();
        try {
            if (!this.semaphore.tryAcquire(this.maxWaitNs, TimeUnit.NANOSECONDS)) {
                throw new ConnectionGetTimeoutException("Waited timeout on pool semaphore");
            }
        }
        catch (InterruptedException e) {
            throw new ConnectionGetInterruptedException("An interruption occurred while waiting on pool semaphore");
        }
        try {
            p = this.searchOrCreate();
        }
        catch (SQLException e) {
            this.semaphore.release();
            throw e;
        }
        boolean bl = hasCached = b != null;
        if (p != null) {
            this.semaphore.release();
            if (this.enableThreadLocal) {
                this.putToThreadLocal(p, b, hasCached);
            }
            return p;
        }
        if (hasCached) {
            b.state = null;
        } else {
            b = new Borrower();
        }
        this.waitQueue.offer(b);
        ConnectionGetException cause = null;
        deadline += this.maxWaitNs;
        while (true) {
            if ((s = b.state) == null) {
                if (cause != null) {
                    BorrowStUpd.compareAndSet(b, null, cause);
                    continue;
                }
                long t = deadline - System.nanoTime();
                if (t > 1023L) {
                    if (this.servantTryCount > 0 && this.servantState == 1 && ServantStateUpd.compareAndSet(this, 1, 0)) {
                        LockSupport.unpark(this);
                    }
                    LockSupport.parkNanos(t);
                    if (!Thread.interrupted()) continue;
                    cause = new ConnectionGetInterruptedException("An interruption occurred while waiting for a released connection");
                    continue;
                }
                if (t > 0L) continue;
                cause = new ConnectionGetTimeoutException("Waited timeout for a released connection");
                continue;
            }
            if (!(s instanceof PooledConnection)) break;
            p = (PooledConnection)s;
            if (this.transferPolicy.tryCatch(p) && this.testOnBorrow(p)) {
                this.semaphore.release();
                this.waitQueue.remove(b);
                if (this.enableThreadLocal) {
                    this.putToThreadLocal(p, b, hasCached);
                }
                return p;
            }
            b.state = null;
        }
        this.semaphore.release();
        this.waitQueue.remove(b);
        throw s instanceof SQLException ? (SQLException)s : new ConnectionGetException((Throwable)s);
    }

    private void putToThreadLocal(PooledConnection p, Borrower b, boolean hasCached) {
        if (hasCached) {
            b.lastUsed = p;
        } else {
            if (b == null) {
                b = new Borrower();
            }
            b.lastUsed = p;
            this.threadLocal.set(new WeakReference<Borrower>(b));
        }
    }

    private void tryWakeupServantThread() {
        int c;
        do {
            if ((c = this.servantTryCount) < this.connectionArrayLen) continue;
            return;
        } while (!ServantTryCountUpd.compareAndSet(this, c, c + 1));
        if (!this.waitQueue.isEmpty() && this.servantState == 1 && ServantStateUpd.compareAndSet(this, 1, 0)) {
            LockSupport.unpark(this);
        }
    }

    void recycle(PooledConnection p) {
        if (this.isCompeteMode) {
            p.state = 1;
        }
        for (Borrower b : this.waitQueue) {
            if (p.state != this.stateCodeOnRelease) {
                return;
            }
            if (b.state != null || !BorrowStUpd.compareAndSet(b, null, p)) continue;
            LockSupport.unpark(b.thread);
            return;
        }
        if (this.isFairMode) {
            p.state = 1;
        }
        this.tryWakeupServantThread();
    }

    void abort(PooledConnection p, String reason) {
        p.onRemove(reason);
        this.tryWakeupServantThread();
    }

    private void transferException(Throwable e) {
        for (Borrower b : this.waitQueue) {
            if (b.state != null || !BorrowStUpd.compareAndSet(b, null, e)) continue;
            LockSupport.unpark(b.thread);
            return;
        }
    }

    private boolean testOnBorrow(PooledConnection p) {
        if (System.currentTimeMillis() - p.lastAccessTime >= this.aliveAssumeTimeMs && !this.conValidTest.isAlive(p)) {
            p.onRemove("bad");
            this.tryWakeupServantThread();
            return false;
        }
        return true;
    }

    @Override
    public int getStateCodeOnRelease() {
        return 1;
    }

    @Override
    public boolean tryCatch(PooledConnection p) {
        return p.state == 1 && ConStUpd.compareAndSet(p, 1, 3);
    }

    private void shutdownPoolThreads() {
        int curState = this.servantState;
        this.servantState = 2;
        if (curState == 1) {
            LockSupport.unpark(this);
        }
        curState = this.idleScanState;
        this.idleScanState = 2;
        if (curState == 1) {
            LockSupport.unpark(this.idleScanThread);
        }
    }

    @Override
    public void run() {
        while (this.poolState != 4) {
            int c;
            while (!(this.servantState != 0 || (c = this.servantTryCount) <= 0 || this.waitQueue.isEmpty() && ServantTryCountUpd.compareAndSet(this, c, 0))) {
                ServantTryCountUpd.decrementAndGet(this);
                try {
                    PooledConnection p = this.searchOrCreate();
                    if (p == null) continue;
                    this.recycle(p);
                }
                catch (Throwable e) {
                    this.transferException(e);
                }
            }
            if (this.servantState == 2) break;
            if (this.servantTryCount != 0 || !ServantStateUpd.compareAndSet(this, 0, 1)) continue;
            LockSupport.park();
        }
    }

    void closeIdleTimeoutConnection() {
        Object vo;
        if (this.printRuntimeLog) {
            vo = this.getPoolMonitorVo();
            Log.info("BeeCP({})before timed scan,idle:{},using:{},semaphore-waiting:{},transfer-waiting:{}", new Object[]{this.poolName, vo.getIdleSize(), vo.getUsingSize(), vo.getSemaphoreWaitingSize(), vo.getTransferWaitingSize()});
        }
        this.interruptConnectionCreating(true);
        for (PooledConnection p : this.connectionArray) {
            int state = p.state;
            if (state == 1 && this.semaphore.availablePermits() == this.semaphoreSize) {
                boolean isTimeoutInIdle;
                boolean bl = isTimeoutInIdle = System.currentTimeMillis() - p.lastAccessTime >= this.idleTimeoutMs;
                if (!isTimeoutInIdle || !ConStUpd.compareAndSet(p, state, 0)) continue;
                p.onRemove("idle");
                this.tryWakeupServantThread();
                continue;
            }
            if (state == 3 && this.supportHoldTimeout) {
                ProxyConnectionBase proxyInUsing;
                if (System.currentTimeMillis() - p.lastAccessTime - this.holdTimeoutMs < 0L || (proxyInUsing = p.proxyInUsing) == null) continue;
                ConnectionPoolStatics.oclose(proxyInUsing);
                continue;
            }
            if (state != 0) continue;
            p.onRemove("closed");
            this.tryWakeupServantThread();
        }
        if (this.printRuntimeLog) {
            vo = this.getPoolMonitorVo();
            Log.info("BeeCP({})after timed scan,idle:{},using:{},semaphore-waiting:{},transfer-waiting:{}", new Object[]{this.poolName, vo.getIdleSize(), vo.getUsingSize(), vo.getSemaphoreWaitingSize(), vo.getTransferWaitingSize()});
        }
    }

    @Override
    public void clear(boolean forceCloseUsing) throws SQLException {
        this.clear(forceCloseUsing, false, null);
    }

    @Override
    public void clear(boolean forceCloseUsing, BeeDataSourceConfig config) throws SQLException {
        this.clear(forceCloseUsing, true, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void clear(boolean forceCloseUsing, boolean reinit, BeeDataSourceConfig config) throws SQLException {
        if (reinit && config == null) {
            throw new BeeDataSourceConfigException("Configuration for pool reinitialization can' be null");
        }
        if (!PoolStateUpd.compareAndSet(this, 2, 5)) throw new PoolInClearingException("Pool was closed or in cleaning");
        try {
            BeeDataSourceConfig checkedConfig = null;
            if (reinit) {
                checkedConfig = config.check();
            }
            Log.info("BeeCP({})begin to remove all connections", (Object)this.poolName);
            this.removeAllConnections(forceCloseUsing, "clear");
            Log.info("BeeCP({})completed to remove all connections", (Object)this.poolName);
            if (!reinit) return;
            this.poolConfig = checkedConfig;
            Log.info("BeeCP({})start to reinitialize pool", (Object)this.poolName);
            this.startup(5);
            Log.info("BeeCP({})completed to reinitialize pool successful", (Object)this.poolName);
            return;
        }
        finally {
            this.poolState = 2;
        }
    }

    private void removeAllConnections(boolean force, String source) {
        this.semaphore.interruptQueuedWaitThreads();
        if (!this.waitQueue.isEmpty()) {
            PoolInClearingException exception = new PoolInClearingException("Force exit due to pool in clearing");
            while (!this.waitQueue.isEmpty()) {
                this.transferException(exception);
            }
        }
        this.interruptConnectionCreating(false);
        while (true) {
            int closedCount = 0;
            for (PooledConnection p : this.connectionArray) {
                int state = p.state;
                if (state == 1) {
                    if (!ConStUpd.compareAndSet(p, 1, 0)) continue;
                    ++closedCount;
                    p.onRemove(source);
                    continue;
                }
                if (state == 3) {
                    ProxyConnectionBase proxyInUsing = p.proxyInUsing;
                    if (proxyInUsing == null || !force && (!this.supportHoldTimeout || System.currentTimeMillis() - p.lastAccessTime < this.holdTimeoutMs)) continue;
                    ConnectionPoolStatics.oclose(proxyInUsing);
                    continue;
                }
                if (state != 0) continue;
                ++closedCount;
                p.onRemove(source);
            }
            if (closedCount == this.connectionArrayLen) break;
            LockSupport.parkNanos(this.delayTimeForNextClearNs);
        }
        if (this.printRuntimeLog) {
            BeeConnectionPoolMonitorVo vo = this.getPoolMonitorVo();
            Log.info("BeeCP({})after clean,idle:{},using:{},semaphore-waiting:{},transfer-waiting:{}", new Object[]{this.poolName, vo.getIdleSize(), vo.getUsingSize(), vo.getSemaphoreWaitingSize(), vo.getTransferWaitingSize()});
        }
    }

    @Override
    public boolean isClosed() {
        return this.poolState == 4;
    }

    @Override
    public void close() {
        block6: {
            int poolStateCode;
            while (true) {
                if ((poolStateCode = this.poolState) == 4 || poolStateCode == 3) {
                    return;
                }
                if (poolStateCode == 0 && PoolStateUpd.compareAndSet(this, 0, 4)) {
                    return;
                }
                if (poolStateCode != 1 && poolStateCode != 5) break;
                LockSupport.parkNanos(this.delayTimeForNextClearNs);
            }
            if (!PoolStateUpd.compareAndSet(this, poolStateCode, 3)) break block6;
            Log.info("BeeCP({})begin to shutdown pool", (Object)this.poolName);
            this.unregisterJmx();
            this.shutdownPoolThreads();
            this.removeAllConnections(this.poolConfig.isForceCloseUsingOnClear(), "destroy");
            if (this.networkTimeoutExecutor != null) {
                this.networkTimeoutExecutor.shutdownNow();
            }
            try {
                Runtime.getRuntime().removeShutdownHook(this.exitHook);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.poolState = 4;
            Log.info("BeeCP({})has shutdown pool", (Object)this.poolName);
        }
    }

    boolean isPrintRuntimeLog() {
        return this.printRuntimeLog;
    }

    @Override
    public void setPrintRuntimeLog(boolean indicator) {
        this.printRuntimeLog = indicator;
    }

    @Override
    public int getTotalSize() {
        return this.getIdleSize() + this.getUsingSize();
    }

    @Override
    public int getIdleSize() {
        int idleSize = 0;
        for (PooledConnection p : this.connectionArray) {
            if (p.state != 1) continue;
            ++idleSize;
        }
        return idleSize;
    }

    @Override
    public int getUsingSize() {
        int usingSize = 0;
        for (PooledConnection p : this.connectionArray) {
            if (p.state != 3) continue;
            ++usingSize;
        }
        return usingSize;
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    @Override
    public int getSemaphoreWaitingSize() {
        return this.semaphore.getQueueLength();
    }

    @Override
    public int getSemaphoreAcquiredSize() {
        return this.semaphoreSize - this.semaphore.availablePermits();
    }

    @Override
    public int getTransferWaitingSize() {
        int size = 0;
        for (Borrower borrower : this.waitQueue) {
            if (borrower.state != null) continue;
            ++size;
        }
        return size;
    }

    @Override
    public int getConnectionCreatingCount() {
        int count = 0;
        for (PooledConnection p : this.connectionArray) {
            ConnectionCreatingInfo creatingInfo = p.creatingInfo;
            if (creatingInfo == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getConnectionCreatingTimeoutCount() {
        int count = 0;
        for (PooledConnection p : this.connectionArray) {
            ConnectionCreatingInfo creatingInfo = p.creatingInfo;
            if (creatingInfo == null || System.nanoTime() - creatingInfo.creatingStartTime < this.maxWaitNs) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Thread[] interruptConnectionCreating(boolean onlyInterruptTimeout) {
        if (this.printRuntimeLog) {
            Log.info("BeeCP({})attempt to interrupt connection creation,only for timeout:{}", (Object)this.poolName, (Object)onlyInterruptTimeout);
        }
        HashSet<Thread> threads = new HashSet<Thread>(this.semaphoreSize);
        if (!this.connectionArrayInitialized) {
            Thread holdThread = this.connectionArrayInitLock.interruptOwnerThread();
            List<Thread> waitThreads = this.connectionArrayInitLock.interruptQueuedWaitThreads();
            if (holdThread != null) {
                threads.add(holdThread);
            }
            if (!waitThreads.isEmpty()) {
                threads.addAll(waitThreads);
            }
        }
        if (onlyInterruptTimeout) {
            for (PooledConnection p : this.connectionArray) {
                ConnectionCreatingInfo creatingInfo = p.creatingInfo;
                if (creatingInfo == null || System.nanoTime() - creatingInfo.creatingStartTime < this.maxWaitNs) continue;
                creatingInfo.creatingThread.interrupt();
                threads.add(creatingInfo.creatingThread);
            }
        } else {
            for (PooledConnection p : this.connectionArray) {
                ConnectionCreatingInfo creatingInfo = p.creatingInfo;
                if (creatingInfo == null) continue;
                creatingInfo.creatingThread.interrupt();
                threads.add(creatingInfo.creatingThread);
            }
        }
        return threads.toArray(new Thread[0]);
    }

    private void registerJmx() {
        if (this.poolConfig.isEnableJmx()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.registerJmxBean(mBeanServer, String.format("FastConnectionPool:type=BeeCP(%s)", this.poolName), this);
            this.registerJmxBean(mBeanServer, String.format("BeeDataSourceConfig:type=BeeCP(%s)-config", this.poolName), this.poolConfig);
        }
    }

    private void registerJmxBean(MBeanServer mBeanServer, String regName, Object bean) {
        try {
            ObjectName jmxRegName = new ObjectName(regName);
            if (!mBeanServer.isRegistered(jmxRegName)) {
                mBeanServer.registerMBean(bean, jmxRegName);
            }
        }
        catch (Throwable e) {
            Log.warn("BeeCP({})failed to register jmx-bean:{}", new Object[]{this.poolName, regName, e});
        }
    }

    private void unregisterJmx() {
        if (this.poolConfig.isEnableJmx()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.unregisterJmxBean(mBeanServer, String.format("FastConnectionPool:type=BeeCP(%s)", this.poolName));
            this.unregisterJmxBean(mBeanServer, String.format("BeeDataSourceConfig:type=BeeCP(%s)-config", this.poolName));
        }
    }

    private void unregisterJmxBean(MBeanServer mBeanServer, String regName) {
        try {
            ObjectName jmxRegName = new ObjectName(regName);
            if (mBeanServer.isRegistered(jmxRegName)) {
                mBeanServer.unregisterMBean(jmxRegName);
            }
        }
        catch (Throwable e) {
            Log.warn("BeeCP({})failed to unregister jmx-bean:{}", new Object[]{this.poolName, regName, e});
        }
    }

    @Override
    public boolean isAlive(PooledConnection p) {
        block3: {
            try {
                if (p.rawConn.isValid(this.aliveTestTimeout)) {
                    p.lastAccessTime = System.currentTimeMillis();
                    return true;
                }
            }
            catch (Throwable e) {
                if (!this.printRuntimeLog) break block3;
                Log.warn("BeeCP({})alive test failed on a borrowed connection", (Object)this.poolName, (Object)e);
            }
        }
        return false;
    }

    private FastConnectionPoolMonitorVo createPoolMonitorVo() {
        Thread currentThread = Thread.currentThread();
        this.poolThreadId = currentThread.getId();
        this.poolThreadName = currentThread.getName();
        try {
            this.poolHostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            Log.info("BeeCP({})failed to resolve host IP", (Object)this.poolName);
        }
        return new FastConnectionPoolMonitorVo();
    }

    @Override
    public BeeConnectionPoolMonitorVo getPoolMonitorVo() {
        int usingSize = 0;
        int idleSize = 0;
        int creatingCount = 0;
        int creatingTimeoutCount = 0;
        for (PooledConnection p : this.connectionArray) {
            ConnectionCreatingInfo creatingInfo;
            int state = p.state;
            if (state == 3) {
                ++usingSize;
            }
            if (state == 1) {
                ++idleSize;
            }
            if ((creatingInfo = p.creatingInfo) == null) continue;
            ++creatingCount;
            if (System.nanoTime() - creatingInfo.creatingStartTime < this.maxWaitNs) continue;
            ++creatingTimeoutCount;
        }
        this.monitorVo.setPoolName(this.poolName);
        this.monitorVo.setPoolMode(this.poolMode);
        this.monitorVo.setPoolMaxSize(this.connectionArrayLen);
        this.monitorVo.setThreadId(this.poolThreadId);
        this.monitorVo.setThreadName(this.poolThreadName);
        this.monitorVo.setHostIP(this.poolHostIP);
        this.monitorVo.setPoolState(this.poolState);
        this.monitorVo.setIdleSize(idleSize);
        this.monitorVo.setUsingSize(usingSize);
        this.monitorVo.setCreatingCount(creatingCount);
        this.monitorVo.setCreatingTimeoutCount(creatingTimeoutCount);
        this.monitorVo.setSemaphoreWaitingSize(this.getSemaphoreWaitingSize());
        this.monitorVo.setTransferWaitingSize(this.getTransferWaitingSize());
        return this.monitorVo;
    }

    private static final class PooledConnectionAliveTestBySql
    implements PooledConnectionAliveTest {
        private final String testSql;
        private final String poolName;
        private final boolean printRuntimeLog;
        private final int validTestTimeout;
        private final boolean isDefaultAutoCommit;
        private final boolean supportQueryTimeout;

        PooledConnectionAliveTestBySql(String poolName, String testSql, int validTestTimeout, boolean isDefaultAutoCommit, boolean supportQueryTimeout, boolean printRuntimeLog) {
            this.poolName = poolName;
            this.testSql = testSql;
            this.printRuntimeLog = printRuntimeLog;
            this.validTestTimeout = validTestTimeout;
            this.isDefaultAutoCommit = isDefaultAutoCommit;
            this.supportQueryTimeout = supportQueryTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAlive(PooledConnection p) {
            Statement st = null;
            boolean changed = false;
            Connection rawConn = p.rawConn;
            boolean checkPassed = true;
            try {
                block21: {
                    if (this.isDefaultAutoCommit) {
                        rawConn.setAutoCommit(false);
                        changed = true;
                    }
                    st = rawConn.createStatement();
                    if (this.supportQueryTimeout) {
                        try {
                            st.setQueryTimeout(this.validTestTimeout);
                        }
                        catch (Throwable e) {
                            if (!this.printRuntimeLog) break block21;
                            Log.warn("BeeCP({})failed to set query timeout value on statement of a borrowed connection", (Object)this.poolName, (Object)e);
                        }
                    }
                }
                try {
                    st.execute(this.testSql);
                    p.lastAccessTime = System.currentTimeMillis();
                }
                finally {
                    rawConn.rollback();
                }
            }
            catch (Throwable e) {
                checkPassed = false;
                if (this.printRuntimeLog) {
                    Log.warn("BeeCP({})alive test failure on a borrowed connection by sql,pool will abandon it", (Object)this.poolName, (Object)e);
                }
            }
            finally {
                if (st != null) {
                    ConnectionPoolStatics.oclose(st);
                }
                if (changed) {
                    try {
                        rawConn.setAutoCommit(true);
                    }
                    catch (Throwable e) {
                        Log.warn("BeeCP({})failed to reset autoCommit property of a borrowed connection after alive test,pool will abandon it", (Object)this.poolName, (Object)e);
                        checkPassed = false;
                    }
                }
            }
            return checkPassed;
        }
    }

    private static final class BorrowerThreadLocal
    extends ThreadLocal<WeakReference<Borrower>> {
        BorrowerThreadLocal() {
        }

        @Override
        protected WeakReference<Borrower> initialValue() {
            return new WeakReference<Borrower>(new Borrower());
        }
    }

    private static final class FairTransferPolicy
    implements PooledConnectionTransferPolicy {
        FairTransferPolicy() {
        }

        @Override
        public int getStateCodeOnRelease() {
            return 3;
        }

        @Override
        public boolean tryCatch(PooledConnection p) {
            return p.state == 3;
        }
    }

    private static class ConnectionPoolHook
    extends Thread {
        private final FastConnectionPool pool;

        ConnectionPoolHook(FastConnectionPool pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            Log.info("BeeCP({})detect Jvm exit,pool will be shutdown", (Object)this.pool.poolName);
            try {
                this.pool.close();
            }
            catch (Throwable e) {
                Log.error("BeeCP({})an exception occurred when shutdown pool", (Object)this.pool.poolName, (Object)e);
            }
        }
    }

    private static final class IdleTimeoutScanThread
    extends Thread {
        private final FastConnectionPool pool;

        IdleTimeoutScanThread(FastConnectionPool pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            long checkTimeIntervalNanos = TimeUnit.MILLISECONDS.toNanos(this.pool.poolConfig.getTimerCheckInterval());
            while (this.pool.idleScanState == 0) {
                LockSupport.parkNanos(checkTimeIntervalNanos);
                try {
                    if (this.pool.poolState != 2) continue;
                    this.pool.closeIdleTimeoutConnection();
                }
                catch (Throwable e) {
                    Log.warn("BeeCP({})an exception occurred while scanning idle-timeout connections", (Object)this.pool.poolName, (Object)e);
                }
            }
        }
    }

    private static final class PoolInitAsyncCreateThread
    extends Thread {
        private final FastConnectionPool pool;

        PoolInitAsyncCreateThread(FastConnectionPool pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            try {
                this.pool.createInitConnections(this.pool.poolConfig.getInitialSize(), false);
                this.pool.servantTryCount = this.pool.connectionArray.length;
                if (!this.pool.waitQueue.isEmpty() && this.pool.servantState == 1 && ServantStateUpd.compareAndSet(this.pool, 1, 0)) {
                    LockSupport.unpark(this.pool);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static final class PoolThreadThreadFactory
    implements ThreadFactory {
        private final String poolName;

        PoolThreadThreadFactory(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread th = new Thread(r, this.poolName + "-networkTimeoutRestThread");
            th.setDaemon(true);
            return th;
        }
    }
}

