/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.transaction.xa.XAResource;
import org.stone.beecp.BeeConnectionPredicate;
import org.stone.beecp.pool.ConnectionCreatingInfo;
import org.stone.beecp.pool.ConnectionPoolStatics;
import org.stone.beecp.pool.FastConnectionPool;
import org.stone.beecp.pool.ProxyConnectionBase;
import org.stone.beecp.pool.ProxyStatementBase;
import org.stone.beecp.pool.exception.ConnectionRecycleException;
import org.stone.tools.BeanUtil;
import org.stone.tools.CommonUtil;

final class PooledConnection {
    private static final boolean[] FALSE = new boolean[6];
    final int pooledConnectionIndex;
    private final FastConnectionPool pool;
    boolean defaultAutoCommit;
    int defaultTransactionIsolation;
    boolean defaultReadOnly;
    String defaultCatalog;
    String defaultSchema;
    int defaultNetworkTimeout;
    boolean forceDirtyOnSchemaAfterSet;
    boolean forceDirtyOnCatalogAfterSet;
    volatile ConnectionCreatingInfo creatingInfo;
    Connection rawConn;
    XAResource rawXaRes;
    volatile int state;
    volatile long lastAccessTime;
    int openStmSize;
    boolean curAutoCommit;
    boolean commitDirtyInd;
    ProxyConnectionBase proxyInUsing;
    private int resetCnt;
    private boolean[] resetFlags;
    private ProxyStatementBase[] openStatements;
    private boolean enableDefaultOnCatalog;
    private boolean enableDefaultOnSchema;
    private boolean enableDefaultOnReadOnly;
    private boolean enableDefaultOnAutoCommit;
    private boolean enableDefaultOnTransactionIsolation;
    private boolean defaultCatalogIsNotBlank;
    private boolean defaultSchemaIsNotBlank;
    private boolean supportNetworkTimeoutInd;
    private ThreadPoolExecutor networkTimeoutExecutor;
    private List<Integer> sqlExceptionCodeList;
    private List<String> sqlExceptionStateList;
    private BeeConnectionPredicate predicate;

    PooledConnection(FastConnectionPool pool, int pooledConnectionIndex) {
        this.pool = pool;
        this.pooledConnectionIndex = pooledConnectionIndex;
    }

    void init(boolean enableDefaultOnAutoCommit, boolean defaultAutoCommit, boolean enableDefaultOnTransactionIsolation, int defaultTransactionIsolation, boolean enableDefaultOnReadOnly, boolean defaultReadOnly, boolean enableDefaultOnCatalog, boolean defaultCatalogIsNotBlank, String defaultCatalog, boolean forceDirtyOnCatalogAfterSet, boolean enableDefaultOnSchema, boolean defaultSchemaIsNotBlank, String defaultSchema, boolean forceDirtyOnSchemaAfterSet, boolean supportNetworkTimeoutInd, int defaultNetworkTimeout, ThreadPoolExecutor networkTimeoutExecutor, List<Integer> sqlExceptionCodeList, List<String> sqlExceptionStateList, BeeConnectionPredicate predicate) {
        this.enableDefaultOnAutoCommit = enableDefaultOnAutoCommit;
        this.defaultAutoCommit = defaultAutoCommit;
        this.enableDefaultOnTransactionIsolation = enableDefaultOnTransactionIsolation;
        this.defaultTransactionIsolation = defaultTransactionIsolation;
        this.enableDefaultOnReadOnly = enableDefaultOnReadOnly;
        this.defaultReadOnly = defaultReadOnly;
        this.enableDefaultOnCatalog = enableDefaultOnCatalog;
        this.defaultCatalog = defaultCatalog;
        this.defaultCatalogIsNotBlank = defaultCatalogIsNotBlank;
        this.forceDirtyOnCatalogAfterSet = forceDirtyOnCatalogAfterSet;
        this.enableDefaultOnSchema = enableDefaultOnSchema;
        this.defaultSchema = defaultSchema;
        this.defaultSchemaIsNotBlank = defaultSchemaIsNotBlank;
        this.forceDirtyOnSchemaAfterSet = forceDirtyOnSchemaAfterSet;
        this.supportNetworkTimeoutInd = supportNetworkTimeoutInd;
        this.defaultNetworkTimeout = defaultNetworkTimeout;
        this.networkTimeoutExecutor = networkTimeoutExecutor;
        this.sqlExceptionCodeList = sqlExceptionCodeList;
        this.sqlExceptionStateList = sqlExceptionStateList;
        this.predicate = predicate;
    }

    void setRawConnection(int state, Connection rawConn, XAResource rawXaRes) throws SQLException {
        if (this.enableDefaultOnAutoCommit && this.defaultAutoCommit != rawConn.getAutoCommit()) {
            rawConn.setAutoCommit(this.defaultAutoCommit);
        }
        if (this.enableDefaultOnTransactionIsolation && this.defaultTransactionIsolation != rawConn.getTransactionIsolation()) {
            rawConn.setTransactionIsolation(this.defaultTransactionIsolation);
        }
        if (this.enableDefaultOnReadOnly && this.defaultReadOnly != rawConn.isReadOnly()) {
            rawConn.setReadOnly(this.defaultReadOnly);
        }
        if (this.enableDefaultOnCatalog && this.defaultCatalogIsNotBlank && !this.defaultCatalog.equals(rawConn.getCatalog())) {
            rawConn.setCatalog(this.defaultCatalog);
        }
        if (this.enableDefaultOnSchema && this.defaultSchemaIsNotBlank && !this.defaultSchema.equals(rawConn.getSchema())) {
            rawConn.setSchema(this.defaultSchema);
        }
        this.setRawConnection2(state, rawConn, rawXaRes);
    }

    void setRawConnection2(int state, Connection rawConn, XAResource rawXaRes) {
        this.rawConn = rawConn;
        this.rawXaRes = rawXaRes;
        this.resetFlags = (boolean[])FALSE.clone();
        this.commitDirtyInd = false;
        this.curAutoCommit = this.defaultAutoCommit;
        this.creatingInfo = null;
        this.openStmSize = 0;
        this.openStatements = new ProxyStatementBase[10];
        this.lastAccessTime = System.currentTimeMillis();
        this.state = state;
    }

    void abortSelf() {
        this.pool.abort(this, "abort");
    }

    void recycleSelf() throws SQLException {
        try {
            this.proxyInUsing = null;
            this.resetRawConn();
            this.pool.recycle(this);
        }
        catch (Throwable e) {
            this.pool.abort(this, "bad");
            throw e instanceof SQLException ? (SQLException)e : new ConnectionRecycleException(e);
        }
    }

    void onRemove(String msg) {
        if (this.pool.isPrintRuntimeLog()) {
            BeanUtil.CommonLog.info("BeeCP({}))begin to remove a pooled connection:{} for cause:{}", new Object[]{this.pool.getPoolName(), this, msg});
        }
        try {
            this.resetRawConn();
        }
        catch (Throwable e) {
            if (this.pool.isPrintRuntimeLog()) {
                BeanUtil.CommonLog.warn("BeeCP({})Resetting connection failed", (Object)this.pool.getPoolName(), (Object)e);
            }
        }
        finally {
            ConnectionPoolStatics.oclose(this.rawConn);
            this.rawConn = null;
            this.rawXaRes = null;
            this.proxyInUsing = null;
            this.resetFlags = null;
            this.openStatements = null;
            this.state = 0;
        }
    }

    void registerStatement(ProxyStatementBase s) {
        if (this.openStmSize == this.openStatements.length) {
            ProxyStatementBase[] array = new ProxyStatementBase[this.openStmSize << 1];
            System.arraycopy(this.openStatements, 0, array, 0, this.openStmSize);
            this.openStatements = array;
        }
        this.openStatements[this.openStmSize++] = s;
    }

    void unregisterStatement(ProxyStatementBase s) {
        for (int i = this.openStmSize - 1; i >= 0; --i) {
            if (s != this.openStatements[i]) continue;
            int m = this.openStmSize - i - 1;
            if (m > 0) {
                System.arraycopy(this.openStatements, i + 1, this.openStatements, i, m);
            }
            this.openStatements[--this.openStmSize] = null;
            return;
        }
    }

    void clearStatement() {
        for (int i = 0; i < this.openStmSize; ++i) {
            ProxyStatementBase s = this.openStatements[i];
            if (s == null) continue;
            s.registered = false;
            this.openStatements[i] = null;
            ConnectionPoolStatics.oclose(s);
        }
        this.openStmSize = 0;
    }

    void updateAccessTime() {
        this.commitDirtyInd = !this.curAutoCommit;
        this.lastAccessTime = System.currentTimeMillis();
    }

    void checkSQLException(SQLException e) {
        ProxyConnectionBase proxyInUsing = this.proxyInUsing;
        if (proxyInUsing == null) {
            return;
        }
        if (this.predicate != null) {
            String msg = this.predicate.evictTest(e);
            if (CommonUtil.isNotBlank(msg)) {
                if (this.pool.isPrintRuntimeLog()) {
                    BeanUtil.CommonLog.warn("BeeCP({})Connection has been broken because of predicate result({})", (Object)this.pool.getPoolName(), (Object)msg);
                }
                proxyInUsing.abort(null);
            }
        } else {
            int code = e.getErrorCode();
            if (code != 0 && this.sqlExceptionCodeList != null && this.sqlExceptionCodeList.contains(code)) {
                if (this.pool.isPrintRuntimeLog()) {
                    BeanUtil.CommonLog.warn("BeeCP({})Connection has been broken because of error code({})", (Object)this.pool.getPoolName(), (Object)code);
                }
                proxyInUsing.abort(null);
                return;
            }
            String state = e.getSQLState();
            if (state != null && this.sqlExceptionStateList != null && this.sqlExceptionStateList.contains(state)) {
                if (this.pool.isPrintRuntimeLog()) {
                    BeanUtil.CommonLog.warn("BeeCP({})Connection has been broken because of SQL state({})", (Object)this.pool.getPoolName(), (Object)state);
                }
                proxyInUsing.abort(null);
            }
        }
    }

    boolean supportNetworkTimeoutSet() {
        return this.supportNetworkTimeoutInd;
    }

    void setResetInd(int i, boolean changed) {
        if (this.resetFlags[i] != changed) {
            this.resetFlags[i] = changed;
            this.resetCnt += changed ? 1 : -1;
        }
    }

    private void resetRawConn() throws SQLException {
        if (this.commitDirtyInd) {
            this.rawConn.rollback();
            this.commitDirtyInd = false;
        }
        if (this.resetCnt > 0) {
            if (this.resetFlags[0]) {
                this.rawConn.setAutoCommit(this.defaultAutoCommit);
                this.curAutoCommit = this.defaultAutoCommit;
            }
            if (this.resetFlags[1]) {
                this.rawConn.setTransactionIsolation(this.defaultTransactionIsolation);
            }
            if (this.resetFlags[2]) {
                this.rawConn.setReadOnly(this.defaultReadOnly);
            }
            if (this.defaultCatalogIsNotBlank && this.resetFlags[3]) {
                this.rawConn.setCatalog(this.defaultCatalog);
            }
            if (this.defaultSchemaIsNotBlank && this.resetFlags[4]) {
                this.rawConn.setSchema(this.defaultSchema);
            }
            if (this.resetFlags[5]) {
                this.rawConn.setNetworkTimeout(this.networkTimeoutExecutor, this.defaultNetworkTimeout);
            }
            this.resetCnt = 0;
            System.arraycopy(FALSE, 0, this.resetFlags, 0, 6);
        }
        this.rawConn.clearWarnings();
    }
}

