/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedList;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;
import org.stone.beecp.pool.ConnectionPoolStatics;
import org.stone.beecp.pool.ProxyConnectionBase;
import org.stone.beecp.pool.ProxyDatabaseMetaDataBase;
import org.stone.beecp.pool.ProxyResultSetBase;
import org.stone.beecp.pool.ProxyResultSetMetaDataBase;
import org.stone.beecp.pool.ProxyStatementBase;
import org.stone.tools.CommonUtil;

final class ProxyClassGenerator {
    private static final String DefaultFolder = "stone/target/classes";

    ProxyClassGenerator() {
    }

    public static void main(String[] args) throws Exception {
        String classesFolder = "";
        if (args != null && args.length > 0) {
            classesFolder = args[0];
        }
        if (CommonUtil.isBlank(classesFolder)) {
            classesFolder = DefaultFolder;
        }
        ProxyClassGenerator.writeProxyFile(classesFolder);
    }

    private static void resolveInterfaceMethods(CtClass interfaceClass, LinkedList<CtMethod> linkedList, HashSet<String> exitSignatureSet) throws Exception {
        for (CtMethod ctMethod : interfaceClass.getDeclaredMethods()) {
            int modifiers = ctMethod.getModifiers();
            String signature = ctMethod.getName() + ctMethod.getSignature();
            if (!Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers) || Modifier.isStatic((int)modifiers) || Modifier.isFinal((int)modifiers) || exitSignatureSet.contains(signature)) continue;
            linkedList.add(ctMethod);
            exitSignatureSet.add(signature);
        }
        for (CtMethod ctMethod : interfaceClass.getInterfaces()) {
            ProxyClassGenerator.resolveInterfaceMethods((CtClass)ctMethod, linkedList, exitSignatureSet);
        }
    }

    private static void writeProxyFile(String folder) throws Exception {
        CtClass[] ctClasses;
        for (CtClass ctClass : ctClasses = ProxyClassGenerator.createProxyClasses()) {
            ctClass.writeFile(folder);
        }
    }

    private static CtClass[] createProxyClasses() throws Exception {
        ClassPool classPool = ClassPool.getDefault();
        classPool.importPackage("java.sql");
        classPool.importPackage("org.stone.beecp.pool");
        classPool.appendClassPath((ClassPath)new LoaderClassPath(ProxyClassGenerator.class.getClassLoader()));
        CtClass ctConnectionClass = classPool.get(Connection.class.getName());
        CtClass ctProxyConnectionBaseClass = classPool.get(ProxyConnectionBase.class.getName());
        CtClass ctProxyConnectionClass = classPool.makeClass("org.stone.beecp.pool.ProxyConnection", ctProxyConnectionBaseClass);
        ctProxyConnectionClass.setModifiers(17);
        CtConstructor ctConstructor = new CtConstructor(new CtClass[]{classPool.get("org.stone.beecp.pool.PooledConnection")}, ctProxyConnectionClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyConnectionClass.addConstructor(ctConstructor);
        CtClass ctStatementClass = classPool.get(Statement.class.getName());
        CtClass ctProxyStatementBaseClass = classPool.get(ProxyStatementBase.class.getName());
        CtClass ctProxyStatementClass = classPool.makeClass("org.stone.beecp.pool.ProxyStatement", ctProxyStatementBaseClass);
        ctProxyStatementClass.setModifiers(1);
        CtClass[] statementCreateParamTypes = new CtClass[]{classPool.get("java.sql.Statement"), classPool.get("org.stone.beecp.pool.ProxyConnectionBase"), classPool.get("org.stone.beecp.pool.PooledConnection")};
        ctConstructor = new CtConstructor(statementCreateParamTypes, ctProxyStatementClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyStatementClass.addConstructor(ctConstructor);
        CtClass ctPreparedStatementClass = classPool.get(PreparedStatement.class.getName());
        CtClass ctProxyPsStatementClass = classPool.makeClass("org.stone.beecp.pool.ProxyPsStatement", ctProxyStatementClass);
        ctProxyPsStatementClass.setInterfaces(new CtClass[]{ctPreparedStatementClass});
        ctProxyPsStatementClass.setModifiers(1);
        CtClass[] statementPsCreateParamTypes = new CtClass[]{classPool.get("java.sql.PreparedStatement"), classPool.get("org.stone.beecp.pool.ProxyConnectionBase"), classPool.get("org.stone.beecp.pool.PooledConnection")};
        ctConstructor = new CtConstructor(statementPsCreateParamTypes, ctProxyPsStatementClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyPsStatementClass.addConstructor(ctConstructor);
        CtClass ctCallableStatementClass = classPool.get(CallableStatement.class.getName());
        CtClass ctProxyCsStatementClass = classPool.makeClass("org.stone.beecp.pool.ProxyCsStatement", ctProxyPsStatementClass);
        ctProxyCsStatementClass.setInterfaces(new CtClass[]{ctCallableStatementClass});
        ctProxyCsStatementClass.setModifiers(1);
        CtClass[] statementCsCreateParamTypes = new CtClass[]{classPool.get("java.sql.CallableStatement"), classPool.get("org.stone.beecp.pool.ProxyConnectionBase"), classPool.get("org.stone.beecp.pool.PooledConnection")};
        ctConstructor = new CtConstructor(statementCsCreateParamTypes, ctProxyCsStatementClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyCsStatementClass.addConstructor(ctConstructor);
        CtClass ctDatabaseMetaDataClass = classPool.get(DatabaseMetaData.class.getName());
        CtClass ctProxyDatabaseMetaDataBaseClass = classPool.get(ProxyDatabaseMetaDataBase.class.getName());
        CtClass ctProxyDatabaseMetaDataClass = classPool.makeClass("org.stone.beecp.pool.ProxyDatabaseMetaData", ctProxyDatabaseMetaDataBaseClass);
        ctProxyDatabaseMetaDataClass.setModifiers(17);
        CtClass[] databaseMetaDataTypes = new CtClass[]{classPool.get("java.sql.DatabaseMetaData"), classPool.get("org.stone.beecp.pool.PooledConnection")};
        ctConstructor = new CtConstructor(databaseMetaDataTypes, ctProxyDatabaseMetaDataClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyDatabaseMetaDataClass.addConstructor(ctConstructor);
        CtClass ctResultSetClass = classPool.get(ResultSet.class.getName());
        CtClass ctProxyResultSetBaseClass = classPool.get(ProxyResultSetBase.class.getName());
        CtClass ctProxyResultSetClass = classPool.makeClass("org.stone.beecp.pool.ProxyResultSet", ctProxyResultSetBaseClass);
        ctProxyResultSetClass.setModifiers(17);
        CtClass[] resultSetCreateParamTypes1 = new CtClass[]{classPool.get("java.sql.ResultSet"), classPool.get("org.stone.beecp.pool.PooledConnection")};
        CtConstructor ctConstructor1 = new CtConstructor(resultSetCreateParamTypes1, ctProxyResultSetClass);
        ctConstructor1.setBody("{super($$);}");
        ctProxyResultSetClass.addConstructor(ctConstructor1);
        CtClass[] resultSetCreateParamTypes2 = new CtClass[]{classPool.get("java.sql.ResultSet"), classPool.get("org.stone.beecp.pool.ProxyStatementBase"), classPool.get("org.stone.beecp.pool.PooledConnection")};
        ctConstructor = new CtConstructor(resultSetCreateParamTypes2, ctProxyResultSetClass);
        ctConstructor.setBody("{super($$);}");
        ctProxyResultSetClass.addConstructor(ctConstructor);
        CtClass ctResultSetMetaDataClass = classPool.get(ResultSetMetaData.class.getName());
        CtClass ctProxyResultSetMetaDataBaseClass = classPool.get(ProxyResultSetMetaDataBase.class.getName());
        CtClass ctProxyResultSetMetaDataClass = classPool.makeClass("org.stone.beecp.pool.ProxyResultSetMetaData", ctProxyResultSetMetaDataBaseClass);
        ctProxyResultSetMetaDataClass.setModifiers(17);
        CtClass[] resultSetMetaDataCreateParamTypes1 = new CtClass[]{classPool.get("java.sql.ResultSetMetaData"), classPool.get("org.stone.beecp.pool.ProxyResultSetBase"), classPool.get("org.stone.beecp.pool.PooledConnection")};
        ctConstructor1 = new CtConstructor(resultSetMetaDataCreateParamTypes1, ctProxyResultSetMetaDataClass);
        ctConstructor1.setBody("{super($$);}");
        ctProxyResultSetMetaDataClass.addConstructor(ctConstructor1);
        ProxyClassGenerator.createProxyConnectionClass(classPool, ctProxyConnectionClass, ctConnectionClass, ctProxyConnectionBaseClass);
        ProxyClassGenerator.createProxyStatementClass(classPool, ctProxyStatementClass, ctStatementClass, ctProxyStatementBaseClass);
        ProxyClassGenerator.createProxyStatementClass(classPool, ctProxyPsStatementClass, ctPreparedStatementClass, ctProxyStatementClass);
        ProxyClassGenerator.createProxyStatementClass(classPool, ctProxyCsStatementClass, ctCallableStatementClass, ctProxyPsStatementClass);
        ProxyClassGenerator.createProxyDatabaseMetaDataClass(classPool, ctProxyDatabaseMetaDataClass, ctDatabaseMetaDataClass, ctProxyDatabaseMetaDataBaseClass);
        ProxyClassGenerator.createProxyResultSetClass(classPool, ctProxyResultSetClass, ctResultSetClass, ctProxyResultSetBaseClass);
        ProxyClassGenerator.createProxyResultSetMetaDataClass(ctProxyResultSetMetaDataClass, ctResultSetMetaDataClass, ctProxyResultSetMetaDataBaseClass);
        CtClass ctProxyObjectFactoryClass = classPool.get(ConnectionPoolStatics.class.getName());
        for (CtMethod method : ctProxyObjectFactoryClass.getDeclaredMethods()) {
            if ("createProxyConnection".equals(method.getName())) {
                method.setBody("{return new ProxyConnection($$);}");
                continue;
            }
            if (!"createProxyResultSet".equals(method.getName())) continue;
            method.setBody("{return new ProxyResultSet($$);}");
        }
        return new CtClass[]{ctProxyConnectionClass, ctProxyStatementClass, ctProxyPsStatementClass, ctProxyCsStatementClass, ctProxyDatabaseMetaDataClass, ctProxyResultSetClass, ctProxyObjectFactoryClass, ctProxyResultSetMetaDataClass};
    }

    private static HashSet<String> findMethodsNotNeedProxy(CtClass baseClass) {
        HashSet<String> notNeedAddProxyMethods = new HashSet<String>(16);
        for (CtMethod ctSuperClassMethod : baseClass.getMethods()) {
            int modifiers = ctSuperClassMethod.getModifiers();
            if ((Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers)) && !Modifier.isFinal((int)modifiers) && !Modifier.isStatic((int)modifiers) && !Modifier.isNative((int)modifiers)) continue;
            notNeedAddProxyMethods.add(ctSuperClassMethod.getName() + ctSuperClassMethod.getSignature());
        }
        return notNeedAddProxyMethods;
    }

    private static void createProxyConnectionClass(ClassPool classPool, CtClass ctConnectionClassProxyClass, CtClass ctConnectionClass, CtClass ctConBaseClass) throws Exception {
        LinkedList<CtMethod> linkedList = new LinkedList<CtMethod>();
        HashSet<String> notNeedAddProxyMethods = ProxyClassGenerator.findMethodsNotNeedProxy(ctConBaseClass);
        ProxyClassGenerator.resolveInterfaceMethods(ctConnectionClass, linkedList, notNeedAddProxyMethods);
        CtClass ctStatementClass = classPool.get(Statement.class.getName());
        CtClass ctPreparedStatementClass = classPool.get(PreparedStatement.class.getName());
        CtClass ctCallableStatementClass = classPool.get(CallableStatement.class.getName());
        CtClass ctDatabaseMetaDataClass = classPool.get(DatabaseMetaData.class.getName());
        StringBuilder methodBuffer = new StringBuilder(50);
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctConnectionClassProxyClass, null);
            newCtMethod.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{");
            boolean existsSQLException = ProxyClassGenerator.exitsSQLException(ctMethod.getExceptionTypes());
            if (existsSQLException) {
                methodBuffer.append("  try{");
            }
            if (ctMethod.getReturnType() == ctStatementClass) {
                newCtMethod.setModifiers(17);
                methodBuffer.append("return new ProxyStatement(raw." + methodName + "($$),this,p);");
            } else if (ctMethod.getReturnType() == ctPreparedStatementClass) {
                newCtMethod.setModifiers(17);
                methodBuffer.append("return new ProxyPsStatement(raw." + methodName + "($$),this,p);");
            } else if (ctMethod.getReturnType() == ctCallableStatementClass) {
                newCtMethod.setModifiers(17);
                methodBuffer.append("return new ProxyCsStatement(raw." + methodName + "($$),this,p);");
            } else if (ctMethod.getReturnType() == ctDatabaseMetaDataClass) {
                methodBuffer.append("return new ProxyDatabaseMetaData(raw." + methodName + "($$),p);");
            } else {
                if (methodName.equals("close")) continue;
                if (ctMethod.getReturnType() == CtClass.voidType) {
                    methodBuffer.append("raw." + methodName + "($$);");
                } else {
                    methodBuffer.append("return raw." + methodName + "($$);");
                }
            }
            if (existsSQLException) {
                methodBuffer.append(" }catch(SQLException e){ p.checkSQLException(e);throw e;}");
            }
            methodBuffer.append("}");
            newCtMethod.setBody(methodBuffer.toString());
            ctConnectionClassProxyClass.addMethod(newCtMethod);
        }
    }

    private static void createProxyStatementClass(ClassPool classPool, CtClass statementProxyClass, CtClass ctStatementClass, CtClass ctStatementSuperClass) throws Exception {
        LinkedList<CtMethod> linkedList = new LinkedList<CtMethod>();
        HashSet<String> notNeedAddProxyMethods = ProxyClassGenerator.findMethodsNotNeedProxy(ctStatementSuperClass);
        ProxyClassGenerator.resolveInterfaceMethods(ctStatementClass, linkedList, notNeedAddProxyMethods);
        CtClass ctResultSetClass = classPool.get(ResultSet.class.getName());
        StringBuilder methodBuffer = new StringBuilder(50);
        String rawName = "raw.";
        if ("java.sql.PreparedStatement".equals(ctStatementClass.getName())) {
            rawName = "((PreparedStatement)raw).";
        } else if ("java.sql.CallableStatement".equals(ctStatementClass.getName())) {
            rawName = "((CallableStatement)raw).";
        }
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)statementProxyClass, null);
            newCtMethod.setModifiers(methodName.startsWith("execute") ? 17 : 1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{");
            boolean existsSQLException = ProxyClassGenerator.exitsSQLException(ctMethod.getExceptionTypes());
            if (existsSQLException) {
                methodBuffer.append("  try{");
            }
            if (ctMethod.getReturnType() == CtClass.voidType) {
                if (methodName.startsWith("execute")) {
                    methodBuffer.append("p.commitDirtyInd=!p.curAutoCommit;");
                }
                methodBuffer.append(rawName + methodName + "($$);");
                if (methodName.startsWith("execute")) {
                    methodBuffer.append("p.lastAccessTime=System.currentTimeMillis();");
                }
            } else if (methodName.startsWith("execute")) {
                methodBuffer.append("p.commitDirtyInd=!p.curAutoCommit;");
                methodBuffer.append(ctMethod.getReturnType().getName() + " r=" + rawName + methodName + "($$);");
                methodBuffer.append("p.lastAccessTime=System.currentTimeMillis();");
                if (ctMethod.getReturnType() == ctResultSetClass) {
                    methodBuffer.append("return r==null?null:new ProxyResultSet(r,this,p);");
                } else {
                    methodBuffer.append("return r;");
                }
            } else if (ctMethod.getReturnType() == ctResultSetClass) {
                methodBuffer.append(ctMethod.getReturnType().getName() + " r=" + rawName + methodName + "($$);");
                methodBuffer.append("return r==null?null:new ProxyResultSet(r,this,p);");
            } else {
                methodBuffer.append("return " + rawName + methodName + "($$);");
            }
            if (existsSQLException) {
                methodBuffer.append(" }catch(SQLException e){ p.checkSQLException(e);throw e;}");
            }
            methodBuffer.append("}");
            newCtMethod.setBody(methodBuffer.toString());
            statementProxyClass.addMethod(newCtMethod);
        }
    }

    private static void createProxyDatabaseMetaDataClass(ClassPool classPool, CtClass ctProxyDatabaseMetaDataClass, CtClass ctDatabaseMetaDataClass, CtClass ctDatabaseMetaDataSuperClass) throws Exception {
        LinkedList<CtMethod> linkedList = new LinkedList<CtMethod>();
        HashSet<String> notNeedAddProxyMethods = ProxyClassGenerator.findMethodsNotNeedProxy(ctDatabaseMetaDataSuperClass);
        ProxyClassGenerator.resolveInterfaceMethods(ctDatabaseMetaDataClass, linkedList, notNeedAddProxyMethods);
        CtClass ctResultSetClass = classPool.get(ResultSet.class.getName());
        StringBuilder methodBuffer = new StringBuilder(40);
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctProxyDatabaseMetaDataClass, null);
            newCtMethod.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{").append("this.owner.checkClosed();");
            boolean existsSQLException = ProxyClassGenerator.exitsSQLException(ctMethod.getExceptionTypes());
            if (existsSQLException) {
                methodBuffer.append("  try{");
            }
            if (ctMethod.getReturnType() == ctResultSetClass) {
                methodBuffer.append("ResultSet r = raw." + methodName + "($$);");
                methodBuffer.append("return r==null?null:new ProxyResultSet(r,p);");
            } else if (ctMethod.getReturnType() == CtClass.voidType) {
                methodBuffer.append("raw." + methodName + "($$);");
            } else {
                methodBuffer.append("return raw." + methodName + "($$);");
            }
            if (existsSQLException) {
                methodBuffer.append(" }catch(SQLException e){ p.checkSQLException(e);throw e;}");
            }
            methodBuffer.append("}");
            newCtMethod.setBody(methodBuffer.toString());
            ctProxyDatabaseMetaDataClass.addMethod(newCtMethod);
        }
    }

    private static void createProxyResultSetClass(ClassPool classPool, CtClass ctResultSetClassProxyClass, CtClass ctResultSetClass, CtClass ctResultSetClassSuperClass) throws Exception {
        LinkedList<CtMethod> linkedList = new LinkedList<CtMethod>();
        HashSet<String> notNeedAddProxyMethods = ProxyClassGenerator.findMethodsNotNeedProxy(ctResultSetClassSuperClass);
        ProxyClassGenerator.resolveInterfaceMethods(ctResultSetClass, linkedList, notNeedAddProxyMethods);
        CtClass ctResultSetMetaDataClass = classPool.get(ResultSetMetaData.class.getName());
        StringBuilder methodBuffer = new StringBuilder(25);
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctResultSetClassProxyClass, null);
            newCtMethod.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{");
            if (methodName.equals("close")) continue;
            boolean existsSQLException = ProxyClassGenerator.exitsSQLException(ctMethod.getExceptionTypes());
            if (existsSQLException) {
                methodBuffer.append("  try{");
            }
            if (methodName.startsWith("insert") || methodName.startsWith("update") || methodName.startsWith("delete")) {
                if (ctMethod.getReturnType() == CtClass.voidType) {
                    methodBuffer.append("raw." + methodName + "($$);").append(" p.updateAccessTime();");
                } else {
                    methodBuffer.append(ctMethod.getReturnType().getName() + " r=raw." + methodName + "($$);").append(" p.updateAccessTime();").append(" return r;");
                }
            } else {
                CtClass ctReturnType = ctMethod.getReturnType();
                if (ctReturnType == ctResultSetMetaDataClass) {
                    methodBuffer.append("return new ProxyResultSetMetaData(raw." + methodName + "($$),this,p);");
                } else if (ctReturnType == CtClass.voidType) {
                    methodBuffer.append("raw." + methodName + "($$);");
                } else {
                    methodBuffer.append("return raw." + methodName + "($$);");
                }
            }
            if (existsSQLException) {
                methodBuffer.append("  }catch(SQLException e){ p.checkSQLException(e);throw e;}");
            }
            methodBuffer.append("}");
            newCtMethod.setBody(methodBuffer.toString());
            ctResultSetClassProxyClass.addMethod(newCtMethod);
        }
    }

    private static void createProxyResultSetMetaDataClass(CtClass ctProxyResultSetMetaDataClass, CtClass ctResultSetMetaDataClass, CtClass ctResultSetMetaDataSuperClass) throws Exception {
        LinkedList<CtMethod> linkedList = new LinkedList<CtMethod>();
        HashSet<String> notNeedAddProxyMethods = ProxyClassGenerator.findMethodsNotNeedProxy(ctResultSetMetaDataSuperClass);
        ProxyClassGenerator.resolveInterfaceMethods(ctResultSetMetaDataClass, linkedList, notNeedAddProxyMethods);
        StringBuilder methodBuffer = new StringBuilder(40);
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctProxyResultSetMetaDataClass, null);
            newCtMethod.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{").append("this.owner.checkClosed();");
            boolean existsSQLException = ProxyClassGenerator.exitsSQLException(ctMethod.getExceptionTypes());
            if (existsSQLException) {
                methodBuffer.append("  try{");
            }
            if (ctMethod.getReturnType() == CtClass.voidType) {
                methodBuffer.append("raw." + methodName + "($$);");
            } else {
                methodBuffer.append("return raw." + methodName + "($$);");
            }
            if (existsSQLException) {
                methodBuffer.append(" }catch(SQLException e){ p.checkSQLException(e);throw e;}");
            }
            methodBuffer.append("}");
            newCtMethod.setBody(methodBuffer.toString());
            ctProxyResultSetMetaDataClass.addMethod(newCtMethod);
        }
    }

    private static boolean exitsSQLException(CtClass[] exceptionTypes) {
        if (exceptionTypes == null) {
            return false;
        }
        for (CtClass exceptionClass : exceptionTypes) {
            if (!"java.sql.SQLException".equals(exceptionClass.getName())) continue;
            return true;
        }
        return false;
    }
}

