/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import org.stone.beecp.pool.ConnectionPoolStatics;
import org.stone.beecp.pool.PooledConnection;
import org.stone.beecp.pool.ProxyBaseWrapper;
import org.stone.beecp.pool.ProxyStatementBase;
import org.stone.tools.CommonUtil;

public abstract class ProxyConnectionBase
extends ProxyBaseWrapper
implements Connection {
    protected Connection raw;

    ProxyConnectionBase(PooledConnection p) {
        super(p);
        this.raw = p.rawConn;
        p.proxyInUsing = this;
    }

    public final long getLassAccessTime() {
        return this.p.lastAccessTime;
    }

    public String toString() {
        return this.raw.toString();
    }

    final void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("No operations allowed after connection closed");
        }
    }

    final synchronized void registerStatement(ProxyStatementBase s) {
        this.p.registerStatement(s);
    }

    final synchronized void unregisterStatement(ProxyStatementBase s) {
        this.p.unregisterStatement(s);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        ProxyConnectionBase proxyConnectionBase = this;
        synchronized (proxyConnectionBase) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.raw = ConnectionPoolStatics.CLOSED_CON;
            if (this.p.openStmSize > 0) {
                this.p.clearStatement();
            }
        }
        this.p.recycleSelf();
    }

    @Override
    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        this.raw.setAutoCommit(autoCommit);
        this.p.setResetInd(0, autoCommit != this.p.defaultAutoCommit);
        if (autoCommit && !this.p.curAutoCommit) {
            this.p.commitDirtyInd = false;
        }
        this.p.curAutoCommit = autoCommit;
    }

    @Override
    public final void commit() throws SQLException {
        this.raw.commit();
        this.p.commitDirtyInd = false;
        this.p.lastAccessTime = System.currentTimeMillis();
    }

    @Override
    public final void rollback() throws SQLException {
        this.raw.rollback();
        this.p.commitDirtyInd = false;
        this.p.lastAccessTime = System.currentTimeMillis();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.raw.setTransactionIsolation(level);
        this.p.setResetInd(1, level != this.p.defaultTransactionIsolation);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.raw.setReadOnly(readOnly);
        this.p.setResetInd(2, readOnly != this.p.defaultReadOnly);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.raw.setCatalog(catalog);
        this.p.setResetInd(3, this.p.forceDirtyOnCatalogAfterSet || !CommonUtil.objectEquals(catalog, this.p.defaultCatalog));
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.raw.setSchema(schema);
        this.p.setResetInd(4, this.p.forceDirtyOnSchemaAfterSet || !CommonUtil.objectEquals(schema, this.p.defaultSchema));
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (!this.p.supportNetworkTimeoutSet()) {
            throw new SQLException("Driver not support 'networkTimeout'");
        }
        this.raw.setNetworkTimeout(executor, milliseconds);
        this.p.setResetInd(5, milliseconds != this.p.defaultNetworkTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(Executor executor) {
        ProxyConnectionBase proxyConnectionBase = this;
        synchronized (proxyConnectionBase) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.raw = ConnectionPoolStatics.CLOSED_CON;
            if (this.p.openStmSize > 0) {
                this.p.clearStatement();
            }
        }
        this.p.abortSelf();
    }
}

