/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.stone.beecp.pool.ConnectionPoolStatics;
import org.stone.beecp.pool.PooledConnection;
import org.stone.beecp.pool.ProxyBaseWrapper;
import org.stone.beecp.pool.ProxyConnectionBase;
import org.stone.beecp.pool.ProxyResultSetBase;

abstract class ProxyStatementBase
extends ProxyBaseWrapper
implements Statement {
    private final ProxyConnectionBase owner;
    protected Statement raw;
    boolean registered = true;
    private ProxyResultSetBase curRe;
    private ArrayList<ProxyResultSetBase> results;
    private int resultOpenCode = 1;

    ProxyStatementBase(Statement raw, ProxyConnectionBase o, PooledConnection p) {
        super(p);
        this.raw = raw;
        this.owner = o;
        this.owner.registerStatement(this);
    }

    void removeOpenResultSet(ProxyResultSetBase r) {
        if (r == this.curRe) {
            this.curRe = null;
        } else if (this.results != null) {
            this.results.remove(r);
        }
    }

    void setOpenResultSet(ProxyResultSetBase r) {
        switch (this.resultOpenCode) {
            case 1: {
                if (this.curRe == null || this.curRe.isClosed) break;
                ConnectionPoolStatics.oclose(this.curRe);
                break;
            }
            case 2: {
                if (this.curRe == null || this.curRe.isClosed) break;
                if (this.results == null) {
                    this.results = new ArrayList(1);
                }
                this.results.add(this.curRe);
                break;
            }
            case 3: {
                if (this.curRe != null && !this.curRe.isClosed) {
                    ConnectionPoolStatics.oclose(this.curRe);
                }
                if (this.results == null) break;
                for (ProxyResultSetBase openRe : this.results) {
                    if (openRe.isClosed) continue;
                    ConnectionPoolStatics.oclose(openRe);
                }
                this.results.clear();
                break;
            }
        }
        this.curRe = r;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("No operations allowed after statement closed");
        }
        return this.owner;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public final void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.curRe != null) {
            ConnectionPoolStatics.oclose(this.curRe);
        }
        if (this.results != null) {
            for (ProxyResultSetBase resultSetBase : this.results) {
                ConnectionPoolStatics.oclose(resultSetBase);
            }
            this.results.clear();
        }
        try {
            this.raw.close();
        }
        finally {
            this.raw = ConnectionPoolStatics.CLOSED_CSTM;
            if (this.registered) {
                this.owner.unregisterStatement(this);
            }
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.resultOpenCode = current;
        return this.raw.getMoreResults(current);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet re = this.raw.getResultSet();
        if (re == null) {
            return null;
        }
        if (this.curRe != null && this.curRe.containsRaw(re)) {
            return this.curRe;
        }
        if (this.results != null) {
            for (ProxyResultSetBase resultSetBase : this.results) {
                if (!resultSetBase.containsRaw(re)) continue;
                return resultSetBase;
            }
        }
        return ConnectionPoolStatics.createProxyResultSet(re, this, this.p);
    }

    @Override
    public void setPoolable(boolean var1) {
    }

    @Override
    public void closeOnCompletion() {
    }

    @Override
    public boolean isCloseOnCompletion() {
        return false;
    }

    public String toString() {
        return this.raw.toString();
    }
}

