/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.stone.beecp.pool.ProxyConnectionBase;

public final class XaProxyResource
implements XAResource {
    private final XAResource raw;
    private final ProxyConnectionBase proxyConn;

    XaProxyResource(XAResource raw, ProxyConnectionBase proxyConn) {
        this.raw = raw;
        this.proxyConn = proxyConn;
    }

    private void checkClosed() throws XAException {
        if (this.proxyConn.isClosed()) {
            throw new XAException("No operations allowed after XAConnection closed");
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.checkClosed();
        this.raw.start(xid, flags);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        this.checkClosed();
        return this.raw.prepare(xid);
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.checkClosed();
        this.raw.commit(xid, onePhase);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.checkClosed();
        this.raw.rollback(xid);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.checkClosed();
        this.raw.end(xid, flags);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.checkClosed();
        this.raw.forget(xid);
    }

    @Override
    public Xid[] recover(int xid) throws XAException {
        this.checkClosed();
        return this.raw.recover(xid);
    }

    @Override
    public boolean isSameRM(XAResource res) throws XAException {
        this.checkClosed();
        return this == res;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        this.checkClosed();
        return this.raw.getTransactionTimeout();
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.checkClosed();
        return this.raw.setTransactionTimeout(seconds);
    }
}

