/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.stone.beecp.pool.ProxyConnectionBase;

public class XaResourceLocalImpl
implements XAResource {
    private final ProxyConnectionBase proxyConn;
    private final boolean defaultAutoCommit;
    private Xid currentXid;

    XaResourceLocalImpl(ProxyConnectionBase proxyConn, boolean defaultAutoCommit) {
        this.proxyConn = proxyConn;
        this.defaultAutoCommit = defaultAutoCommit;
    }

    private void resetAutoCommitToDefault() {
        try {
            if (this.proxyConn.getAutoCommit() != this.defaultAutoCommit) {
                this.proxyConn.setAutoCommit(this.defaultAutoCommit);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void checkXid(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException("Xid can't be null");
        }
        if (this.currentXid == null) {
            throw new XAException("There is no current transaction");
        }
        if (!this.currentXid.equals(xid)) {
            throw new XAException("Invalid Xid,expected " + this.currentXid + ", but was " + xid);
        }
    }

    @Override
    public synchronized void start(Xid xid, int flags) throws XAException {
        if (xid == null) {
            throw new XAException("Xid can't be null");
        }
        if (flags == 0x200000) {
            if (this.currentXid != null) {
                throw new XAException("Resource has in a transaction");
            }
            try {
                if (this.proxyConn.getAutoCommit()) {
                    this.proxyConn.setAutoCommit(false);
                }
            }
            catch (SQLException e) {
                throw new XAException("Failed to set 'autoCommit' to false for transaction");
            }
            this.currentXid = xid;
        } else if (flags == 0x8000000) {
            if (this.currentXid == null) {
                throw new XAException("Resource not join in a transaction");
            }
            if (!xid.equals(this.currentXid)) {
                throw new XAException("Invalid Xid,expected " + this.currentXid + ", but was " + xid);
            }
        } else if (flags != 0) {
            throw new XAException(-8);
        }
    }

    @Override
    public synchronized void end(Xid xid, int flags) throws XAException {
        this.checkXid(xid);
    }

    @Override
    public synchronized int prepare(Xid xid) throws XAException {
        this.checkXid(xid);
        try {
            if (this.proxyConn.isReadOnly()) {
                this.resetAutoCommitToDefault();
                return 3;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        this.checkXid(xid);
        try {
            this.proxyConn.commit();
        }
        catch (SQLException e) {
            throw new XAException(e.getMessage());
        }
        finally {
            this.currentXid = null;
            this.resetAutoCommitToDefault();
        }
    }

    @Override
    public synchronized void rollback(Xid xid) throws XAException {
        this.checkXid(xid);
        try {
            this.proxyConn.rollback();
        }
        catch (SQLException e) {
            throw (XAException)new XAException().initCause(e);
        }
        finally {
            this.currentXid = null;
            this.resetAutoCommitToDefault();
        }
    }

    @Override
    public synchronized void forget(Xid xid) {
    }

    @Override
    public Xid[] recover(int flag) {
        return new Xid[0];
    }

    @Override
    public boolean isSameRM(XAResource xaResource) {
        return this == xaResource;
    }

    @Override
    public int getTransactionTimeout() {
        return 0;
    }

    @Override
    public boolean setTransactionTimeout(int transactionTimeout) {
        return false;
    }
}

